/*******************************************************************************
 * FILE:           fc_phoneaudio_tclAudioRoutingfi
 * PROJECT:        NISSAN LCN2kai
 * SW-COMPONENT:   FC_SMARTPHONEINTEGRATION
 *-------------------------------------------------------------------------------
 *
 * DESCRIPTION:    Implementation of audio routing interface.
 *
 *-------------------------------------------------------------------------------
 * COPYRIGHT:      (c) 2012 RBEI
 * HISTORY:
 * Date      | Author              | Modification
 * 03.09.12  | Ganesh &Praveen              | initial version(Refrence: Phone component)

 *
 *******************************************************************************/

/*******************************************************************************
| includes:
| 1) system- and project-includes
| 2) needed interfaces from external components
| 3) internal and external interfaces from this component
|-----------------------------------------------------------------------------*/
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif
// own header file
#include "FC_Phone_Audio.h"
#include "FC_Phone_AudioPlayer.h"

#include "../StateMachines/FC_Phone_SMIncludes.h"
#include "../FC_Phone_main.h"
#include "../FC_Phone_clienthandler_SystemState.h"
#include "../FC_Phone_clienthandler_BTSettings.h"

#ifdef PHONE_WAITINGMODE
#include "../WaitingMode/FC_Phone_WaitingMode.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_Audio.cpp.trc.h"
#endif

//NCG3D-18758. Timer introduced to release the channel in case no response from ARL after 3.5 secs
tVoid vWaitforARLResponseTimerCallBack(tU16 u16TimerID);

/*******************************************************************************
| defines and macros
| (scope: modul-local)
|-----------------------------------------------------------------------------*/



/*******************************************************************************
| function implementation
| (scope: global)
|-----------------------------------------------------------------------------*/
/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::fc_phoneaudio_tclAudioRoutingfi
 *
 * DESCRIPTION: constructor, creates object fc_phoneaudio_tclAudioRoutingfi
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *

 *
 *******************************************************************************/

fc_phoneaudio_tclAudioRoutingfi::fc_phoneaudio_tclAudioRoutingfi(fc_phone_tclApp* poMainAppl) :
      arl_tclISource(poMainAppl)
{
   ETG_TRACE_USR1(("fc_phoneaudio_tclAudioRoutingfi() entered."));

   /* copy the main pointer */
   __poMainAppl = poMainAppl;
   m_enArlSrc = ARL_SRC_NONE;
   m_TelService_instance = NULLPTR;
   m_szAlsaDeviceName = NULLPTR;
   m_bIsSA_Pause = false;

   m_bWaitForARLResponseTimerRunning = FALSE;
   m_u16AudioChannelIdForRunningTimer = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
}

tVoid  fc_phoneaudio_tclAudioRoutingfi::vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
{
   ETG_TRACE_USR4(("ENTER fc_phoneaudio_tclAudioRoutingfi::vSetTelServiceInstance."));
   m_TelService_instance = rfpTelServiceInstance ;
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::~fc_phoneaudio_tclAudioRoutingfi
 *
 * DESCRIPTION: destructor, destroys the object
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *

 *
 *******************************************************************************/
fc_phoneaudio_tclAudioRoutingfi::~fc_phoneaudio_tclAudioRoutingfi()
{
   ETG_TRACE_USR1(("~fc_phoneaudio_tclAudioRoutingfi() entered."));

   __poMainAppl = NULLPTR;
   m_TelService_instance = NULLPTR;

   if (m_szAlsaDeviceName)
   {
      OSAL_DELETE[] m_szAlsaDeviceName;
      m_szAlsaDeviceName = NULLPTR;
   }
}


/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::bOnAllocate
 *
 * DESCRIPTION: Allocate request from audio routing.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *              rfcoAllocRoute:         (I)   reference to Allocate route result
 *
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/
tBool fc_phoneaudio_tclAudioRoutingfi::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute)
{
   ETG_TRACE_USR1(("bOnAllocate() entered"));
   // get the alsa device in case of audiostreaming

   (tVoid) rfcoAllocRoute;

   if(ARL_SRC_PHONE == enSrcNum)
   {
      ecnrInitialize(PHONE_DATASET_1);
   }
   else if( ARL_SRC_PHONE_VR == enSrcNum)
   {
#ifdef PHONE_SEPARATE_ECNR_SET_SIRI //Task CMG3G-7981
      tU8 u8DataSet = 0;
      (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings->vGetVRDataSet(u8DataSet);
      ecnrInitialize(u8DataSet);
#else
      ecnrInitialize(PHONE_DATASET_3);
#endif
   }
#ifdef PHONE_WAITINGMODE
   else if (ARL_SRC_PHONE_WAIT == enSrcNum)
   {
      if (rfcoAllocRoute.listOutputDev.strALSADev.size())
      {
         tU32 u32StrLen = static_cast<tU32>(strlen(rfcoAllocRoute.listOutputDev.strALSADev[0].szValue) + 1);
         m_szAlsaDeviceName = new tChar[u32StrLen];
         if (m_szAlsaDeviceName)
         {
            memset(m_szAlsaDeviceName, '\0', u32StrLen);
            memcpy(m_szAlsaDeviceName, rfcoAllocRoute.listOutputDev.strALSADev[0].szValue, u32StrLen);

            ETG_TRACE_USR3(("bOnAllocate Alsa device name: %s", m_szAlsaDeviceName));

            FC_Phone_AudioPlayer* poAudioPlayer = FC_Phone_AudioPlayer::getInstance(); //gstreamer
            poAudioPlayer->setAlsaDevice(m_szAlsaDeviceName);
         }
         else
         {
            ETG_TRACE_USR4(("m_szAlsaDeviceName is NULL"));
         }
      }
      else
      {
         ETG_TRACE_USR4((" AlertTone - No Items in listOutputDev or more than 2 devices found"));
      }
   }
#endif
   return TRUE;

}


/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::bOnDeAllocate
 *
 * DESCRIPTION: Deallocate request from audio routing.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *
 * RETURNVALUE: TRUE

 *
 *******************************************************************************/
tBool fc_phoneaudio_tclAudioRoutingfi::bOnDeAllocate(arl_tenSource enSrcNum)
{
   ETG_TRACE_USR1(("bOnDeAllocate() entered"));
   (tVoid) enSrcNum;

   m_enArlSrc = ARL_SRC_NONE;

//   if (ARL_SRC_PHONE == enSrcNum || ARL_SRC_PHONE_VR == enSrcNum)
//   {
//      ecnrDestroy();
//   }
#ifdef PHONE_WAITINGMODE
   if (ARL_SRC_PHONE_WAIT == enSrcNum)
   {
      if (m_szAlsaDeviceName)
      {
         OSAL_DELETE[] m_szAlsaDeviceName;
         m_szAlsaDeviceName = NULLPTR;
      }
   }
#endif
   return TRUE;
}

tVoid fc_phoneaudio_tclAudioRoutingfi::SetSourceAvailable(tBool bSourceAvailable)
{
   ETG_TRACE_USR1(("SetSourceAvailable() entered"));

   vSetSrcAvailable(bSourceAvailable);
}

tVoid fc_phoneaudio_tclAudioRoutingfi::vSetSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 u16SubSource)
{
   ETG_TRACE_USR1(("vSetSourceAvailability() entered"));

   tBool bResult = bSetSourceAvailability(srcAvailability, availabilityReason, enSource, u16SubSource);
   if(!bResult)
   {
      ETG_TRACE_USR1(("bSetSourceAvailability() failed"));
   }
}

#if 0

tVoid fc_phoneaudio_tclAudioRoutingfi::vSendAckAndSrcActivityResult(tBool bSuccess)
{
   ETG_TRACE_USR1(("vSendAckAndSrcActivityResult() entered"));
   ETG_TRACE_USR1(("vSendAckAndSrcActivityResult() arlsrc: %d  Result:%d", m_enArlSrc, bSuccess));

   arl_tenActivity l_enArlActivity = ARL_EN_ISRC_ACT_OFF;
   tU8 u8EcnrSaStatus = (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vGetEcnrSaScoStatus();
   switch(m_enArlSrc)
   {
      case ARL_SRC_PHONE:
      {
         tU8 EcnrStartReq = u8EcnrSaStatus & EN_ECNR_STARTAUDIO;
         if(EN_ECNR_STARTAUDIO == EcnrStartReq)
         {
            ETG_TRACE_USR4((" sa-on "));
            /*if(bSuccess)
            {
            u8GrantStatus = FC_PHONE_AUDIOCHANNEL_GRANTED;
            l_enArlActivity = ARL_EN_ISRC_ACT_ON;
            }   */
            if(!bSuccess)
            {
               //u8GrantStatus = FC_PHONE_AUDIOCHANNEL_DENIED;
               //Currently we don't have macro to use in case of failure so using ARL_EN_ISRC_ACT_ON
               //l_enArlActivity = ARL_EN_ISRC_ACT_OFF;
               ETG_TRACE_USR1(("Audio routing failed, hence deallocating the channel"));
               (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->vResetChannelAttributes(FC_PHONE_AUDIOCHANNEL_PHONE);
               vTriggerPhoneAudioDeAllocation(m_enArlSrc);
            }
            //(fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(FC_PHONE_AUDIOCHANNEL_PHONE, u8GrantStatus);
         }
         else
         {
            tU8 IsSAPauseRxd;
            IsSAPauseRxd = u8EcnrSaStatus & EN_SA_PAUSE;
            if(EN_SA_PAUSE == IsSAPauseRxd)
            {
               ETG_TRACE_USR4(("Post method result for SA-Pause received "));
               l_enArlActivity = ARL_EN_ISRC_ACT_PAUSE;
            }
            else
            {
               ETG_TRACE_USR4(("Post method result for SA-OFF received "));
               //Release request ack has to be sent in case of failure or success
               (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32ReleaseRequestAck(FC_PHONE_AUDIOCHANNEL_PHONE);
               //Currently we don't have macro to use in case of failure so using ARL_EN_ISRC_ACT_OFF
               l_enArlActivity = ARL_EN_ISRC_ACT_OFF;
            }
            vSourceActivityResult(m_enArlSrc, l_enArlActivity);
         }
      }
      break;
      case ARL_SRC_PHONE_VR:
      {
         tU8 EcnrStartReq = u8EcnrSaStatus & EN_ECNR_STARTAUDIO;
         if(EN_ECNR_STARTAUDIO == EcnrStartReq)

         {
            if(!bSuccess)
            {
               ETG_TRACE_USR1(("Audio routing failed, hence deallocating the channel"));
               (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->vResetChannelAttributes(FC_PHONE_AUDIOCHANNEL_SPEECH);
               vTriggerPhoneAudioDeAllocation(m_enArlSrc);
            }
         }
         else
         {
            // Release request ack has to be sent in case of failure or success
            (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32ReleaseRequestAck(FC_PHONE_AUDIOCHANNEL_SPEECH);
            //Currently we don't have macro to use in case of failure so using ARL_EN_ISRC_ACT_OFF
            l_enArlActivity = ARL_EN_ISRC_ACT_OFF;
            vSourceActivityResult(m_enArlSrc, l_enArlActivity);
         }
      }
      break;
      default:
         ETG_TRACE_USR1(("vSendAckAndSrcActivityResult() invalid source"));
   }

   //vSourceActivityResult(m_enArlSrc, l_enArlActivity);
   ETG_TRACE_USR1((" exit vSendAckAndSrcActivityResult()"));
}
#endif

/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::bOnSrcActivity
 *
 * DESCRIPTION: Source activity request from audio routing.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *              rfcoSrcActivity:        (I)   source activity
 *
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/
tBool fc_phoneaudio_tclAudioRoutingfi::bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
   ETG_TRACE_USR1(("bOnSrcActivity() entered"));

   ETG_TRACE_USR1(("   SOURCE NUMBER: %u", enSrcNum));

   ETG_TRACE_USR1(("   SOURCE ACTIVITY: %u", rfcoSrcActivity.enType  ));

   tU8 u8EcnrSaStatus = 0;

   if (ARL_SRC_PHONE == enSrcNum)
   {
      u8EcnrSaStatus = (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vGetEcnrSaScoStatus();
   }
   else if (ARL_SRC_PHONE_VR == enSrcNum)
   {
      u8EcnrSaStatus = (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vGetEcnrSaScoStatus();
   }

   switch (rfcoSrcActivity.enType)
   {
      case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
      {
         ETG_TRACE_USR3((" FI_EN_OFF"));
         m_enArlSrc = enSrcNum;

         if ((ARL_SRC_PHONE == enSrcNum) || (ARL_SRC_PHONE_VR == enSrcNum))
         {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vResetSaScoEcnrInit(EN_SA_PAUSE);
            (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vResetSaScoEcnrInit(EN_SA_ON);
         }

         if( enSrcNum == ARL_SRC_PHONE || enSrcNum == ARL_SRC_PHONE_VR)
         {
            ETG_TRACE_USR1(("SA_OFF received for PHONE/VR..." ));
            tU8 EcnrStartReq = u8EcnrSaStatus & EN_ECNR_STARTAUDIO;
            ETG_TRACE_USR4(("EcnrStartReq %d ",EcnrStartReq ));
            tU8 EcnrInitReq = u8EcnrSaStatus & EN_ECNR_INIT;
            ETG_TRACE_USR4(("EcnrStartReq %d ",EcnrInitReq ));
            if(EN_ECNR_STARTAUDIO == EcnrStartReq || EN_ECNR_INIT == EcnrInitReq)
            {
               if(EN_ECNR_STARTAUDIO == EcnrStartReq)
               {
                  ecnrStopAudio();
               }
               //TODO : Check the sequences wrt StreamRouter for GM.
               ecnrDestroy();
               return true;
            }
            vProcessSourceActivity();
         }
#ifdef PHONE_WAITINGMODE
         else if (enSrcNum == ARL_SRC_PHONE_WAIT)
         {
            ETG_TRACE_USR1(("SA_OFF received for ARL_SRC_PHONE_WAIT..."));

            //PhoneWait source OFF is received since we requested for Phone source
            vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_OFF);
            if (FALSE == bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE_WAIT, 1), ARL_EN_ISRC_ACT_OFF))
            {
               ETG_TRACE_ERR(("Audio Release Request posting failed for PhoneWait source"));
            }

            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState m_enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            if (FC_PHONE_WAITINGMODE_STOP_IN_PROGRESS == m_enWaitingModeState)
            {
               //Wait for the ARL_SRC_PHONE source activation
            }
            else
            {
               //Audio source switch by ARL
               (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(
                     FC_PHONE_CB_FID_PHONEWAIT_SRC_OFF);
            }
         }
#endif
         else
         {
            vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_OFF);
         }
      }
      break;

      case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
      {
         ETG_TRACE_USR3((" FI_EN_ON"));

		 //NCG3D-18758 and Bug 176930 :Timer introduced to release the channel in case no response from ARL after 3.5 secs
         if(m_bWaitForARLResponseTimerRunning)
         {
            // Stop the timer
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(FC_PHONE_WAITFOR_ARL_RESPONSE_TIMER_ID);
            m_bWaitForARLResponseTimerRunning = FALSE;
            m_u16AudioChannelIdForRunningTimer = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" m_u16AudioChannelIdForRunningTimer = %d ",m_u16AudioChannelIdForRunningTimer));
            ETG_TRACE_USR3((" m_bWaitForARLResponseTimerRunning = FALSE "));
         }

         m_enArlSrc = enSrcNum;

         if ((ARL_SRC_PHONE == enSrcNum) || (ARL_SRC_PHONE_VR == enSrcNum))
         {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSetSaScoEcnrInit(EN_SA_ON);
         }

         if(enSrcNum == ARL_SRC_PHONE)
         {
            ETG_TRACE_USR1(("SA_ON received for PHONE..." ));
            tU8 IsSAPauseRxd = u8EcnrSaStatus & EN_SA_PAUSE;
            /* if(EN_SA_PAUSE != IsSAPauseRxd)
            {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(FC_PHONE_AUDIOCHANNEL_PHONE,FC_PHONE_AUDIOCHANNEL_GRANTED);
            }  */
            //(fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vResetSaScoEcnrInit(EN_SA_PAUSE);
            //vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_ON);
#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();
#endif

            if(EN_SA_PAUSE != IsSAPauseRxd)
            {    
#ifdef PHONE_WAITINGMODE
               if (FC_PHONE_WAITINGMODE_STOP_IN_PROGRESS == enWaitingModeState)
               {
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(FC_PHONE_CB_FID_PHONEWAIT_SRC_OFF);
                  vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_ON); //Added for WaitMode issue fix
               }
               else
               {
#endif
               //loop back to service and post the event to SM so as to proceed with accept call request to phone device.
              //(fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->bHandleSrcActivityInSM();
               (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(FC_PHONE_LB_FROM_ARL_FOR_SA_ON);
#ifdef PHONE_WAITINGMODE
               }
#endif
            }
            else
            {
#ifdef PHONE_WAITINGMODE
               if (FC_PHONE_WAITINGMODE_STOP_IN_PROGRESS == enWaitingModeState)
               {
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(FC_PHONE_CB_FID_PHONEWAIT_SRC_OFF);
               }
#endif
                ETG_TRACE_USR4(("sa on received after sa pause so post SA MR SM are already active.."));
               (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vResetSaScoEcnrInit(EN_SA_PAUSE);
               (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(FC_PHONE_LB_FROM_ARL_FOR_SA_PAUSE);
               vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_ON);
            }
         }
         else if(enSrcNum == ARL_SRC_PHONE_VR)
         {
            ETG_TRACE_USR1(("SA_ON received for BT_VR..." ));
            if(fc_phone_tclSM::m_poSMManager->bIsExternalVRSessionIdle())
            {
               fc_phone_tclSM::m_poSMManager->vProcessVREvent(FC_PHONE_SM_EVENT_CCX_VR_SA_ON);
            }
            else
            {
               fc_phone_tclSM::m_poSMManager->vProcessExtVREvent(FC_PHONE_SM_EVENT_CCX_VR_SA_ON);
            }
            tU8 IsSAPauseRxd = u8EcnrSaStatus & EN_SA_PAUSE;
            if(EN_SA_PAUSE != IsSAPauseRxd)
            {
               (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(FC_PHONE_AUDIOCHANNEL_SPEECH,FC_PHONE_AUDIOCHANNEL_GRANTED);
            }
         (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vResetSaScoEcnrInit(EN_SA_PAUSE);
         vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_ON);
         }
#ifdef PHONE_WAITINGMODE
         else if (enSrcNum == ARL_SRC_PHONE_WAIT)
         {
            ETG_TRACE_USR1(("SA_ON received for ARL_SRC_PHONE_WAIT..."));

            vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_ON);

            (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(
                  FC_PHONE_CB_FID_PHONEWAIT_SRC_ON);

         }
#endif
      }
      break;
      case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
      {
         ETG_TRACE_USR3((" FI_EN_PAUSE "));

         if ((ARL_SRC_PHONE == enSrcNum) || (ARL_SRC_PHONE_VR == enSrcNum))
         {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSetSaScoEcnrInit(EN_SA_PAUSE);
         }

         if(enSrcNum == ARL_SRC_PHONE || enSrcNum == ARL_SRC_PHONE_VR )
         {
            tU8 u8IsSaOnRxd = u8EcnrSaStatus & EN_SA_ON;
            ETG_TRACE_USR1(("u8IsSaOnRxd %d ", u8IsSaOnRxd ));
            if(EN_SA_ON == u8IsSaOnRxd)
            {
               ETG_TRACE_USR1(("SA_ON received for this channel, stop streaming audio and ACK SA_Pause ..." ));
               tU8 EcnrStartReq = u8EcnrSaStatus & EN_ECNR_STARTAUDIO;
               tU8 EcnrInitReq = u8EcnrSaStatus & EN_ECNR_INIT;
               if(EN_ECNR_STARTAUDIO == EcnrStartReq || EN_ECNR_INIT == EcnrInitReq)
               {
                  if(EN_ECNR_STARTAUDIO == EcnrStartReq)
                  {
                     ecnrStopAudio();
                  }
                  ecnrDestroy();
                  m_bIsSA_Pause = true;
                  return true;
               }
               vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_PAUSE);
            }
            else
            {
               ETG_TRACE_USR1(("SA_Pause received before SA_ON, Send ACK to StateMachines and post method result ..." ));
               if(enSrcNum == ARL_SRC_PHONE)
               {
#ifdef PHONE_WAITINGMODE
                  fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
                  tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

                  if (FC_PHONE_WAITINGMODE_STOP_IN_PROGRESS == enWaitingModeState)
                  {
                     //Waiting mode in progress, no need to send GetRequestAck since Audio request is made directly
                     //Attributes also updated directly.
                  }
                  else
                  {
#endif
                  ETG_TRACE_USR1(("PAUSE received for PHONE..." ));
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(FC_PHONE_AUDIOCHANNEL_PHONE,FC_PHONE_AUDIOCHANNEL_GRANTED);
#ifdef PHONE_WAITINGMODE
                  }
#endif
               }
               else if(enSrcNum == ARL_SRC_PHONE_VR)
               {
                  ETG_TRACE_USR1(("PAUSE received for BT_VR..." ));
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(FC_PHONE_AUDIOCHANNEL_SPEECH,FC_PHONE_AUDIOCHANNEL_GRANTED);
               }
               vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_PAUSE);
            }
         }
         else
         {
            vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_PAUSE);
         }
      }
      break;
      default:
         break;
   }
   return true; //CMG3G-4847 - To solve Lint
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::bOnMuteState
 *
 * DESCRIPTION: Result for own mute / demute request.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *              rfcoSrcActivity:        (I)   source activity
 *
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/
tBool fc_phoneaudio_tclAudioRoutingfi::bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState)
{
   /*Not implemented right now*/
   enSrcNum = enSrcNum;//Added to avoid lint warnings
   enMuteState = enMuteState;

   return TRUE;
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::vTriggerPhoneAudioAllocation
 *
 * DESCRIPTION: Request to ARL for channel allocation.
 *
 * PARAMETER:   u16AudioChannelId:               (I)   source number
 *              
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/

tBool fc_phoneaudio_tclAudioRoutingfi::vTriggerPhoneAudioAllocation(tU16 u16AudioChannelId)
{
   ETG_TRACE_USR4((" vTriggerPhoneAudioAllocation Called for Channel %d: ", u16AudioChannelId));

   //PSARCC30-1590. If system state is STANDBY, then ARL would not respond anything for our request. Hence, returning here itself with FALSE
   fc_phone_tclClientHandler_SystemState *p_ClientHdlerSystemState = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerSystemState;
   if(p_ClientHdlerSystemState->bIsSysteminStandByState())
   {
      ETG_TRACE_USR4(("System is in Standby state. Hence returning with FALSE."));
      return false;
   }

   if((u16AudioChannelId != FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE) && (u16AudioChannelId != FC_PHONE_AUDIOCHANNEL_ID_UNUSED))
   {
      //NCG3D-18758 and Bug 176930 : Timer introduced to release the channel in case no response from ARL after 3.5 secs
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(FC_PHONE_WAITFOR_ARL_RESPONSE_TIMER_ID, FC_PHONE_WAITFOR_ARL_RESPONSE_DURATION, vWaitforARLResponseTimerCallBack);
      m_bWaitForARLResponseTimerRunning = TRUE;
      m_u16AudioChannelIdForRunningTimer = u16AudioChannelId;
      ETG_TRACE_USR3((" m_u16AudioChannelIdForRunningTimer = %d ",m_u16AudioChannelIdForRunningTimer));
      ETG_TRACE_USR3((" m_bWaitForARLResponseTimerRunning = TRUE "));
   }

   switch(u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_PHONE:
      {
         SetSourceAvailable(TRUE);
         if(bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE,1),ARL_EN_ISRC_ACT_ON))
         {
            ETG_TRACE_USR4(("Set Phone Audio Request is success"));
            return true;
         }
         else
         {
            ETG_TRACE_USR4(("SetPhone Audio Request is failed"));
            //ack send when vtrigger returns false.
            return false;
         }
      }
      break;
      case FC_PHONE_AUDIOCHANNEL_SPEECH:
      {
         SetSourceAvailable(TRUE);
         if(bSetAudioRouteRequest(ARL_SRC_PHONE_VR,ARL_EN_ISRC_ACT_ON))
         {
            ETG_TRACE_USR4(("Set Speech channel request is success"));
            return true;
         }
         else
         {
            ETG_TRACE_USR4(("Set Speech channel request failed..."));
            return false;
         }
      }
      break;

      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         SetSourceAvailable(TRUE);
         //Temporarily sending "ARL_SRC_PHONE" as source num since exact source is still not available in ARL
         if(bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE,1), ARL_EN_ISRC_ACT_ON))
         {
            ETG_TRACE_USR4(("Set AlertTone channel request success"));
            return true;
         }
         else
         {
            ETG_TRACE_USR4(("Set AlertTone channel request failed"));
            return false;
         }
      }
      break;
#ifdef PHONE_WAITINGMODE
      case FC_PHONE_AUDIOCHANNEL_PHONEWAIT:
      {
         SetSourceAvailable(TRUE);

         if (FALSE == bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE_WAIT, 1), ARL_EN_ISRC_ACT_ON))
         {
            ETG_TRACE_ERR(("Audio Route Request posting failed for Phone Wait source"));
            return FALSE;
         }
         return TRUE;
      }
      break;
#endif
      default:
      {
         ETG_TRACE_USR4(("vTriggerPhoneAudioAllocation invalid channel id"));
         return false;
      }
   }
}

/*******************************************************************************
*
* FUNCTION: vWaitforARLResponseTimerCallBack
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid vWaitforARLResponseTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR3((" vWaitforARLResponseTimerCallBack ENTERED with u16TimerId %d ",u16TimerId));
   (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vTimerCallBack(u16TimerId);
}

/*******************************************************************************
*
* FUNCTION: vTimerCallBack
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid fc_phoneaudio_tclAudioRoutingfi::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR3((" vTimerCallBack of AudioRoutingfi ENTERED with u16TimerId %d ",u16TimerId));
   if (FC_PHONE_WAITFOR_ARL_RESPONSE_TIMER_ID == u16TimerId)
   {
      //m_u16AudioChannelIdForRunningTimer will be set to FC_PHONE_AUDIOCHANNEL_ID_UNUSED inside vTriggerPhoneAudioDeAllocation
      tU16 u16AudioChannelId = m_u16AudioChannelIdForRunningTimer;

      ETG_TRACE_USR3((" m_u16AudioChannelIdForRunningTimer = %d ",u16AudioChannelId));
      //Timer is stopped in vTriggerPhoneAudioDeAllocation
      bool bARLRootRequest = vTriggerPhoneAudioDeAllocation(m_u16AudioChannelIdForRunningTimer);
      if (bARLRootRequest)
      {
         ETG_TRACE_USR4(("PhoneAudioDeAllocation request is posted"));
      }
      else
      {
         ETG_TRACE_USR4(("PhoneAudioDeAllocation request posting has failed"));
      }

      (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(u16AudioChannelId, FC_PHONE_AUDIOCHANNEL_DENIED);
   }
   else
   {
      ETG_TRACE_ERR((" vTimerCallBack : Invalid timer id"));
   }
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::vTriggerPhoneAudioDeAllocation
 *
 * DESCRIPTION: Request to ARL for channel deallocation
 *
 * PARAMETER:   u16AudioChannelId:               (I)   source number
 *              
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/
tBool fc_phoneaudio_tclAudioRoutingfi::vTriggerPhoneAudioDeAllocation(tU16 u16AudioChannelId)
{
   ETG_TRACE_USR4((" vTriggerPhoneAudioDeAllocation Called..."));

   if((u16AudioChannelId != FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE) && (u16AudioChannelId != FC_PHONE_AUDIOCHANNEL_ID_UNUSED))
   {
      if(m_bWaitForARLResponseTimerRunning)
      {
         // Stop the timer
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(FC_PHONE_WAITFOR_ARL_RESPONSE_TIMER_ID);
         m_bWaitForARLResponseTimerRunning = FALSE;
         m_u16AudioChannelIdForRunningTimer = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" m_u16AudioChannelIdForRunningTimer = %d ",m_u16AudioChannelIdForRunningTimer));
         ETG_TRACE_USR3((" m_bWaitForARLResponseTimerRunning = FALSE "));
      }
   }

   switch(u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_PHONE:
      {
         if(bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE,1),ARL_EN_ISRC_ACT_OFF))
         {
            ETG_TRACE_USR4(("Set Phone Audio Request is success"));
            return true;
         }
         else
         {
            ETG_TRACE_USR4(("SetPhone Audio Request is failed"));
            return false;
         }
      }
      break;
      case FC_PHONE_AUDIOCHANNEL_SPEECH:
      {
         if(bSetAudioRouteRequest(ARL_SRC_PHONE_VR,ARL_EN_ISRC_ACT_OFF))
         {
            ETG_TRACE_USR4(("Deallocation of speech channel request is success"));
            return true;
         }
         else
         {
            ETG_TRACE_USR4(("Deallocation of speech channel request failed"));
            return false;
         }
      }
      break;
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         if (bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE, 1), ARL_EN_ISRC_ACT_OFF))
         {
            ETG_TRACE_USR4(("Deallocation of AlertTone Request successded"));
            return true;
         }
         else
         {
            ETG_TRACE_USR4(("Deallocation of AlertTone Request failed"));
            return false;
         }
      }
      break;
#ifdef PHONE_WAITINGMODE
      case FC_PHONE_AUDIOCHANNEL_PHONEWAIT:
      {
         if (FALSE == bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE_WAIT, 1), ARL_EN_ISRC_ACT_OFF))
         {
            ETG_TRACE_ERR(("Audio Release Request posting failed for Phone Wait source"));
            return FALSE;
         }
         return TRUE;
      }
      break;
#endif
      default:
      {
         ETG_TRACE_USR4(("vTriggerPhoneAudioDeAllocation invalid channel id"));
         return false;
      }
   }
}


/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::vPostSrcActivityMRToARL
 *
 * DESCRIPTION: Called from statemachine to post src activity MR after accept request is success
 *
 * PARAMETER:   bPostSuccess:               
 *              
 * RETURNVALUE: TRUE
 *
 *
 *
 *******************************************************************************/
tVoid fc_phoneaudio_tclAudioRoutingfi::vPostSrcActivityMRToARL(tBool bPostSuccess)
{
   ETG_TRACE_USR4((" vPostSrcActivityMRToARL Called..."));
   // post MR as SrcActivity as ON if accept call is successfull.
   tU8 u8EcnrSaStatus = (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vGetEcnrSaScoStatus();
   tU8 u8IsSAOnRxd = u8EcnrSaStatus & EN_SA_ON;
   (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->s32GetRequestAck(FC_PHONE_AUDIOCHANNEL_PHONE,FC_PHONE_AUDIOCHANNEL_GRANTED);
   (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vResetSaScoEcnrInit(EN_SA_PAUSE);

   if((EN_SA_ON == u8IsSAOnRxd))
   {
      vSourceActivityResult(ARL_SRC_PHONE,ARL_EN_ISRC_ACT_ON);
      if(FALSE == bPostSuccess)
      {
         // Deallocate channel as accept has failed.

         //Fix for NCG3D-4724 and NCG3D-4430. Channel attributes ahould also be updated on vTriggerPhoneAudioDeAllocation().
         //vTriggerPhoneAudioDeAllocation(FC_PHONE_AUDIOCHANNEL_PHONE);
         (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->vReleasePhoneChannel();
      }
   }
   else
   {
      ETG_TRACE_USR4((" SA_ON not received.This line should not be executed .."));
   }
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_tclAudioRoutingfi::vProcessSourceActivity
 *
 * DESCRIPTION: Called to process SA_OFF and SA_PAUSE;
 *               Sending vSourceActivityResult() to ARL
 *               Sending Response to SMs via AudioManager
 *
 * PARAMETER:   bPostSuccess:
 *
 * RETURNVALUE: TRUE
 *
 *
 *
 *******************************************************************************/
tVoid fc_phoneaudio_tclAudioRoutingfi::vProcessSourceActivity()
{
   ETG_TRACE_USR4((" vProcessSourceActivity Called..."));
   if (m_bIsSA_Pause)
   {
      ETG_TRACE_USR4((" m_bIsSA_Pause = TRUE. Hence SA_PAUSE was received "));
      m_bIsSA_Pause = false;
      vSourceActivityResult(m_enArlSrc, ARL_EN_ISRC_ACT_PAUSE);
   }
   else
   {
      if (m_enArlSrc == ARL_SRC_PHONE)
      {
         ETG_TRACE_USR4((" m_enArlSrc == ARL_SRC_PHONE "));
         fc_phone_tclAudioManager* poAudioManager =  (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager;
         NULL_CHECK(poAudioManager)
#ifdef PHONE_WAITINGMODE
         fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
         tenFC_Phone_WaitingModeState m_enWaitingModeState = poWaitingMode->enGetWaitingModeState();

         if ((FC_PHONE_WAITINGMODE_START_IN_PROGRESS == m_enWaitingModeState) && (!poAudioManager->bIsPhoneChannelRelease()))
         {
            //Since Phone Wait source is requested, Phone source OFF is received
            vSourceActivityResult(m_enArlSrc, ARL_EN_ISRC_ACT_OFF);
            if (FALSE == bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE, 1), ARL_EN_ISRC_ACT_OFF))
            {
               ETG_TRACE_ERR(("Audio Release Request posting failed for Phone source"));
            }
         }
         else
         {
#endif
            if(TRUE == poAudioManager->bIsPhoneOrRingtoneChannelAcquistionInRelease())
            {
               //eg if call is terminated , SA_OFF will be received, so sent ack alone as stop audio already done in SA_PAUSE.
               poAudioManager->s32ReleaseRequestAck(FC_PHONE_AUDIOCHANNEL_PHONE);
            }
            else
            {
               // Transfercall to hansdset when SA_OFF received externally.
               //(fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vTransferCallToHandset();
               (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioUtility->vSendLoopBackMessage(FC_PHONE_LB_FID_AUDIOTRANSFER_TO_HS);

               /*Fix for PSARCCB-8544
                * Setting the route request property to OFF, when ARL itself deallocates the source(due to external trigger)
                */
               vSourceActivityResult(m_enArlSrc,ARL_EN_ISRC_ACT_OFF);
               if (FALSE == bSetAudioRouteRequest(SourceID(ARL_SRC_PHONE, 1), ARL_EN_ISRC_ACT_OFF))
               {
                  ETG_TRACE_ERR(("Audio Release Request posting failed for Phone source"));
               }
               return;
               //End of Fix for PSARCCB-8544
            }
            vSourceActivityResult(m_enArlSrc,ARL_EN_ISRC_ACT_OFF);
#ifdef PHONE_WAITINGMODE
         }
#endif
      }
      else if (m_enArlSrc == ARL_SRC_PHONE_VR)
      {
         ETG_TRACE_USR4((" m_enArlSrc == ARL_SRC_PHONE_VR "));
         fc_phone_tclAudioManager* poAudioManager =  (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager;

         if(poAudioManager)
         {
            tU8 u8ChannelStatus = 0;
            poAudioManager->vGetChannelStatus(FC_PHONE_AUDIOCHANNEL_SPEECH, u8ChannelStatus);
            if((EN_SPEECH_CHNL_RELEASE_PROGRESS == poAudioManager->u8SpeechChannelStatus()) ||
                  (EN_SPEECH_CHNL_RELEASE_PROGRESS == u8ChannelStatus))
            {
               // This 'if' condition satisfies when the channel counter is not zero but the ReleaseRequest is in progress.
               // For SPECCH channel, this is possible only if there is a PENDING GetRequest.
               // Hence "FC_PHONE_SM_EVENT_CCX_VR_SA_OFF" is not handled in SM_VR. And only s32ReleaseRequestAck is handled.
               vSourceActivityResult(m_enArlSrc, ARL_EN_ISRC_ACT_OFF);
               //eg if call is terminated , SA_OFF will be received, so sent ack alone as stop audio already done in SA_PAUSE.
               poAudioManager->s32ReleaseRequestAck(FC_PHONE_AUDIOCHANNEL_SPEECH);
            }
            else
            {
               (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->vResetChannelAttributes(FC_PHONE_AUDIOCHANNEL_SPEECH);

               /*Fix for PSARCCB-8544
                * Setting the route request property to OFF, when ARL itself deallocates the source(due to external trigger)
                */
               vSourceActivityResult(m_enArlSrc, ARL_EN_ISRC_ACT_OFF);
               if (FALSE == (bSetAudioRouteRequest(ARL_SRC_PHONE_VR,ARL_EN_ISRC_ACT_OFF)))
               {
                  ETG_TRACE_ERR(("Audio Release Request posting failed for Phone source"));
               }

               if(!(fc_phone_tclSM::m_poSMManager->bIsExternalVRSessionIdle()))
               {
                  fc_phone_tclSM::m_poSMManager->vProcessExtVREvent(FC_PHONE_SM_EVENT_CCX_VR_SA_OFF);
               }
               else
               {
                  fc_phone_tclSM::m_poSMManager->vProcessVREvent(FC_PHONE_SM_EVENT_CCX_VR_SA_OFF);
                  //End of Fix for PSARCCB-8544
               }
            }
         }
         else
         {
            vSourceActivityResult(m_enArlSrc, ARL_EN_ISRC_ACT_OFF);
            fc_phone_tclSM::m_poSMManager->vProcessVREvent(FC_PHONE_SM_EVENT_CCX_VR_SA_OFF);
         }
      }
   }
}
