/*******************************************************************************
 *
 * FILE:        	FC_Messaging_SendMessage.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef FC_MESSAGING_SENDMESSAGE_H_
#define FC_MESSAGING_SENDMESSAGE_H_


#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"
#include "../DbusClient/FC_Messaging_Datatype.h"
#include "../DbusClient/FC_Messaging_DbusClient_MsgListData.h"
const QByteArray BLANK = " ";
const QByteArray SUBJECT_TERMINATOR = ":\r";

class SendMessage
{
private:
    SendMessage();
    ~SendMessage();
    SendMessage(const SendMessage&);

    static SendMessage* m_poSendMessageObject;

    // Create Message data
    most_msgfi_tclMsgCreateMessageMethodStart m_oCreateMessageMethodStart;

    // Send Message
    most_msgfi_tclMsgSendMessageMethodStart m_oSendMessageMethodStart;

    tBool m_bSaveMessageInDraft;

    // Data for Dbus
    QByteArray m_sDbusMessageHandle;
    QByteArray m_sSentMessageSubject;
    QByteArray m_sSentMessageData;
    QVector<AddressInfo> m_vRecipientInfo;
    AddressInfo m_oSenderInfo;

    tBool bSendMessageMapUpload();
    tVoid vSendMessageMapUploadData();

    friend class MessagingFunctionBlockDbusClient;
    friend class EvolutionDbusClient;

public:

    static tVoid vCreateSendMessageObject();

    static tVoid vDestroySendMessageObject();

    static SendMessage* poGetSendMessageInstance();

    tVoid vSetCreateMessageData(most_msgfi_tclMsgCreateMessageMethodStart &);

    tVoid vSetProvideMessageHeader(
            most_msgfi_tclMsgProvideMessageHeaderMethodStart &);

    tVoid vSetProvideMessageBody(
            most_msgfi_tclMsgProvideMessageBodyMethodStart &);

    tVoid vSendMessage(most_msgfi_tclMsgSendMessageMethodStart &);

    tVoid vSendMessageReturn(tU8 u8DeviceHandle, tU32 u32MessageHandleUpper,
                             tU32 u32MessageHandleLower, tU8 u8Status);

    tVoid vSendTextData();

    tVoid vRecentlySentMessageInfo(tU8 f_u8DeviceHandle, QString f_sServiceName,MsgListing_t* f_roMessageList);

    tU8 vGetDeviceHandle();
};

#endif /* FC_MESSAGING_SENDMESSAGE_H_ */
