/*******************************************************************************
 *
 * FILE:          FC_Messaging_alltypes.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:       BOSCH-GM-NEXTGEN
 *
 * DESCRIPTION:   Provides the implementation of the internal classes(getMessage Parsing)
 *                for FC_messaging
 *
 * AUTHOR:        Vaibhav Gupta
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#ifndef FC_MESSAGING_ALLTYPES_H_
#define FC_MESSAGING_ALLTYPES_H_
#include "../DbusClient/FC_Messaging_DbusClient_MsgRead.h"
//#include "../FC_Messaging_Debug.h"
//#include "../FC_Messaging_clienthandler_BluetoothSetings.h"
#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"

#include "../FC_Messaging_Defines.h"

#define FC_MESSAGING_CB_FID_BASE                     100
#define FC_MESSAGING_CB_FID_GET_INBOXMSGS            (FC_MESSAGING_CB_FID_BASE+1)
#define FC_MESSAGING_CB_FID_GET_SENTMSGS             (FC_MESSAGING_CB_FID_BASE+2)
#define FC_MESSAGING_CB_FID_CONSTRUCT_CONV_MSGS      (FC_MESSAGING_CB_FID_BASE+3)

//class fc_messaging_tclClientHandler_BluetoothSetings;
//class most_msgfi_tclMsgGetMessageMethodStart;
class most_msgfi_tclMsgGetMessageMethodResult;
//class most_msgfi_tclMsgGetAttachmentListMethodStart;
class most_msgfi_tclMsgGetAttachmentListMethodResult;
//class most_msgfi_tclMsgGetBodyPartListMethodStart;
class most_msgfi_tclMsgGetBodyPartListMethodResult;
class most_fi_tcl_MsgMessageHandle;

class most_msgfi_tclMsgCreateMessageMethodStart;
class most_msgfi_tclMsgProvideMessageHeaderMethodStart;
class most_msgfi_tclMsgProvideMessageBodyMethodStart;
class most_msgfi_tclMsgSendMessageMethodStart;

class most_msgfi_tclMsgCreateMessageMethodResult;
class most_msgfi_tclMsgProvideMessageHeaderMethodResult;
class most_msgfi_tclMsgProvideMessageBodyMethodResult;
class most_msgfi_tclMsgSendMessageMethodResult;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class msgHandleKey
{
   /*
    * This is the class for warpper of most_fi_tcl_MsgMessageHandle
    * so that FC_Messaging can use most_fi_tcl_MsgMessageHandle as key in
    * maps.
    */

public:
   most_fi_tcl_MsgMessageHandle m_messageHandl;
   msgHandleKey& operator=(const msgHandleKey& coRef);
   tBool operator==(const msgHandleKey& rfoCmp) const;
   tBool operator<(const msgHandleKey& rfoCmp) const;
   tVoid setkey(most_fi_tcl_MsgMessageHandle p_m_messageHandl);
   tBool isValid() const
   {
      if (m_messageHandl.u8DeviceHandle == 0
            && m_messageHandl.u32MsgHandleLower == 0
            && m_messageHandl.u32MsgHandleUpper == 0)
      {
         return false;
      }
      else
      {
         return true;
      }
   }
};

class msgList_GetMessage
{
private:

   //const most_msgfi_tclMsgGetMessageMethodStart* m_start;
   //Pointer to getMessage Result.
   most_msgfi_tclMsgGetMessageMethodResult* m_GetMsgResult;
   //Pointer to getBodyPartList result
   most_msgfi_tclMsgGetBodyPartListMethodResult* m_BodyPartResult;
   //Pointer to getAttachement result
   most_msgfi_tclMsgGetAttachmentListMethodResult* m_AttachListResult;
   //Pointer to resultItem found from the MsgList API.
   most_fi_tcl_MsgMessageListSliceResultItem m_msgListInfo;

   MsgRead_t m_MapReadMsg;
   tU32 m_msgLength;
   const tU32 MAX_LENGTH;
   int m_attachHandleToPlay;
   std::string attachFilePath;

   enum DATA_CODES
   {
      DATA_TEXT = 0,
      ATTACH_1 = 1,
      ATTACH_2 = 2,
      ATTACH_3 = 3,
      ATTACH_4 = 4,
      ATTACH_5 = 5
   };

   msgHandleKey m_mostMsgHandle;
   std::string m_Data[MAX_ATTACHMENT_NUM+1];
   std::string m_AttachName[MAX_ATTACHMENT_NUM+1];
   bool setDataFromDbus(const char* data,int size,int offset)
   {
      //MSG_DEBUG("SIZE OF DATA =%d OFFSET =%d",size , offset);

      //bool ret_bsetValue = m_Data[offset].bSet(data);

      m_Data[offset].erase();
      m_Data[offset].append(data,static_cast<unsigned int>(size));
      //strncpy(m_Data[offset].szValue ,data,size);
      return true;
   }

   bool supportedAudioAttachment(const char *extension );
   bool supportedImageAttachment(const char *extension );

public:

   msgList_GetMessage() :
      MAX_LENGTH(160) /*, m_mostMsgHandle() , m_Data() ,m_AttachName()*/
   {
      m_GetMsgResult = NULLPTR;
      m_BodyPartResult = NULLPTR;
      m_AttachListResult = NULLPTR;
      m_msgLength = 0;
      m_attachHandleToPlay=-1;
      callback = NULLPTR;
      attachFilePath ="";
   }

   ~msgList_GetMessage()
   {
      //free(m_GetMsgResult);
      m_GetMsgResult = NULLPTR;

      //free(m_BodyPartResult);
      m_BodyPartResult = NULLPTR;

      //free(m_AttachListResult);
      m_AttachListResult = NULLPTR;

      //delete m_MapReadMsg;
      //m_MapReadMsg = 0;
   }

   tVoid setmshHandle(msgHandleKey p_mostMsgHandle)
   {
      m_mostMsgHandle = p_mostMsgHandle;
   }
   msgHandleKey getmsgHandle() const
   {
      return m_mostMsgHandle;
   }
   msgList_GetMessage& operator=(const msgList_GetMessage& coRef); //Lint_Info 1720: assignment operator for class 'msgList_GetMessage' has non-const parameter

   tBool operator==(const msgList_GetMessage& rfoCmp) const;

   bool convertToMost_GetMessage(
         most_msgfi_tclMsgGetMessageMethodResult* p_result);

   bool convertToMost_GetAttachList(
         most_msgfi_tclMsgGetAttachmentListMethodResult* result);

   bool convertToMost_GetBodyPartList(
         most_msgfi_tclMsgGetBodyPartListMethodResult* result);

   tVoid ( *callback)(most_fi_tcl_MsgMessageHandle p_messageHandl);

   tVoid setListResultResult(
         const most_fi_tcl_MsgMessageListSliceResultItem& p_msg)
   {
      m_msgListInfo = p_msg;
   }
   tVoid setMsgResult(most_msgfi_tclMsgGetMessageMethodResult* p_GetMsgResult)
   {
      m_GetMsgResult = p_GetMsgResult;
   }
   most_msgfi_tclMsgGetMessageMethodResult* getMsgResult()
   {
      return m_GetMsgResult;
   }
   tVoid setAttachResult(
         most_msgfi_tclMsgGetAttachmentListMethodResult* p_AttachListResult)
   {
      m_AttachListResult = p_AttachListResult;
   }
   most_msgfi_tclMsgGetAttachmentListMethodResult* getAttachResult()
   {
      return m_AttachListResult;
   }
   tVoid setBodyPartResult(
         most_msgfi_tclMsgGetBodyPartListMethodResult* p_BodyPartResult)
   {
      m_BodyPartResult = p_BodyPartResult;
   }
   most_msgfi_tclMsgGetBodyPartListMethodResult* getBodyPartResult()
   {
      return m_BodyPartResult;
   }

   tVoid setDataFromDbus(MsgRead_t* p_MapReadMsg)
   {
      (tVoid) p_MapReadMsg; //lint fix
   }

   tVoid setAttachMentHandleToPlay(int handle)
   {
      m_attachHandleToPlay = handle;

      switch (handle)
      {
         case ATTACH_1:
         case ATTACH_2:
         case ATTACH_3:
         case ATTACH_4:
         case ATTACH_5:
         {
            attachFilePath.erase();
            attachFilePath.append(FC_MSG_DB_DIR_PATH1);
            attachFilePath.append(m_AttachName[handle].data());
            break;
         }
         default:
         break;
      }
   }
  
   const char* getAttachmentHandleToPlayFilePath()
   {
	   return attachFilePath.data();
   }
   std::string getAttachmentName(tU16 attachhandle)
   {
      return m_AttachName[attachhandle];
   }
   char * getAttachmentData(tU16 attachhandle)
   {
      return const_cast<char*>(m_Data[attachhandle].data());
   }

private :
   void getAttachments(MsgRead_t *dataToStore);
   int openAttcahment(char* fileName ,  int offset,MsgRead_t *dataToStore);
};

typedef enum enPredefMsgCreatType
{
   FC_MSG_SYS_PRE_DEF_MSG  = 1,
   FC_MSG_USER_PRE_DEF_MSG = 2
} tenPredefMsgCreatType;
 // CMG3G-8730 PSA - Predefined Message Template handling Extension
typedef enum enPredefMsgSubCat
{
   FC_MSG_NO_SUB_CATEGORY  = 0,
   FC_MSG_PRE_MSG_SUB_CAT_1 = 1,
   FC_MSG_PRE_MSG_SUB_CAT_2 = 2,
   FC_MSG_PRE_MSG_SUB_CAT_3 = 3,
   FC_MSG_PRE_MSG_SUB_CAT_4 = 4
} tenPredefMsgSubCat;

class MessagingTypes
{
public:
   static bool getUcidFromSourceNr( tU8 u8SourceNr, tU16* p_u16Ucid );
   static bool getSourceNrFromUcid( tU16 u16Ucid, tU8* p_u8SourceNr );
private:
   MessagingTypes(){}
   ~MessagingTypes(){}
   //MessagingTypes& operator = (const MessagingTypes& )
   //{
      //return *this;
   //}
   //MessagingTypes(const MessagingTypes &){}
protected:

};

//endif
#endif /* FC_MESSAGING_ALLTYPES_H_ */
