/*******************************************************************************
 *
 * FILE:          FC_Messaging_alltypes.cpp
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:       BOSCH-GM-NEXTGEN
 *
 * DESCRIPTION:   Provides the implementation of the internal classes
 *                (getMessage, NewMessage Parsing) for FC_messaging
 *
 * AUTHOR:        Vaibhav Gupta
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../FC_Messaging_Debug.h"
#include "FC_Messaging_alltypes.h"
#include "../FC_Messaging_main.h"
#include "../FC_Messaging_clienthandler_BluetoothSetings.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_alltypes.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

bool MessagingTypes::getUcidFromSourceNr( tU8 u8SourceNr, tU16* p_u16Ucid )
{
   ETG_TRACE_USR4(("getUcidFromSourceNr : CALLED-SOURCENR=%d",u8SourceNr));

   *p_u16Ucid = INVALID_UCID_OR_SOURCENR;

   switch( u8SourceNr )
   {
      case SOURCENR_REC_MESSAGE_TO_MOST_PLAYBACK :
      {
         ETG_TRACE_USR3(("SOURCENR_SOURCENR_REC_MESSAGE_TO_MOST_PLAYBACK"));
         *p_u16Ucid = UCID_RecMsgToMost_PLAYBACK;
      }
      break;

      case SOURCENR_NEW_MSG_ALERT_MESSAGING:
      {
         ETG_TRACE_USR3(("SOURCENR_NEW_MSG_ALERT_MESSAGING"));
         *p_u16Ucid = UCID_InMsgAlertToneToMost;
      }
      break;

      case SOURCENR_ATTACHMENT_PLAYBACK_MESSAGING:
      {
         ETG_TRACE_USR3(("SOURCENR_ATTACHMENT_PLAYBACK_MESSAGING"));
         *p_u16Ucid = UCID_AttachAudioFileToMost;
      }
      break;

      case SOURCENR_DEVICE_MEMORY_FULL_MESSAGING:
      {
         ETG_TRACE_USR3(("SOURCENR_DEVICE_MEMORY_FULL_MESSAGING"));
         *p_u16Ucid = UCID_DeviceMemoryFullToMost;
      }
      break;

      case SOURCENR_BEEP_REC_MESSAGING:
      {
         ETG_TRACE_USR3(("SOURCENR_RECORDING BEEP"));
         //*p_u16Ucid = UCID_BeepRecMsgToMost;
         //*p_u16Ucid =fc_messaging_tclClientHandler_AVManager::getCurrentRequestUCIDforRecordingBeep();

         // This if is to do MOST compliance if recording is not started and Beep is requested.
         if(*p_u16Ucid == INVALID_UCID_OR_SOURCENR)
         {
            *p_u16Ucid = UCID_BeepRecMsgToMost;
            //FC_Messaging_IAudioRecording::m_externalBeep =true;
         }
      }
      break;

      case SOURCENR_MIC:
      {
         ETG_TRACE_USR3(("SOURCENR_MIC"));
         *p_u16Ucid =UCID_MICToMsgRec;
      }
      break;

      default :
      {
         ETG_TRACE_ERR(("Not Correct Source nr code"));
      }
   }

   if(*p_u16Ucid == INVALID_UCID_OR_SOURCENR)
   {
      ETG_TRACE_USR3(("NOT CORRECT SOURCE NR_RECEIVED =%d",u8SourceNr));
   }

   return (INVALID_UCID_OR_SOURCENR != *p_u16Ucid);
}

bool MessagingTypes::getSourceNrFromUcid( tU16 u16Ucid, tU8* p_u8SourceNr )
{
   *p_u8SourceNr = INVALID_UCID_OR_SOURCENR;

   ETG_TRACE_USR4(("getSourceNrFromUcid: CALLED-for UCID =%d",u16Ucid));

   switch( u16Ucid )
   {
      case UCID_InMsgAlertToneToMost:
      {
         ETG_TRACE_USR3(("UCID_NEW_MSG_ALERT_MESSAGING"));
         *p_u8SourceNr = SOURCENR_NEW_MSG_ALERT_MESSAGING;
      }
      break;

      case UCID_AttachAudioFileToMost:
      {
         ETG_TRACE_USR3(("UCID_ATTACHMENT_PLAYBACK_MESSAGING"));
         *p_u8SourceNr = SOURCENR_ATTACHMENT_PLAYBACK_MESSAGING;
      }
      break;

      case UCID_DeviceMemoryFullToMost:
      {
         ETG_TRACE_USR3(("UCID_DEVICE_MEMORY_FULL_MESSAGING"));
         *p_u8SourceNr = SOURCENR_DEVICE_MEMORY_FULL_MESSAGING;
      }
      break;

      case UCID_RecLimitReached:
      {
         ETG_TRACE_USR3(("UCID_Recording Limit reached"));
         *p_u8SourceNr = SOURCENR_BEEP_REC_MESSAGING;
      }
      break;

      case UCID_BeepRecMsgToMost:
      {
         ETG_TRACE_USR3(("UCID_RECORDING START BEEP"));
         *p_u8SourceNr = SOURCENR_BEEP_REC_MESSAGING;
      }
      break;

      case UCID_RecMsgToMost_PLAYBACK:
      {
         ETG_TRACE_USR3(("UCID_RECORDING PLAYBACK UCID"));
         *p_u8SourceNr = SOURCENR_REC_MESSAGE_TO_MOST_PLAYBACK;
      }
      break;

      case UCID_MICToMsgRec:
      {
         ETG_TRACE_USR3(("UCID_MIC INPUT UCID"));
         *p_u8SourceNr = SOURCENR_REC_MESSAGE_TO_MOST_PLAYBACK;
      }
      break;

      default :
      {
         ETG_TRACE_ERR(("getSourceNrFromUcid: Not Correct UCID"));
      }
   }

   return (INVALID_UCID_OR_SOURCENR != *p_u8SourceNr);
}

void msgList_GetMessage::getAttachments(MsgRead_t *dataToStore)
{
   (void)dataToStore;
}

int msgList_GetMessage::openAttcahment(char* fileName ,  int offset,MsgRead_t *dataToStore)
{
   (void)fileName;
   (void)offset;
   (void)dataToStore;
   return 0;
}

/*******************************************************************************
 *
 * FUNCTION:  msgList_GetMessage::convertToMost_GetMessage
 *
 * DESCRIPTION:
 *              This is a message to convert the Data received from DBUS to
 *              Most getMessage Result.
 *
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
bool msgList_GetMessage::convertToMost_GetMessage(
        most_msgfi_tclMsgGetMessageMethodResult* p_result)
{
   (void)p_result;
   return true;
}

/*******************************************************************************
 *
 * FUNCTION: msgList_GetMessage::convertToMost_GetAttachList
 *
 * DESCRIPTION:
 *             This is a message to convert the Data received from DBUS to
 *              Most GetAttachList Result.
 *
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
bool msgList_GetMessage::convertToMost_GetAttachList(
        most_msgfi_tclMsgGetAttachmentListMethodResult* p_result)
{
   (void)p_result;
   return true;
}

bool msgList_GetMessage::supportedAudioAttachment(const char *fileName )
{
   ETG_TRACE_USR4(("supportedAudioAttachment CALLED for FileName =%s",fileName));

   if(!fileName)
   {
      ETG_TRACE_ERR(("NULL FILE NAME-EXIT"));
      return false;
   }

   std::string fn ;
   fn.append(fileName);

   ETG_TRACE_USR4(("1"));

   //AUDIO SUPPORTED FORMATS
   //wav, mp3, aac, wma, and ogg vobis can be played for AUDIO
   if(fn.substr(fn.find_last_of(".") + 1) == "wav" || fn.substr(fn.find_last_of(".") + 1) =="WAV")
   {
      // MSG_DEBUG("WAV FILE");
      return true;
   }
   else if(fn.substr(fn.find_last_of(".") + 1) == "mp3" || fn.substr(fn.find_last_of(".") + 1) =="MP3")
   {
      //MSG_DEBUG("MP3 FILE");
      return true;
   }
   else if(fn.substr(fn.find_last_of(".") + 1) == "aac" || fn.substr(fn.find_last_of(".") + 1) =="AAC")
   {
      // MSG_DEBUG("AAC FILE");
      return true;
   }
   else if(fn.substr(fn.find_last_of(".") + 1) == "ogg"|| fn.substr(fn.find_last_of(".") + 1) =="OGG")
   {
      // MSG_DEBUG("ogg FILE");
      return true;
   }
   else if(fn.substr(fn.find_last_of(".") + 1) == "vobis"|| fn.substr(fn.find_last_of(".") + 1) =="VOBIS")
   {
      // MSG_DEBUG("vobis FILE");
      return true;
   }
   else
   {
      ETG_TRACE_ERR(("supportedAudioAttachment: NO MATCHING AUDIO FILE"));
      return false;
   }
   return false;
}

bool msgList_GetMessage::supportedImageAttachment(const char *fileName )
{
   ETG_TRACE_USR4(("supportedImageAttachment CALLED for FileName =%s",fileName));
   if(!fileName)
   {
      ETG_TRACE_ERR(("NULL FILE NAME-EXIT"));
      return false;
   }
   std::string fn;
   fn.append(fileName);

   //IMAGE SUPPORTED FORMATS
   //Only files with the extension jpg, gif, or png can be displayed.
   if(fn.substr(fn.find_last_of(".") + 1) == "jpg" || fn.substr(fn.find_last_of(".") + 1) =="JPG")
   {
      //MSG_DEBUG("JPG FILE");
      return true;
   }
   else if(fn.substr(fn.find_last_of(".") + 1) == "gif"|| fn.substr(fn.find_last_of(".") + 1) =="GIF")
   {
      //MSG_DEBUG("GIF FILE");
      return true;
   }
   else if(fn.substr(fn.find_last_of(".") + 1) == "png"|| fn.substr(fn.find_last_of(".") + 1) =="PNG")
   {
      // MSG_DEBUG("PNG FILE");
      return true;
   }
   else
   {
      ETG_TRACE_ERR(("NO MATCHING IMAGE FILE"));
      return false;
   }
}
/*******************************************************************************
 *
 * FUNCTION: msgList_GetMessage::convertToMost_GetBodyPartList
 *
 * DESCRIPTION:
 *             This is a message to convert the Data received from DBUS to
 *              Most GetBodyPartList Result.
 *
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
bool msgList_GetMessage::convertToMost_GetBodyPartList(
        most_msgfi_tclMsgGetBodyPartListMethodResult* p_result)
{
   (void)p_result;
   return true;
}

/*******************************************************************************
 *
 * FUNCTION:  msgList_GetMessage::operator=
 *
 * DESCRIPTION:
 *              = Operator overloaded to Copy msgList_GetMessage .
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
msgList_GetMessage& msgList_GetMessage::operator=(
        const msgList_GetMessage& coRef)
{
   ETG_TRACE_USR4(("msgList_GetMessage& msgList_GetMessage::operator=CALLED"));

   if (this == &coRef)
      return *this; //Handling Self Assignment

   //m_GetMsgResult = new most_msgfi_tclMsgGetMessageMethodResult();
   if(m_GetMsgResult) //Lint fix
      *(this->m_GetMsgResult) = *coRef.m_GetMsgResult;

   //m_BodyPartResult = new most_msgfi_tclMsgGetBodyPartListMethodResult();
   if(m_BodyPartResult) //Lint fix
      *(this->m_BodyPartResult) = *coRef.m_BodyPartResult;

   //m_AttachListResult = new most_msgfi_tclMsgGetAttachmentListMethodResult();
   if(m_AttachListResult) //Lint fix
      *(this->m_AttachListResult) = *coRef.m_AttachListResult;

   //this->m_MapReadMsg.copy(coRef.m_MapReadMsg);
   this->setDataFromDbus(const_cast<MsgRead_t *>(&coRef.m_MapReadMsg)); //Info 1720: assignment operator for class 'msgList_GetMessage' has non-const parameter

   this->m_msgLength = coRef.m_msgLength;

   this->m_msgListInfo = coRef.m_msgListInfo;

   this->m_attachHandleToPlay = coRef.m_attachHandleToPlay;

   this->attachFilePath.erase();
   this->attachFilePath.append(coRef.attachFilePath);

   this->m_mostMsgHandle = coRef.m_mostMsgHandle;

   for(int loop=0; loop<MAX_ATTACHMENT_NUM+1;loop++)
   {
      tU32 lenData= static_cast<tU32>(coRef.m_Data[loop].size());
      //MSG_DEBUG("COPYING DATA LENGTH=%d",lenData);
      //this->m_Data[loop].szValue = OSAL_NEW tChar[lenData]+1;
      this->m_Data[loop].erase();
      this->m_Data[loop].append(coRef.m_Data[loop].data(),lenData);

      //int lenAttach= coRef.m_AttachName[loop].size();
      //MSG_DEBUG("COPYING ATTACH LENGTH=%d",lenAttach);
      this->m_AttachName[loop].erase();
      this->m_AttachName[loop].append(coRef.m_AttachName[loop]);
   }

   ETG_TRACE_USR4(("msgList_GetMessage& msgList_GetMessage::operator = RETURN"));

   return *this;
}

/*******************************************************************************
 *
 * FUNCTION:  msgList_GetMessage::operator==
 *
 * DESCRIPTION:
 *              == Operator overloaded to compare msgList_GetMessage
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
tBool msgList_GetMessage::operator==(const msgList_GetMessage& rfoCmp) const
      {
   tBool bResult = false;
   ETG_TRACE_USR4(("msgList_GetMessage& msgList_GetMessage::operator == CALLED"));
   if (m_msgListInfo == rfoCmp.m_msgListInfo && m_msgListInfo.oMessageHandle
         == rfoCmp.m_msgListInfo.oMessageHandle)
   {
      //MSG_DEBUG("EQUAL FOUND");
      bResult = true;
   }
   ETG_TRACE_USR4(("msgList_GetMessage& msgList_GetMessage::operator == RETURN"));
   return bResult;
}

////////////END CLASS msgList_GetMessage


///////////START CLASS msgHandleKey

/*******************************************************************************
 *
 * FUNCTION:  msgHandleKey::operator=
 *
 * DESCRIPTION:
 *              = Operator overloaded to Copy msgHandleKey .
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
msgHandleKey& msgHandleKey::operator=(const msgHandleKey& coRef)
{
   //MSG_DEBUG("classkeycomp::assiging = VALUES for MESSAGE HANDLE");
   if (this == &coRef)
      return *this;//Handling Self Assignment

   m_messageHandl.u8DeviceHandle = coRef.m_messageHandl.u8DeviceHandle;
   m_messageHandl.u32MsgHandleUpper = coRef.m_messageHandl.u32MsgHandleUpper;
   m_messageHandl.u32MsgHandleLower = coRef.m_messageHandl.u32MsgHandleLower;

   return *this;
}

/*******************************************************************************
 *
 * FUNCTION:  msgHandleKey::operator==
 *
 * DESCRIPTION:
 *              == Operator overloaded to compare msgHandleKey
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
tBool msgHandleKey::operator==(const msgHandleKey& rfoCmp) const
      {
   tBool bResult = true;
   //MSG_DEBUG("classkeycomp::comparing == VALUES for MESSAGE HANDLE");
   bResult = bResult && (m_messageHandl.u8DeviceHandle
         == rfoCmp.m_messageHandl.u8DeviceHandle);
   bResult = bResult && (m_messageHandl.u32MsgHandleUpper
         == rfoCmp.m_messageHandl.u32MsgHandleUpper);
   bResult = bResult && (m_messageHandl.u32MsgHandleLower
         == rfoCmp.m_messageHandl.u32MsgHandleLower);
   return bResult;
}

/*******************************************************************************
 *
 * FUNCTION:  msgHandleKey::operator<
 *
 * DESCRIPTION:
 *              < Operator overloaded to compare msgHandleKey
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
tBool msgHandleKey::operator<(const msgHandleKey& rfoCmp) const
{
   tBool bResult = true;
   // MSG_DEBUG("classkeycomp::comparing < VALUES for MESSAGE HANDLE");
   tBool bResult1 = true;
   tBool bResult2 = true;
   tBool bResult3 = true;
   bResult1 = bResult1 && (m_messageHandl.u8DeviceHandle
         < rfoCmp.m_messageHandl.u8DeviceHandle);
   bResult2 = bResult2 && (m_messageHandl.u32MsgHandleUpper
         < rfoCmp.m_messageHandl.u32MsgHandleUpper);
   bResult3 = bResult3 && (m_messageHandl.u32MsgHandleLower
         < rfoCmp.m_messageHandl.u32MsgHandleLower);

   bResult = (bResult1 || bResult2 || bResult3);

   return bResult;
}

/*******************************************************************************
 *
 * FUNCTION:  msgHandleKey::setkey
 *
 * DESCRIPTION:
 *            This is to set most_fi_tcl_MsgMessageHandle in msgHandleKey
 *
 * PARAMETER:
 * RETURNVALUE:
 *
 *******************************************************************************/
tVoid msgHandleKey::setkey(most_fi_tcl_MsgMessageHandle p_m_messageHandl)
{
   m_messageHandl.u8DeviceHandle = p_m_messageHandl.u8DeviceHandle;
   m_messageHandl.u32MsgHandleUpper = p_m_messageHandl.u32MsgHandleUpper;
   m_messageHandl.u32MsgHandleLower = p_m_messageHandl.u32MsgHandleLower;
}
////////////END CLASS msgHandleKey

//#endif
