#ifndef FC_MESSAGING_SETTINGS_H
#define FC_MESSAGING_SETTINGS_H

#include "FC_Messaging_PredefinedMsgList.h"

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"

class Settings
{
protected:
   //SystemWide Settings
   tU32 m_u32UpdateInboxTime;
   tU8  m_u8MsgLang;
   tBool m_bAutoUpdateInbox;

   //DeviceSettings
   tU16 m_u16AutoReplyText;

   FC_Messaging_PredefinedMsgList* m_poPredefinedMessageList;
   FC_Messaging_SQLite* m_poFC_Messaging_SQLite;

   Settings();

public:
   virtual ~Settings(); //Lint fix

   Settings(const Settings& ref);
   Settings& operator=(const Settings& ref);
   tBool bSetUpdateInboxTime(tU32 f_u32Time, tBool f_boolautoUpdate);
   tU32  u32GetUpdateInboxTime();

   tU8 	u8GetMessagingLanguage();
   tBool bSetMessagingLanguage(tU8 f_MsgLang);

   tU16  u16GetAutoReplyText(tU8 u8DeviceHandle);
   tBool bSetAutoReplyText(tU8 u8DeviceHandle, tU16 u16AutoReplyText);

   tBool bSetDeviceSpecificSetting(tU8 u8DeviceHandle, DeviceSettings enDeviceSpecificSetting, tBool bOnOffState);
   tBool bGetDeviceSpecificSetting(tU8 u8DeviceHandle, DeviceSettings enDeviceSpecificSetting);

   FC_Messaging_PredefinedMsgList* poGetPredefinedMessageListInstance();
};

class EmailSettings : virtual public Settings
{
protected:
   tBool m_bEmailAlert;
   tBool m_bSaveSentEmail;
   EmailSettings();

public:
   virtual ~EmailSettings(); //Lint fix
   tBool bSetEmailAlertSetting(tBool f_bSetting);
   tBool bGetEmailAlertSetting();

   tBool bSetSaveSentEmailSetting(tBool f_bSetting);
   tBool bGetSaveSentEmailSetting();
};


class TextSettings : virtual public Settings
{
protected:
   tBool m_bTextAlert;
   tBool m_bSaveSentText;
   TextSettings();

   tVoid vRestoreTextAlertSettingDefault();
   tVoid vRestoreSaveSentTextSettingDefault();

public:
   virtual ~TextSettings(); //Lint fix
   tBool bSetTextAlertSetting(tBool f_bSetting);
   tBool bGetTextAlertSetting();

   tBool bSetSaveSentTextSetting(tBool f_bSetting);
   tBool bGetSaveSentTextSetting();

   tVoid vRestoreTextSettingToDefault();

};

class MessagingSettings : public EmailSettings, public TextSettings
{
   static MessagingSettings* m_poMessagingSettings;
   MessagingSettings();

public:

   ~MessagingSettings() FINAL;
   static MessagingSettings* poGetMessagingSettingsInstance();
   static tVoid vDeleteMessagingSettingsInstance();
};

#endif // FC_MESSAGING_SETTINGS_H
