/*******************************************************************************
*
* FILE:          FC_Messaging_PredefinedMsgList.h
*
* SW-COMPONENT:  FC_Messaging application
*
* PROJECT:       BOSCH-GM-NEXTGEN
*
* DESCRIPTION:   Provides the implementation of Predefined Message functionality
* 
* AUTHOR:        Ravi K
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#if !defined(FC_Messaging_PredefinedMsgList_H__INCLUDED)
#define FC_Messaging_PredefinedMsgList_H__INCLUDED

#ifndef __PLACEMENT_NEW_INLINE
#define __PLACEMENT_NEW_INLINE 1
#endif

#include "FC_Messaging_alltypes.h"
#include "../Database/FC_Messaging_SQLite.h"

class FC_Messaging_PredefinedMsgList : public FC_Messaging_SQLite
{
public:
   FC_Messaging_PredefinedMsgList();
   ~FC_Messaging_PredefinedMsgList() FINAL;

   // Modified for CMG3G-8730 PSA - Predefined Message Template handling Extension
   tBool bAddPredefinedMessage(
      tU8 u8DeviceHandle,
      const most_fi_tcl_String& oTextMessage,
      tU16 u16Type,
      tU16 u16PredefMsgCreatType,
      tU16& u16Handle,
      tU16 u16SubCategory = 0 );

   tBool bDeletePredefinedMessage(tU16 u16Handle);

   tBool bEditPredefinedMessage(
      tU16 u16Handle ,
      most_fi_tcl_String& oTextToReplace,
      tU8 u8SubCategory = 0 );

   const most_fi_tcl_MsgPredefinedMessageListResult& oGetPredefinedMessageList();

   static void setLanguageSetting(tU8);

   static tU8 getLanguageSetting();

private:
   void vClearPredefinedMessageList();

   static tU8 u8CurrentLanguageSetting;
};

#endif//FC_Messaging_PredefinedMsgList_H__INCLUDED
