/*******************************************************************************
*
* FILE:          FC_Messaging_PredefinedMsgList.cpp
*
* SW-COMPONENT:  FC_Messaging application
*
* PROJECT:       BOSCH-GM-NEXTGEN
*
* DESCRIPTION:   Provides the implementation of most messaging functions
*
* AUTHOR:        Ravi K
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "FC_Messaging_PredefinedMsgList.h"
#include "../FC_Messaging_main.h"
#include "../Database/FC_Messaging_SQLite.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_PredefinedMsgList.cpp.trc.h"
#endif

tU8 FC_Messaging_PredefinedMsgList::u8CurrentLanguageSetting  = 0;

FC_Messaging_PredefinedMsgList::FC_Messaging_PredefinedMsgList()
{
   //bCreatePredefinedMessageDatabase();
}

FC_Messaging_PredefinedMsgList::~FC_Messaging_PredefinedMsgList()
{
   ETG_TRACE_USR4(("~FC_Messaging_PredefinedMsgList : Called"));
}

// Modified for CMG3G-8730 PSA - Predefined Message Template handling Extension
tBool FC_Messaging_PredefinedMsgList::bAddPredefinedMessage
(
      tU8 u8DeviceHandle,

      //! [IN] New Predef Msg string
      const most_fi_tcl_String& oTextMessage,

      //! [IN] Predefined Message type:
      //! 1 : Static
      //! 2 : Intersection
      //! 3 : ETA
      tU16 u16PredefMsgType,

      //! [IN] CreationType
      //! 1 : System created messages
      //! 2 : User created messages
      tU16 u16PredefMsgCreatType,

      //! [OUT] Unique Handle for inserted message
      tU16& u16Handle,
      tU16 u16SubCategory
)
{
   ETG_TRACE_USR4(("bAddPredefinedMessage : Called Handle = %d",u16Handle));

   QString qStrTextMessage( oTextMessage.szValue );

   tU16 format_count = (tU16)qStrTextMessage.count("%%");

   if(format_count==1)
   {
      u16PredefMsgType = (tU16) most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_DYNAMIC_ETA;
   }
   else if(format_count==2)
   {
      u16PredefMsgType = (tU16) most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_DYNAMIC_INTERSECTION;
   }

   tBool bReturn = FALSE;
   tU8 u8CurrentLanguageSettingValue = 0;

   u8CurrentLanguageSettingValue = getLanguageSetting();

   bReturn = bQueryInsertIntoPredefinedMessage
         (
               u8DeviceHandle,
               qStrTextMessage,
               (quint16) u16PredefMsgType,
               u16PredefMsgCreatType,
               u16Handle,
               u8CurrentLanguageSettingValue,
               (quint16) u16SubCategory
         );

   return bReturn;
}

tBool FC_Messaging_PredefinedMsgList::bDeletePredefinedMessage
(
      //! [IN] Handle of the predefined message to be deleted
      tU16 u16Handle
)
{
   ETG_TRACE_USR4(("bDeletePredefinedMessage : Called Handle = %d",u16Handle));

   tBool bReturn = FALSE;

   bReturn = bQueryDeleteFromPredefinedMessage(u16Handle);

   return bReturn;
}

tBool FC_Messaging_PredefinedMsgList::bEditPredefinedMessage
(
      tU16 u16Handle,
      most_fi_tcl_String& oTextToReplace,
      tU8 u8SubCategory
)
{
   ETG_TRACE_USR4(("bEditPredefinedMessage called"));
   ETG_TRACE_USR4(("bEditPredefinedMessage ::Handle = %d", u16Handle));
   ETG_TRACE_USR4(("bEditPredefinedMessage ::Text = %s", oTextToReplace.szValue));
   ETG_TRACE_USR4(("bEditPredefinedMessage ::SubCategory = %d", u8SubCategory));

   QString qStrTextToReplace(oTextToReplace.szValue);

   tBool bReturn = FALSE;

   bReturn = bQueryUpdatePredefinedMessage(u16Handle, qStrTextToReplace,u8SubCategory);

   return bReturn;
}

const most_fi_tcl_MsgPredefinedMessageListResult& FC_Messaging_PredefinedMsgList::oGetPredefinedMessageList()
{
   //clear before populating
   vClearPredefinedMessageList();

   vQuerySelectPredefinedMessageList();
   return m_oPredefinedMessageListResult;
}

void FC_Messaging_PredefinedMsgList::vClearPredefinedMessageList()
{
   m_oPredefinedMessageListResult.vDestroy();
   m_oPredefinedMessageListResult.oItems.clear();
}

void FC_Messaging_PredefinedMsgList::setLanguageSetting(tU8 u8LanType)
{
   ETG_TRACE_USR4(("FC_Messaging_PredefinedMsgList::setLanguageSetting :: u8LanType=%d",u8LanType));
   u8CurrentLanguageSetting = u8LanType;
}

tU8 FC_Messaging_PredefinedMsgList::getLanguageSetting()
{
   return u8CurrentLanguageSetting;
}

