/*
 * FC_Messaging_FileSystemManager.h
 *
 *  Created on: Dec 15, 2011
 *      Author: rakesh
 */

#ifndef FC_MESSAGING_FILESYSTEMMANAGER_H_
#define FC_MESSAGING_FILESYSTEMMANAGER_H_

#include "FC_Messaging_FileSystem.h"
#include "../DbusClient/FC_Messaging_DbusClient_MsgListData.h"
#include "../DbusClient/FC_Messaging_DbusClient_MsgRead.h"
#include "../../Configuration/Messaging/Msg_FeatureConfig.h"

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"
#include "../DbusClient/FC_Messaging_Macro.h"

#define MSG_LIST_CHANGE_NOTIFY_COUNT 5 /* Fix for GMMY15-10748, GMMY15-10758 and GMMY15-10756 */

bool bCompareByTimeStamp(const most_fi_tcl_MsgMessageListSliceResultItem& item1, const most_fi_tcl_MsgMessageListSliceResultItem& item2);

bool bCompareConversationByTimeStamp(const most_fi_tcl_MsgConversationListSliceResultItem& item1, const most_fi_tcl_MsgConversationListSliceResultItem& item2);

bool bCompareConversationDetailByTimeStamp(const most_fi_tcl_MsgConversationDetailListItem& item1, const most_fi_tcl_MsgConversationDetailListItem& item2);

int timeStampCompareResult(const most_fi_tcl_MsgMessageDateTime& dateTime1, const most_fi_tcl_MsgMessageDateTime& dateTime2);

struct MessageTypeDbusMessageHandleInfo
{
   most_fi_tcl_e8_MsgMessageListType m_oMessageListType;
   QString m_sDbusMessageHandle;
};

struct NewIncomingMessageInfo
{
   most_fi_tcl_MsgMessageHandle m_oMessageHandle;
   QString m_sSenderAddress;
   QString m_sSenderName; /* Bugfix for GMMY16-5286 */
   tU8 m_u8MessageType;
};

const tU8 g_u8NumConversationMessage = 20;
const tU8 g_u8PhoneNumberLength = 10;

class FileSystemManager : public FileSystem
{
private:
   tU8 m_u8ServiceNameId;

   QString m_sRequestFolderListInProgressFolderName;

   most_fi_tcl_MsgMessageHandle m_oLastGetMessageHandle;

   /* Bugfix for GMMY16-5367 : Selected view on new message alert and nothing happened
    * and GMMY16-5368 : Message inbox was missing many of the newest messages */
   most_msgfi_tclMsgCreateMessageListMethodStart m_oLastCreateMessageListMethodStart;

   most_fi_tcl_e8_MsgMessageListFilterType::tenType m_MessageListfilterType;

   most_fi_tcl_MsgMessageDetailsResult m_oMessageDetailsResult;

   QString m_sCreateMessageListInProgressFolderName;

   static tU32 m_u32MostUpperHandle;

   static tU32 m_u32ConversationID;
   QMap<QString, tU32> m_mapPhoneNoAndConversationID;

   static QMap<tU32, MessageTypeDbusMessageHandleInfo> m_DbusMessageHandleAndMostUpperHandleMap;

   static QList<most_fi_tcl_MsgMessageHandle> m_lMessageHandlesListForDelete;
   static most_msgfi_tclMsgDeleteMessageMethodStart m_oDeleteMessageMethodStart;
   static most_fi_tcl_MsgMessageHandle m_oCurrentDeleteMessageHandle;

   QList<most_fi_tcl_MsgMessageHandle> m_lUnreadMessageHandlesList;
   most_fi_tcl_MsgMessageHandle m_oCurrentSetMessageHandle;

   QList<most_fi_tcl_MsgMessageHandle> m_lReadingMessageHandlesList;

   //CMG3G-1494
   static most_fi_tcl_e8_MsgMessageListType::tenType enCurrentMessageListType;

   QVector<most_fi_tcl_ShortStream> m_vConversationMessageHandles;

   e8GetMessageCaller m_eGetMessageCaller;

   most_msgfi_tclMsgRequestFolderListMethodResult

   m_oRequestFolderListMethodResult_MR;

   tU8 m_u8NumSubfolders;

   tU8 m_u8NumTotalMessage;

   tU8 m_u8InboxFolderPosition;

   enCreateMessageListRequest m_enCreateMessageListRequest;

   most_msgfi_tclMsgGetConversationMessagesMethodStart m_oGetConversationMessagesMethodStart;

   /* Bugfix for GMMY15-11135 */
   tBool m_bGetMsgFailure;

   tU32 u32ConvertDbusHandleToMostHandle(QString f_sDbusMessageHandle);

   tVoid vFillDateTime(MsgListing_t*, most_fi_tcl_MsgMessageListSliceResultItem*);

   tVoid
   bGetConversationMessageHandles(most_msgfi_tclMsgGetConversationMessagesMethodStart& f_roGetConversationMessagesMethodStart);

   tU32 u32FindConversationMessageHandlesInList(most_fi_tcl_MsgMessageListSliceResultItem& f_roMessageListSliceResultItem);

   tVoid vAddMessageinConversationList(most_fi_tcl_MsgMessageListSliceResultItem& messageListSliceResultItem,
         tU32 attachmentSize, most_fi_tcl_e8_MsgMessageStatus::tenType messageStatus,
         most_fi_tcl_e8_MsgAddressFieldType::tenType addressFieldType);

   tVoid vFillMsgStatusAndAddressFieldType(most_fi_tcl_e8_MsgFolderType::tenType folderType, MsgListing_t* f_poMsgList,
         most_fi_tcl_e8_MsgMessageStatus::tenType &messageStatus, most_fi_tcl_e8_MsgAddressFieldType::tenType &addressFieldType);

   tVoid vUpdateMessageContentInConversationDetailList(most_fi_tcl_MsgMessageHandle oMessageHandle, QString sMessageContent);

   tVoid vUpdateShortMessageInMessageList(most_fi_tcl_MsgMessageHandle oMessageHandle, QString sMessageContent);

   tVoid vUpdateSubjectInConversationList(tU32 u32ConversationID, QString sSubject);

   tVoid vUpdateReadStatusFlagInConversationDetailList(most_fi_tcl_MsgMessageHandle oMessageHandle, tBool bReadStatusFlag);

   tVoid vUpdateReadStatusFlagInConversationList(tU32 u32ConversationID, tBool bReadStatusFlag);

   tVoid vDeleteMessageFromConversationList(most_fi_tcl_MsgMessageHandle);

   tBool bSortMessageList(QVector<most_fi_tcl_MsgMessageListSliceResultItem>* pMessageList);

   QString sReverse(const QString f_sStr);

   static tBool bDeleteMessageFromDevice();

   friend class SendMessage;

   static QList<NewIncomingMessageInfo> m_lNewIncoimgMessageInfoList;

   // Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   // Fix for GMMY15-10748, GMMY15-10758 and GMMY15-10756
   void vSendNewMessageListChange();

   // Bugfix for GMMY16-18639, GMMY16-19799: FirstName, LastName returned should
   // not be a phone number and PhoneNumber returned should always be valid
   tCString sGetName(most_fi_tcl_String);

public:
   FileSystemManager();

   ~FileSystemManager() FINAL;
   //CMG3G-1494
   static most_fi_tcl_e8_MsgMessageListType::tenType enGetCurrentMessageListType();

   tVoid vSortMessageList(tU8 u8Position = 0);

   tVoid vSetCreateMessageListInProgressFolderName(QString);

   tVoid vSetServiceNameId(tU8 f_u8ServiceNameId);

   tVoid vRequestFolderList(tU32 f_u32FolderHandle, tBool f_bRootFlag);

   tVoid vRequestFolderListResultFromDevice(QString f_sFolderName, tU8 u8DeviceHandle);

   tVoid vRequestFolderListReturnToClient(tU8 f_u8NumSubFolder);

   tU8 u8CheckAllMessageLists(tU8 f_u8DeviceHandle, enCreateMessageListRequest createMessageListRequest = e8CreateMessageListRequestInvalid);

   tVoid vCreateMessageList(most_msgfi_tclMsgCreateMessageListMethodStart&);

   tU32 u32AddMessageInList(tU8 f_u8DeviceHandle, MsgListing_t* f_poMsgList);

   tVoid vCreateMessageListComplete();

   tVoid vGetMessage(most_fi_tcl_MsgMessageHandle& f_roMessageHandle, e8GetMessageCaller f_eGetMessageCaller);

   tVoid vGetMessageResult(MsgRead_t* f_poMsgRead);

   tVoid vGetMessagesForConversation();

   tVoid vGetMessagesForSubject(most_fi_tcl_MsgMessageHandle f_roMessageHandle);

   tVoid vDeleteMessageMethodReturn(tBool f_bStatus);

   tVoid vMessageDeletedFromDevice(tU8 f_u8DeviceHandle, tU8* f_pu8MessageHandle, tU16 f_u16MessageHandleLen);

   tVoid vSetMsgUnreadMessageHandles(QList<most_fi_tcl_MsgMessageHandle> oUnreadMessageHandles);

   tVoid vSetMsgReadStatusFlagInDevice();

   tVoid vRemoveDbusMessageHandleonDeletion(tU32 l_u32UpperHandle);

   tVoid vSetMsgReadStatusReturn(tU8 u8Status);

   tBool bFindConversationMessages(most_msgfi_tclMsgGetConversationMessagesMethodStart& f_roGetConversationMessagesMethodStart);

   tBool bSortConversationList(QVector<most_fi_tcl_MsgConversationListSliceResultItem>* pConversationList);

   tBool bSortConversationDetailList(QVector<most_fi_tcl_MsgConversationDetailListItem>* pConversationDetailList);

   static FileSystemManager* poFileSystemManager(most_fi_tcl_MsgMessageHandle& f_roMostMessageHandle);

   tVoid vRequestFolderListGetSubFolderReturn(tU8 f_u8NumSubfolders);

   tVoid vRequestFolderListGetMessageCountReturn(tU8 f_u8NumMessages);

   tVoid vRequestFolderListGetUnReadMessageCountReturn(tU8 f_u8NumMessages);

   static tBool
   bDeleteMessageMethodStart(most_msgfi_tclMsgDeleteMessageMethodStart& roDeleteMessageMethodStart);

   tVoid vNewIncomingMessageReceived(tU8 f_u8DeviceHandle, MsgListing_t* f_poMessageList);

   tBool bRecoverMessageStart(most_fi_tcl_MsgMessageHandle& f_roMessageHandle);

   /* Fix for GMMY15-10748, GMMY15-10758 and GMMY15-10756 */
   static tVoid vSendNewMessageAlert(QString, QString, NewIncomingMessageInfo* f_poNewIncoimgMessageInfo = NULL);

   //gmmy15_8172 : Text message remains in inbox when deleted from phone
   tU32 u32ConvertDbusHandleToUpperHandle(QString f_sDbusMessageHandle);
   //CMG3G-1494
   tBool bMessageDeletedFromPhoneDevice(tU32 l_u32UpperHandle, tU8 u8FolderType, tU8 u8MessageType);

   tBool bMessageReadStatusChanged(tU32 l_u32UpperHandle, tU8 u8FolderType);

   /* Bugfix for GMMY15-5992 Large empty gap is present in text messages list */
   QString sGetCreateMessageListInProgressFolderName();
   tVoid vMessageListChangeNotify(tU16 f_u16ListHandle, tU32 f_u32ListLength,
         most_fi_tcl_e8_MsgListChangeType::tenType f_oListChangeType, tU32 f_u32ChangeItemIndex);

   /* Bugfix for GMMY15-9182 Incomplete message details view is shown */
   static tVoid vResetNewMsgHandleListAndFolderHandle();

   /* Bugfix for GMMY15-11135 */
   e8GetMessageCaller e8CurrentGetMessageCaller();
   tVoid vSetGetMessageFailure(tBool);

   // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
   void vMessageNotify(most_fi_tcl_MsgMessageHandle f_oMessageHandle, 
                       tU8 f_u8MsgType,
                       tU8 f_u8MsgNotificationType);
};
#endif /* FC_MESSAGING_FILESYSTEMMANAGER_H_ */
