/*
 * FC_Messaging_FileSystemManager.cpp
 *
 *  Created on: Dec 15, 2011
 *      Author: rakesh
 */

#include "../FC_Messaging_Debug.h"
#include "FC_Messaging_FileSystemManager.h"
#include "../FC_Messaging_main.h"
#include "../FC_Messaging_service_Messaging.h"
#include "../DbusClient/FC_Messaging_DbusClientInterface.h"
#include "../ReadMessageAloud/Gen3/FC_Messaging_ReadMessageAloud.h"
#include "../SendMessage/FC_Messaging_SendMessage.h"
#include "../MsgList/FC_Messaging_Settings.h"
#include "../FC_Messaging_WorkQueue.h"
#include "../FC_Messaging_clienthandler_Phonebook.h"
// Bugfix for GMMY15-5992 Large empty gap is present in text messages list
#include "../FC_Messaging_phonebook.h"
#include "../FC_Messaging_StateMachine.h"

//Default Date and Time values
#define YYYY "0000"
#define DD "00"
#define TT "99"
#define MAX_DATETIME_SIZE 17

#define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
#include "utf_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_FILESYSTEM
#include "trcGenProj/Header/FC_Messaging_FileSystemManager.cpp.trc.h"
#endif

tU32 FileSystemManager::m_u32MostUpperHandle;
tU32 FileSystemManager::m_u32ConversationID;
QMap<tU32, MessageTypeDbusMessageHandleInfo> FileSystemManager::m_DbusMessageHandleAndMostUpperHandleMap;

most_msgfi_tclMsgDeleteMessageMethodStart FileSystemManager::m_oDeleteMessageMethodStart;
most_fi_tcl_MsgMessageHandle FileSystemManager::m_oCurrentDeleteMessageHandle;
QList<most_fi_tcl_MsgMessageHandle> FileSystemManager::m_lMessageHandlesListForDelete;
QList<NewIncomingMessageInfo> FileSystemManager::m_lNewIncoimgMessageInfoList;
//CMG3G-1494
most_fi_tcl_e8_MsgMessageListType::tenType FileSystemManager::enCurrentMessageListType = most_fi_tcl_e8_MsgMessageListType::FI_EN_E8MSG_LIST_SMS_MMS;

FileSystemManager::FileSystemManager()
{
   ETG_TRACE_USR4(("FileSystemManager()"));
   m_u8ServiceNameId = 0;
   m_eGetMessageCaller = e8ReadMessageAloud;
   m_u8NumSubfolders = 0;
   m_u8NumTotalMessage = 0;
   m_u8InboxFolderPosition = 0;
   m_MessageListfilterType = most_fi_tcl_e8_MsgMessageListFilterType::FI_EN_E8MSG_LIST_FILTER_CURRENT_MAP_SESSION;
   m_enCreateMessageListRequest = e8CreateMessageListRequestInvalid;
   m_bGetMsgFailure = false; //Fix for CMG3G-5833
   m_lUnreadMessageHandlesList.clear();
   m_lReadingMessageHandlesList.clear();
   m_mapPhoneNoAndConversationID.clear();
}

FileSystemManager::~FileSystemManager()
{
   ETG_TRACE_USR4(("~FileSystemManager()"));
   _BP_TRY_BEGIN
   {
      /* Bugfix for GMMY15-9182 Incomplete message details view is shown */
      m_mapPhoneNoAndConversationID.clear();
      vResetNewMsgHandleListAndFolderHandle();
   }
   _BP_CATCH_ALL
   {
      ETG_TRACE_ERR(("BadAlloc Exception Caught"));
   }
   _BP_CATCH_END

}

tVoid FileSystemManager::vSetServiceNameId(tU8 f_u8ServiceNameId)
{
   m_u8ServiceNameId = f_u8ServiceNameId;
}

tVoid FileSystemManager::vRequestFolderList(tU32 f_u32FolderHandle, tBool f_bRootFlag)
{
   ETG_TRACE_USR4(("vRequestFolderList FolderHandle = %d", f_u32FolderHandle));

   QString l_sFolderName;
   FolderNode* l_poFolderNode = NULLPTR;

   if (f_bRootFlag == true)
   {
      ETG_TRACE_USR4(("Root flag is set"));
      l_sFolderName = (const char*) NULL;
   }
   else
   {
      ETG_TRACE_USR4(("Root flag is not set"));

      l_poFolderNode = poSearchNodeByFolderHandle(f_u32FolderHandle);
      if (l_poFolderNode)
      {
         l_sFolderName = l_poFolderNode->m_sFolderName;
      }
      else
      {
         ETG_TRACE_USR4(("Invalid folder Handle"));
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_RequestFolderList_Error();
         return;
      }
   }

   if (l_sFolderName.isEmpty())
   {
      m_sRequestFolderListInProgressFolderName = "Root";
   }
   else
   {
      m_sRequestFolderListInProgressFolderName = l_sFolderName;
   }

   m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.clear();

   DbusClientInterface::getInstance().messagingMapListFolder(l_sFolderName);
}

tVoid FileSystemManager::vRequestFolderListResultFromDevice(QString f_sFolderName, tU8 u8DeviceHandle)
{
   ETG_TRACE_USR4(("vRequestFolderListResultFromDevice Called"));

   FileSystem::vAddFolderNode(m_sRequestFolderListInProgressFolderName, f_sFolderName, u8DeviceHandle);
}

tVoid FileSystemManager::vRequestFolderListReturnToClient(tU8 f_u8NumSubfolders)
{
   ETG_TRACE_USR4(("vRequestFolderListReturnToClient Called"));

   m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.clear();

   if (f_u8NumSubfolders == 0)
   {
      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_RequestFolderList_Return(
            m_oRequestFolderListMethodResult_MR);
      return;
   }

   m_u8NumSubfolders = static_cast<tU8>(f_u8NumSubfolders - 1);
   m_u8NumTotalMessage = static_cast<tU8>(f_u8NumSubfolders - 1);

   most_fi_tcl_MsgFolderListResultItem* l_poFolderListResultItem;

   l_poFolderListResultItem = new most_fi_tcl_MsgFolderListResultItem[f_u8NumSubfolders];
   if (!l_poFolderListResultItem)
   {
      return;
   }

   tU8 l_u8Counter = 0;

   DirectoryStructure::iterator l_it;

   for (l_it = m_oDirectoryStructure.begin();
         l_it != m_oDirectoryStructure.end(); l_it++)
   {
      if (l_it.key() == m_sRequestFolderListInProgressFolderName)
      {
         ETG_TRACE_USR4(("more entries are left"));

         l_poFolderListResultItem[l_u8Counter].u32FolderHandle = l_it.value().m_u32FolderHandle;
         l_poFolderListResultItem[l_u8Counter].sFolderName.bSet(l_it.value().m_sFolderName.toUtf8().constData());
         l_poFolderListResultItem[l_u8Counter].u8NumSubfolders = static_cast<tU8>(l_it.value().m_u32NumSubFolders);
         l_poFolderListResultItem[l_u8Counter].u16NumMessages = static_cast<tU16>(l_it.value().m_u32TotalMessage);
         l_poFolderListResultItem[l_u8Counter].u16NumUnreadMessages = static_cast<tU16>(l_it.value().m_u32NumberOfUnreadMessage);

         if (l_it.value().m_sFolderName.contains(MSG_DBUS_FOLDER_TYPE_INBOX, Qt::CaseInsensitive))
         {
            l_poFolderListResultItem[l_u8Counter].e8FolderType.enType =
                  most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX;
            m_u8InboxFolderPosition = l_u8Counter;
         }
         else if (l_it.value().m_sFolderName.contains(MSG_DBUS_FOLDER_TYPE_DELETED, Qt::CaseInsensitive))
         {
            l_poFolderListResultItem[l_u8Counter].e8FolderType.enType =
                  most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_DELETED;
         }
         else if (l_it.value().m_sFolderName.contains(MSG_DBUS_FOLDER_TYPE_DRAFT, Qt::CaseInsensitive))
         {
            l_poFolderListResultItem[l_u8Counter].e8FolderType.enType =
                  most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_DRAFTS;
         }
         else if (l_it.value().m_sFolderName.contains(MSG_DBUS_FOLDER_TYPE_SENT, Qt::CaseInsensitive))
         {
            l_poFolderListResultItem[l_u8Counter].e8FolderType.enType =
                  most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT;
         }
         else if (l_it.value().m_sFolderName.contains(MSG_DBUS_FOLDER_TYPE_OUTBOX, Qt::CaseInsensitive))
         {
            l_poFolderListResultItem[l_u8Counter].e8FolderType.enType =
                  most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_OUTBOX;
         }
         else
         {
            l_poFolderListResultItem[l_u8Counter].e8FolderType.enType =
                  most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_USERDEFINED;
         }
         //For Coverity Warning 49293
         _BP_TRY_BEGIN
         {
            m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.push_back(l_poFolderListResultItem[l_u8Counter]);
            l_u8Counter++;
         }
         _BP_CATCH_ALL
         {
            delete[] l_poFolderListResultItem;
            return;
         }
         _BP_CATCH_END
      }
   }
   //For Coverity Warning 49293
   _BP_TRY_BEGIN
   {
      if(0 < m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.size())
      {
         DbusClientInterface::getInstance().messagingMapGetSubFolderCount(
                  m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumSubfolders].sFolderName.szValue);
      }
      else
      {
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_RequestFolderList_Return(
                  m_oRequestFolderListMethodResult_MR);
      }
   }
   _BP_CATCH_ALL
   {
      delete[] l_poFolderListResultItem;
      return;
   }
   _BP_CATCH_END

   delete[] l_poFolderListResultItem;
}

tVoid FileSystemManager::vRequestFolderListGetSubFolderReturn(tU8 f_u8NumSubfolders)
{
   ETG_TRACE_USR4(("vRequestFolderListGetSubFolderReturn Called"));

   if(0 < m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.size())
   {
      FolderNode* l_poFolderNode = poSearchNodeByFolderName(
            m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumSubfolders].sFolderName.szValue);

      if(l_poFolderNode)
      {
         l_poFolderNode->m_u32NumSubFolders = f_u8NumSubfolders;
      }

      m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumSubfolders].u8NumSubfolders
      = f_u8NumSubfolders;

      if (m_u8NumSubfolders)
      {
         m_u8NumSubfolders--;

         DbusClientInterface::getInstance().messagingMapGetSubFolderCount(
               m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumSubfolders].sFolderName.szValue);
      }
      else
      {
         DbusClientInterface::getInstance().messagingMapGetMessageCount(
               m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumTotalMessage].sFolderName.szValue,
               0, 0);
      }
   }
}

tVoid FileSystemManager::vRequestFolderListGetMessageCountReturn(tU8 f_u8NumMessages)
{
   ETG_TRACE_USR4(("vRequestFolderListGetMessageCountReturn Called"));

   if(0 < m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.size())
   {
      FolderNode* l_poFolderNode = poSearchNodeByFolderName(
            m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumTotalMessage].sFolderName.szValue);

      if(l_poFolderNode)
      {
         l_poFolderNode->m_u32TotalMessage = f_u8NumMessages;
      }

      m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumTotalMessage].u16NumMessages = f_u8NumMessages;

      if (m_u8NumTotalMessage)
      {
         m_u8NumTotalMessage--;

         DbusClientInterface::getInstance().messagingMapGetMessageCount(
               m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8NumTotalMessage].sFolderName.szValue, 0, 0);
      }
      else
      {
         DbusClientInterface::getInstance().messagingMapGetMessageCount(MSG_DBUS_FOLDER_TYPE_INBOX, 0, 1);
      }
   }
}

tVoid FileSystemManager::vRequestFolderListGetUnReadMessageCountReturn(tU8 f_u8NumMessages)
{
   ETG_TRACE_USR4(("vRequestFolderListGetUnReadMessageCountReturn Called"));

   if(0 < m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems.size())
   {
      FolderNode* l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);

      if(l_poFolderNode)
      {
         l_poFolderNode->m_u32NumberOfUnreadMessage = f_u8NumMessages;
      }

      m_oRequestFolderListMethodResult_MR.oFolderListResult.oItems[m_u8InboxFolderPosition].u16NumUnreadMessages = f_u8NumMessages;
   }

   fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_RequestFolderList_Return(
         m_oRequestFolderListMethodResult_MR);
}

tVoid FileSystemManager::vCreateMessageList(
      most_msgfi_tclMsgCreateMessageListMethodStart& f_roCreateMessageListMethodStart)
{
   ETG_TRACE_USR4(("vCreateMessageList Called"));

   // Bugfix for GMMY16-5367 : Selected view on new message alert and nothing happened
   //            GMMY16-5368 : Message inbox was missing many of the newest messages
   // Ignore the identical requests in the same ignition cycle
   // Fix commented for NCG3D-6256 - SMS Listing does not work when requested from two clients.
#if 0
   if (m_oLastCreateMessageListMethodStart == f_roCreateMessageListMethodStart)
   {
      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_CreateMessageList_Error();
      return;
   }
#endif
   m_oLastCreateMessageListMethodStart = f_roCreateMessageListMethodStart;

   switch (f_roCreateMessageListMethodStart.e8FolderType.enType)
   {
      case most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX:
         m_sCreateMessageListInProgressFolderName = MSG_DBUS_FOLDER_TYPE_INBOX;
         break;

      case most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_OUTBOX:
      case most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT:
         m_sCreateMessageListInProgressFolderName = MSG_DBUS_FOLDER_TYPE_SENT;
         break;

      case most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_DELETED:
         m_sCreateMessageListInProgressFolderName = MSG_DBUS_FOLDER_TYPE_DELETED;
         break;

      case most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_DRAFTS:
         m_sCreateMessageListInProgressFolderName = MSG_DBUS_FOLDER_TYPE_DRAFT; //"draft";
         break;

      default:
         m_sCreateMessageListInProgressFolderName = MSG_DBUS_FOLDER_TYPE_INBOX;
         break;
   }

   //CMG3G-1494
   enCurrentMessageListType = f_roCreateMessageListMethodStart.e8MessageListType.enType;

   ETG_TRACE_USR4(("vCreateMessageList::Current message list type is %u",enCurrentMessageListType));

   FolderNode* l_poFolderNode;
   l_poFolderNode = poSearchNodeByFolderName(m_sCreateMessageListInProgressFolderName);
   if (l_poFolderNode)
   {
      //Bugfix for CMG3GB-2831 The multiple requests for creating MessageList from different clients to be handled correctly in Messaging F-Block
      //If Message List is not downloaded before then send the request to stack, else sent the downloaded message list to requested client.
      if((0 == l_poFolderNode->m_pvMessageList->size()) && (most_fi_tcl_e8_MsgMessageListFilterType::FI_EN_E8MSG_LIST_FILTER_CURRENT_MAP_SESSION !=
            f_roCreateMessageListMethodStart.e8MessageListFilterType.enType))
      {
         m_MessageListfilterType = f_roCreateMessageListMethodStart.e8MessageListFilterType.enType;
         l_poFolderNode->m_pvMessageList->clear();
         DbusClientInterface::getInstance().messagingMapListMsg(f_roCreateMessageListMethodStart);
      }
      else
      {
         ETG_TRACE_USR4(("vCreateMessageList Current MAP Session"));
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_CreateMessageList_Return(
               static_cast<tU16>(l_poFolderNode->m_u32ListHandle), static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()));
      }
   }
   else
   {
      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_CreateMessageList_Error();
   }
}

tU32 FileSystemManager::u32ConvertDbusHandleToMostHandle(QString f_sDbusMessageHandle)
{
   ETG_TRACE_USR4(("u32ConvertDbusHandleToMostHandle Called"));

   m_u32MostUpperHandle++;
   MessageTypeDbusMessageHandleInfo l_oMessageTypeDbusMessageHandleInfo;
   l_oMessageTypeDbusMessageHandleInfo.m_oMessageListType.enType = enCurrentMessageListType;
   l_oMessageTypeDbusMessageHandleInfo.m_sDbusMessageHandle = f_sDbusMessageHandle;
   m_DbusMessageHandleAndMostUpperHandleMap.insert(m_u32MostUpperHandle, l_oMessageTypeDbusMessageHandleInfo);

   return m_u32MostUpperHandle;
}

/*******************************************************************************
 * FUNCTION:  	vFillDateTime
 * DESCRIPTION:  function is used to parse date and time.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid FileSystemManager::vFillDateTime(MsgListing_t* poMsgListData,
      most_fi_tcl_MsgMessageListSliceResultItem* poMessageListSliceResultItem)
{
   ETG_TRACE_USR4(("vFillDateTime Called"));

   tChar achDateTime[MAX_DATETIME_SIZE]; //Maximum 4 bytes character can occupy 16 bytes
   tU8 u8Len;
   tString sDateTime;

   //u8Len -> represents no of bytes used in the given DateTime string
   u8Len = static_cast<tU8>(poMsgListData->sGetDateTime().size());
   sDateTime = new tChar[u8Len + 1];

   if (sDateTime)
   {
      memset(sDateTime, 0, u8Len + 1);
      strncpy(sDateTime, poMsgListData->sGetDateTime().constData(), u8Len);

      if (strstr((const char*) sDateTime, "T"))
      {
         //As per MAP specification, Timestamp format will be
         //YYYYMMDDTHHMMSS if UTC Offset timestamp format is not supported (or)
         //YYYYMMDDTHHMMSSHHMM if UTC Offset timestamp format is supported

         tU8 u8NumOfTimeFormatChars = 0;

         if(strstr((const char*) sDateTime, "+") || strstr((const char*) sDateTime, "-"))
         {
            u8NumOfTimeFormatChars = 2; // "T" and "+" or "-" present in the time stamp
            ETG_TRACE_USR4(("vFillDateTime Format YYYYMMDDTHHMMSSHHMM"));
         }
         else
         {
            u8NumOfTimeFormatChars = 1; //Only "T" is present in the time stamp
            ETG_TRACE_USR4(("vFillDateTime Format YYYYMMDDTHHMMSS"));
         }

         //u8NumChars -> represents no of characters in the given DateTime string
         tU8 u8NumChars = static_cast<tU8>(UTF8_u32StringCharCount(poMsgListData->sGetDateTime().constData()));

         //u8NumBytes -> represents no of bytes per numeric character (digits) in the given DateTime string
         tU8 u8NumBytes = static_cast<tU8>((u8Len-u8NumOfTimeFormatChars)/(u8NumChars-u8NumOfTimeFormatChars));

         strncpy(achDateTime, sDateTime, u8NumBytes*4);
         achDateTime[u8NumBytes*4] = 0;
         poMessageListSliceResultItem->oMessageDateTime.oMessageDate.sCldrYear.bSet(achDateTime);

         strncpy(achDateTime, sDateTime + u8NumBytes*4, u8NumBytes*2);
         achDateTime[u8NumBytes*2] = 0;
         poMessageListSliceResultItem->oMessageDateTime.oMessageDate.sCldrMonth.bSet(achDateTime);

         strncpy(achDateTime, sDateTime + u8NumBytes*6, u8NumBytes*2);
         achDateTime[u8NumBytes*2] = 0;
         poMessageListSliceResultItem->oMessageDateTime.oMessageDate.sCldrDay.bSet(achDateTime);

         strncpy(achDateTime, sDateTime + u8NumBytes*8 + 1, u8NumBytes*2);
         achDateTime[u8NumBytes*2] = 0;
         poMessageListSliceResultItem->oMessageDateTime.oMessageTime.sHours.bSet(achDateTime);

         strncpy(achDateTime, sDateTime + u8NumBytes*10 + 1, u8NumBytes*2);
         achDateTime[u8NumBytes*2] = 0;
         poMessageListSliceResultItem->oMessageDateTime.oMessageTime.sMinutes.bSet(achDateTime);

         strncpy(achDateTime, sDateTime + u8NumBytes*12 + 1, u8NumBytes*2);
         achDateTime[u8NumBytes*2] = 0;
         poMessageListSliceResultItem->oMessageDateTime.oMessageTime.sSeconds.bSet(achDateTime);
      }
      else
      {
         // Bugfix for GMMY16-17014: 2016 - Phone: Dates goes missing after scrolling up down in Texts Messages
         ETG_TRACE_USR4(("vFillDateTime Invalid Timestamp Format"));

         //Set the default values for Date and Time : 00000000T999999 (YYYYMMDDTHHMMSS)
         strcpy(achDateTime, YYYY);
         poMessageListSliceResultItem->oMessageDateTime.oMessageDate.sCldrYear.bSet(achDateTime);

         strcpy(achDateTime, DD);
         poMessageListSliceResultItem->oMessageDateTime.oMessageDate.sCldrMonth.bSet(achDateTime);
         poMessageListSliceResultItem->oMessageDateTime.oMessageDate.sCldrDay.bSet(achDateTime);

         strcpy(achDateTime, TT);
         poMessageListSliceResultItem->oMessageDateTime.oMessageTime.sHours.bSet(achDateTime);
         poMessageListSliceResultItem->oMessageDateTime.oMessageTime.sMinutes.bSet(achDateTime);
         poMessageListSliceResultItem->oMessageDateTime.oMessageTime.sSeconds.bSet(achDateTime);
      }
   }

   delete[] sDateTime;
}

tU32 FileSystemManager::u32AddMessageInList(tU8 f_u8DeviceHandle, MsgListing_t* f_poMsgList)
{
   ETG_TRACE_USR4(("u32AddMessageInList DeviceHandle = %d", f_u8DeviceHandle));

   most_fi_tcl_MsgMessageListSliceResultItem l_oMessageListSliceResultItem;
   tU32 l_u32MostUpperHandle;
   most_fi_tcl_e8_MsgFolderType::tenType folderType = most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX;
   most_fi_tcl_e8_MsgMessageStatus::tenType messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8RECEIVED_COMPLETE;
   most_fi_tcl_e8_MsgAddressFieldType::tenType addressFieldType = most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_FROM;

   l_oMessageListSliceResultItem.bReadStatusFlag = f_poMsgList->u8GetReadStatus();
   l_oMessageListSliceResultItem.e8PlaybackState.enType =
         most_fi_tcl_e8_MsgPlaybackState::FI_EN_E8PBS_STOPPED;

   l_oMessageListSliceResultItem.e8SendMessageResultType.enType =
         most_fi_tcl_e8_MsgSendMessageResultType::FI_EN_E8DELIVERY_SUCCESS;

   l_u32MostUpperHandle = u32ConvertDbusHandleToMostHandle(f_poMsgList->sGetMessageHandle());

   l_oMessageListSliceResultItem.oMessageHandle.u8DeviceHandle = f_u8DeviceHandle;
   l_oMessageListSliceResultItem.oMessageHandle.u32MsgHandleUpper = l_u32MostUpperHandle;

   vFillDateTime(f_poMsgList, &l_oMessageListSliceResultItem);

   l_oMessageListSliceResultItem.sSubject.bSet(f_poMsgList->sGetSubject().constData());
   l_oMessageListSliceResultItem.sShortMessage.bSet(f_poMsgList->sGetSubject().constData());

   if (f_poMsgList->u32GetAttachSize() > 0)
   {
      //TODO: Attachment feature blocked by Bosch. So making it false
      l_oMessageListSliceResultItem.bAttachmentFlag = false;
   }
   else
   {
      l_oMessageListSliceResultItem.bAttachmentFlag = false;
   }

   if (f_poMsgList->u8GetMessageType() == MSG_DBUS_MESSAGE_TYPE_EMAIL)
   {
      ETG_TRACE_USR4(("Email message"));

      if (m_sCreateMessageListInProgressFolderName == MSG_DBUS_FOLDER_TYPE_INBOX)
      {
         if (f_poMsgList->sGetSenderName().size() > 0)
         {
            ETG_TRACE_USR4(("Taking Sender name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetSenderName().constData());
         }
         else
         {
            ETG_TRACE_USR4(("Taking Sender address as first name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetSenderAddress().constData());
         }

         l_oMessageListSliceResultItem.sEmailAddress.bSet(f_poMsgList->sGetSenderAddress().constData());

         folderType = most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX;
      }
      else if (m_sCreateMessageListInProgressFolderName == MSG_DBUS_FOLDER_TYPE_SENT)
      {
         if (f_poMsgList->sGetRecipientName().size() > 0)
         {
            ETG_TRACE_USR4(("Taking Recipient name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetRecipientName().constData());
         }
         else
         {
            ETG_TRACE_USR4(("Taking Recipient address as first name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetRecipientAddress().constData());
         }
         l_oMessageListSliceResultItem.sEmailAddress.bSet(f_poMsgList->sGetRecipientAddress().constData());

         folderType = most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT;
      }
      l_oMessageListSliceResultItem.e8MessageType.enType =
            most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_EMAIL;
   }
   else
   {
      if (m_sCreateMessageListInProgressFolderName == MSG_DBUS_FOLDER_TYPE_INBOX)
      {
         if (f_poMsgList->sGetSenderAddress().size() > 0)
         {
            l_oMessageListSliceResultItem.sPhoneNumber.bSet(f_poMsgList->sGetSenderAddress().constData());
         }
         else
         {
            l_oMessageListSliceResultItem.sPhoneNumber.bSet(""); //Clear Phone number is not valid
         }

         if (f_poMsgList->sGetSenderName().size() > 0)
         {
            ETG_TRACE_USR4(("Taking Sender name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetSenderName().constData());
         }
         else if (f_poMsgList->sGetSenderAddress().size() > 0)
         {
            ETG_TRACE_USR4(("Taking Sender address as first name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetSenderAddress().constData());
         }
         else
         {
            // Bugfix for GMMY16-5286: [CT} Sender Name in Text Inbox view is not presented in the format
            // that the contact list was last view. Sender name is always shown as First Name - Last Name
            ETG_TRACE_USR4(("Both sender name and sender address are empty"));
            l_oMessageListSliceResultItem.sFirstName.bSet("");
         }

         folderType = most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX;
      }
      else if (m_sCreateMessageListInProgressFolderName == MSG_DBUS_FOLDER_TYPE_SENT)
      {
         if (f_poMsgList->sGetRecipientName().size() > 0)
         {
            ETG_TRACE_USR4(("Taking Recipient name as first name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetRecipientName().constData());
         }
         else if (f_poMsgList->sGetRecipientAddress().size() > 0)
         {
            ETG_TRACE_USR4(("Taking Recipient address as first name"));
            l_oMessageListSliceResultItem.sFirstName.bSet(f_poMsgList->sGetRecipientAddress().constData());
         }
         else 
         {
            //This should never happen
            ETG_TRACE_USR4(("Both Recipient Name and Recipient address are empty"));
            l_oMessageListSliceResultItem.sFirstName.bSet("");
         }

         if (f_poMsgList->sGetRecipientAddress().size() > 0)
         {
            l_oMessageListSliceResultItem.sPhoneNumber.bSet(f_poMsgList->sGetRecipientAddress().constData());
         }
         else
         {
            l_oMessageListSliceResultItem.sPhoneNumber.bSet(f_poMsgList->sGetRecipientName().constData());
         }

         folderType = most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT;
      }

      if (f_poMsgList->u8GetMessageType() == MSG_DBUS_MESSAGE_TYPE_MMS)
      {
         ETG_TRACE_USR4(("MMS message"));
         l_oMessageListSliceResultItem.e8MessageType.enType =
               most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_MMS;
      }
      else
      {
         ETG_TRACE_USR4(("SMS message"));
         l_oMessageListSliceResultItem.e8MessageType.enType =
               most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_SMS;
      }
   }

   l_oMessageListSliceResultItem.sLastName.bSet("");
   l_oMessageListSliceResultItem.u32ContactHandle = 0;

   //Set MessageStatus and AddressFieldType based on inbox or sent folder
   vFillMsgStatusAndAddressFieldType(folderType, f_poMsgList, messageStatus, addressFieldType);

   FileSystem::vAddMessageInList(m_sCreateMessageListInProgressFolderName, l_oMessageListSliceResultItem);

#ifdef CONVERSATION_MESSAGES_SUPPORT
   vAddMessageinConversationList(l_oMessageListSliceResultItem, f_poMsgList->u32GetAttachSize(), messageStatus, addressFieldType);
#endif

   return l_u32MostUpperHandle;
}

tVoid FileSystemManager::vFillMsgStatusAndAddressFieldType(most_fi_tcl_e8_MsgFolderType::tenType folderType, MsgListing_t* f_poMsgList,
      most_fi_tcl_e8_MsgMessageStatus::tenType &messageStatus, most_fi_tcl_e8_MsgAddressFieldType::tenType &addressFieldType)
{
   tU8 u8ReceptionStatus = f_poMsgList->u8GetReceptionStatus();
   tU8 u8NotifyType = f_poMsgList->u8GetNotifyType();
   tU8 u8SentStatus = f_poMsgList->u8GetSentStatus();

   if(most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX == folderType) //inbox item
   {
      if(MSG_STATUS_RECEIVED_COMPLETE == u8ReceptionStatus)
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8RECEIVED_COMPLETE;
      }
      else if(MSG_STATUS_RECEIVED_FRACTIONED == u8ReceptionStatus)
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8RECEIVED_FRACTIONED;
      }
      else
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8RECEIVED_NOTIFICATION;
      }
      addressFieldType = most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_FROM;
   }
   else //sent item
   {
      if(0x01 == u8NotifyType)
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8SENDING_SUCCESS;
      }
      else if(0x02 == u8NotifyType)
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8DELIVERY_SUCCESS;
      }
      else if(0x03 == u8NotifyType)
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8SENDING_FAILURE;
      }
      else if(0x04 == u8NotifyType)
      {
         messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8DELIVERY_FAILURE;
      }
      else
      {
         if(MSG_STATUS_DELIVERY_SUCCESS == u8SentStatus)
         {
            messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8DELIVERY_SUCCESS;
         }
         else
         {
            messageStatus = most_fi_tcl_e8_MsgMessageStatus::FI_EN_E8DELIVERY_FAILURE;
         }
      }

      addressFieldType = most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_TO;
   }
}

tVoid FileSystemManager::vCreateMessageListComplete()
{
   ETG_TRACE_USR4(("vCreateMessageListComplete Called "));

   if (m_enCreateMessageListRequest != e8CreateMessageListRequestInvalid)
   {
      if(m_enCreateMessageListRequest == e8CreateMessageListRequestForConversationFolder)
      {
         //Sequence will be continued in GetMessagesForConversation
         /*FolderNode* l_poConvFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);;

         if(l_poConvFolderNode && l_poConvFolderNode->m_pvConversationList)
         {
            fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_CreateMessageList_Return(
                  static_cast<tU16>(l_poConvFolderNode->m_u32ListHandle), static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()));

            //Send MessageListChange for ConversationList
            vMessageListChangeNotify((tU16)l_poConvFolderNode->m_u32ListHandle,
                  static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
                  most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_CONTENT_CHANGED, 0);
         }*/
      }
      else //e8CreateMessageListRequestForConversationMessage
      {
         bGetConversationMessageHandles(m_oGetConversationMessagesMethodStart);
         m_enCreateMessageListRequest = e8CreateMessageListRequestInvalid;
      }
   }
   else
   {
      FolderNode* l_poFolderNode;
      l_poFolderNode = poSearchNodeByFolderName(m_sCreateMessageListInProgressFolderName);

      if (l_poFolderNode)
      {
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_CreateMessageList_Return(
               static_cast<tU16>(l_poFolderNode->m_u32ListHandle), static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()));
      }
   }
}

tVoid FileSystemManager::vGetMessage(most_fi_tcl_MsgMessageHandle& f_roMessageHandle,
      e8GetMessageCaller f_eGetMessageCaller)
{
   ETG_TRACE_USR4(("vGetMessage Called"));

   m_eGetMessageCaller = f_eGetMessageCaller;

   // Bugfix for GMMY15-11135
   if ((f_roMessageHandle == m_oLastGetMessageHandle) && (false == m_bGetMsgFailure))
   {
      vGetMessageResult(DbusClientInterface::getInstance().getMsgReadObject(f_roMessageHandle.u8DeviceHandle));

      //DbusClientIf client = DbusClientInterface::getInstance().getClientInterface();
      //if((DBUS_CLIENT_IF_EVOLUTION == client) && (e8GetMessageStart == m_eGetMessageCaller))
      //{
      //   MessagingMutex::messagingMutexUnlock();
      //}

      return; // Message is already read from the device.
   }

   FolderNode* l_poFolderNode;
   l_poFolderNode = poSearchNodeByListHandle(f_roMessageHandle.u32MsgHandleLower);

   if (!l_poFolderNode)
   {
      ETG_TRACE_USR1(("Invalid List Handle"));


      //check who is the GetMessage request sender and post error accordingly
      vSetGetMessageFailure(true);
      if (e8ReadMessageAloud == m_eGetMessageCaller)
      {
         ETG_TRACE_USR3(("Invalid List Handle for ReadMessageAloud"));
         ReadMessageAloud* oReadMessageAloud = ReadMessageAloud::poGetInstance();
         oReadMessageAloud->vProcessEvent(FC_MESSAGING_SM_EVENT_GETMESSAGE_FAILURE);
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_ReadMessageAloud_Error();
      }
      else if (e8ConversationDetail == m_eGetMessageCaller)
      {
         vGetMessagesForConversation();
      }
      else if (e8GetMessageStart == m_eGetMessageCaller)
      {
         ETG_TRACE_USR3(("Invalid List handle for GetMessageStart"));
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_GetMessage_Error();
      }
      else if (e8SubjectUpdate == m_eGetMessageCaller)
      {
         ETG_TRACE_USR3(("Invalid List handle for Subject Update"));
      }
      else
      {
         ETG_TRACE_USR3(("Invalid List handle for Incoming Message and Send Message"));

      }


      return;
   }

   m_bGetMsgFailure = false;
   m_oLastGetMessageHandle = f_roMessageHandle;

   int l_u32Index;
   int l_u32MessageListLength;

   m_oMessageDetailsResult.oAddressField.oItems.clear();
   l_u32MessageListLength = l_poFolderNode->m_pvMessageList->size();

   for (l_u32Index = 0; l_u32Index < l_u32MessageListLength; l_u32Index++)
   {
      if (l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u32MsgHandleUpper ==
            f_roMessageHandle.u32MsgHandleUpper)
      {
         ETG_TRACE_USR1(("Match found"));

         l_poFolderNode->m_u32NumberOfUnreadMessage--; // Send FolderListChange
         fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_FolderListChange_Request(
               l_poFolderNode->m_u32FolderHandle);

         most_fi_tcl_MsgAddressFieldItem l_oAddressFieldItem;

         if (l_poFolderNode->m_sFolderName == MSG_DBUS_FOLDER_TYPE_INBOX)
         {
            l_oAddressFieldItem.e8AddressFieldType.enType =
                  most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_FROM;
         }
         else
         {
            l_oAddressFieldItem.e8AddressFieldType.enType =
                  most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_TO;
         }

         /* Bugfix for GMMY16-8625: Not able to call an unknown contact from Text Message detail view */
         l_oAddressFieldItem.sFirstName.bSet(sGetName(l_poFolderNode->m_pvMessageList->at(l_u32Index).sFirstName));
         l_oAddressFieldItem.sLastName.bSet(sGetName(l_poFolderNode->m_pvMessageList->at(l_u32Index).sLastName));

         l_oAddressFieldItem.sEmailAddress = l_poFolderNode->m_pvMessageList->at(l_u32Index).sEmailAddress;
         l_oAddressFieldItem.sPhoneNumber = l_poFolderNode->m_pvMessageList->at(l_u32Index).sPhoneNumber;

         m_oMessageDetailsResult.oAddressField.oItems.push_back(l_oAddressFieldItem);

         m_oMessageDetailsResult.oMessageDateTime =
               l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageDateTime;
         m_oMessageDetailsResult.sSubject =
               l_poFolderNode->m_pvMessageList->at(l_u32Index).sSubject;
         //Bosch blocked attachments, so hard coded to zero
         m_oMessageDetailsResult.u8NumAttachments = 0;

         break;
      }
   }

   QMap<tU32, MessageTypeDbusMessageHandleInfo>::iterator l_it;
   l_it = m_DbusMessageHandleAndMostUpperHandleMap.find(f_roMessageHandle.u32MsgHandleUpper);

   ETG_TRACE_USR1(("Taking message from device"));

   DbusClientInterface::getInstance().messagingMapReadMsg(f_roMessageHandle.u8DeviceHandle, *l_it);
}

tVoid FileSystemManager::vGetMessageResult(MsgRead_t* poMsgRead)
{
   ETG_TRACE_USR4(("FileSystemManager::vGetMessageResult Entered"));

   if (e8ReadMessageAloud == m_eGetMessageCaller)
   {
      FolderNode* poFolderNode;
      poFolderNode = poSearchNodeByListHandle(m_oLastGetMessageHandle.u32MsgHandleLower);

      if (!poFolderNode)
      {
         ETG_TRACE_USR1(("Null returned"));
         return;
      }
      ReadMessageAloud* poReadMessageAloud = ReadMessageAloud::poGetInstance();
      poReadMessageAloud->vGetMessageForReadAloudReturn(poMsgRead, poFolderNode);

      int u32Index;
      int u32MessageListLength;

      u32MessageListLength = poFolderNode->m_pvMessageList->size();

      for (u32Index = 0; u32Index < u32MessageListLength; u32Index++)
      {
         if (poFolderNode->m_pvMessageList->at(u32Index).oMessageHandle.u32MsgHandleUpper
               == m_oLastGetMessageHandle.u32MsgHandleUpper)
         {
            ETG_TRACE_USR1(("Match found at index: %d", u32Index));
            //CMG3G-9601 update ReadStatusFlag on listening new incoming message
            tU8 msgReadStatus = 0;
            if (msgReadStatus
                  == poFolderNode->m_pvMessageList->at(u32Index).bReadStatusFlag)
            {
               msgReadStatus = 1;
               (*poFolderNode->m_pvMessageList)[u32Index].bReadStatusFlag = msgReadStatus;
               vMessageListChangeNotify((tU16) poFolderNode->m_u32ListHandle,
                     static_cast<unsigned int>(poFolderNode->m_pvMessageList->size()),
                     most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,
                     static_cast<unsigned int>(u32Index));
            }
            break;
         }
      }

   }
   else if (e8ConversationDetail == m_eGetMessageCaller)
   {
      //Update MessageContent in ConversationDetailList
      QString sMessageContent = QString::fromUtf8(poMsgRead->sGetDataPayLoad().constData());

      ETG_TRACE_USR4(("MessageContent : %s", sMessageContent.toUtf8().constData()));

      vUpdateMessageContentInConversationDetailList(m_oLastGetMessageHandle, sMessageContent);

      vGetMessagesForConversation();
   }
   else if (e8SubjectUpdate == m_eGetMessageCaller)
   {
      //Update MessageContent for ShortMessage
      QString sMessageContent = QString::fromUtf8(poMsgRead->sGetDataPayLoad().constData());

      ETG_TRACE_USR4(("MessageContent : %s", sMessageContent.toUtf8().constData()));
      sMessageContent.truncate(FC_MESSAGING_SHORTMESSAGE_MAX_LEN_CHAR_COUNT);
      vUpdateShortMessageInMessageList(m_oLastGetMessageHandle,sMessageContent);
   }
   else //Caller is GetMessage
   {
      // -RB-FIX for GMNGA-51104 - Long SMS result in blank Message screen - added the following 2 lines
      QString sMessage = QString::fromUtf8(poMsgRead->sGetDataPayLoad().constData());
      sMessage.truncate(FC_MESSAGING_SHORTMESSAGE_MAX_LEN_CHAR_COUNT);

      m_oMessageDetailsResult.sShortMessage.bSet(sMessage.toUtf8());
      m_oMessageDetailsResult.u8NumBodyParts = static_cast<tU8>(poMsgRead->u32GetDataLength() / FC_MESSAGING_SHORTMESSAGE_MAX_LEN_CHAR_COUNT);

      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_GetMessage_Return(m_oMessageDetailsResult);

      FolderNode* poFolderNode;
      poFolderNode = poSearchNodeByListHandle(m_oLastGetMessageHandle.u32MsgHandleLower);

      if (!poFolderNode)
      {
         ETG_TRACE_USR1(("Null returned"));
         return;
      }

      int u32Index;
      int u32MessageListLength = poFolderNode->m_pvMessageList->size();

      for (u32Index = 0; u32Index < u32MessageListLength; u32Index++)
      {
         if (poFolderNode->m_pvMessageList->at(u32Index).oMessageHandle.u32MsgHandleUpper
               == m_oLastGetMessageHandle.u32MsgHandleUpper)
         {
            ETG_TRACE_USR1(("Match found at index: %d", u32Index));

            if(false == poFolderNode->m_pvMessageList->at(u32Index).bReadStatusFlag)
            {
               QList<most_fi_tcl_MsgMessageHandle> oUnreadMessageHandles;
               oUnreadMessageHandles.append(m_oLastGetMessageHandle);

               vSetMsgUnreadMessageHandles(oUnreadMessageHandles);
            }
            else
            {
               MessagingMutex::messagingMutexUnlock();
            }

            break;
         }
      }
   }
}

tBool FileSystemManager::bDeleteMessageFromDevice()
{
   ETG_TRACE_USR4(("bDeleteMessageFromDevice Called"));

   if (m_lMessageHandlesListForDelete.isEmpty())
   {
      ETG_TRACE_ERR(("List is empty"));
      return false;
   }

   m_oCurrentDeleteMessageHandle = m_lMessageHandlesListForDelete.takeFirst();   
   QMap<tU32, MessageTypeDbusMessageHandleInfo>::const_iterator l_it;
   l_it = m_DbusMessageHandleAndMostUpperHandleMap.find(
         m_oCurrentDeleteMessageHandle.u32MsgHandleUpper);

   if (l_it == m_DbusMessageHandleAndMostUpperHandleMap.end())
   {
      ETG_TRACE_ERR(("Handle not found in Map"));
      return false;
   }

   QString l_sDbusMessageHandle;
   most_fi_tcl_e8_MsgMessageListType l_e8MessageListType;

   l_sDbusMessageHandle = l_it.value().m_sDbusMessageHandle;
   l_e8MessageListType = l_it.value().m_oMessageListType;

   return DbusClientInterface::getInstance().messagingMapSetMsgStatus(m_oCurrentDeleteMessageHandle.u8DeviceHandle ,l_sDbusMessageHandle,
            l_e8MessageListType, MSG_STATUS_DELETED);
}

tBool FileSystemManager::bDeleteMessageMethodStart(
      most_msgfi_tclMsgDeleteMessageMethodStart& f_roDeleteMessageMethodStart)
{
   ETG_TRACE_USR4(("bDeleteMessageMethodStart Called"));
   tU8 l_u8NumMessageToDelete;

   l_u8NumMessageToDelete = static_cast<tU8>(f_roDeleteMessageMethodStart.oDeleteMessageHandles.oItems.size());

   ETG_TRACE_USR1(("Total Message to delete::%d", l_u8NumMessageToDelete));

   tU8 l_u8Index;
   tU8 l_au8DeleteMessageMostHandle[9];

   for (l_u8Index = 0; l_u8Index < l_u8NumMessageToDelete; l_u8Index++)
   {

      most_fi_tcl_ShortStream obj = f_roDeleteMessageMethodStart.oDeleteMessageHandles.oItems[l_u8Index];

      obj.vGetData(l_au8DeleteMessageMostHandle, obj.u8GetDataSize());

      most_fi_tcl_MsgMessageHandle l_oMessageHandle;

      memcpy(&l_oMessageHandle.u8DeviceHandle, (unsigned const char*) l_au8DeleteMessageMostHandle, 1);

      for (int loop = 1; loop <= 4; loop++)
      {
         l_oMessageHandle.u32MsgHandleUpper =
               (l_oMessageHandle.u32MsgHandleUpper << 8) | (unsigned int) l_au8DeleteMessageMostHandle[loop];
      }

      for (int loop = 5; loop <= 8; loop++)
      {
         l_oMessageHandle.u32MsgHandleLower =
               (l_oMessageHandle.u32MsgHandleLower << 8) | (unsigned int) l_au8DeleteMessageMostHandle[loop];
      }

      m_lMessageHandlesListForDelete.append(l_oMessageHandle);
   }

   m_oDeleteMessageMethodStart = f_roDeleteMessageMethodStart;

   return bDeleteMessageFromDevice();
}

tVoid FileSystemManager::vDeleteMessageMethodReturn(tBool f_bStatus)
{
   ETG_TRACE_USR4(("vDeleteMessageMethodReturn Called"));

   if (f_bStatus == SUCCESS)
   {
      FolderNode* l_poFolderNode;
      l_poFolderNode = poSearchNodeByListHandle(m_oCurrentDeleteMessageHandle.u32MsgHandleLower);

      if (!l_poFolderNode)
      {
         return;
      }

      tBool l_isMessageIndexInList = FALSE;
      int l_u32Index;
      int l_u32ListLength;

      l_u32ListLength = l_poFolderNode->m_pvMessageList->size();

      for (l_u32Index = 0; l_u32Index < l_u32ListLength; l_u32Index++)
      {
         if (l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u32MsgHandleUpper ==
               m_oCurrentDeleteMessageHandle.u32MsgHandleUpper)
         {
            l_isMessageIndexInList = TRUE;
            l_poFolderNode->m_pvMessageList->remove(l_u32Index);
            break;
         }
      }

      if (l_isMessageIndexInList)
      {
         ETG_TRACE_USR2(("1 Message remaining to delete::%d", m_lMessageHandlesListForDelete.size()));
         vMessageListChangeNotify(static_cast<tU16>(m_oCurrentDeleteMessageHandle.u32MsgHandleLower),
               static_cast<tU32>(l_poFolderNode->m_pvMessageList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_REMOVED,
               static_cast<tU32>(l_u32Index)); // Lower is list handle
      }

      vDeleteMessageFromConversationList(m_oCurrentDeleteMessageHandle);
      vRemoveDbusMessageHandleonDeletion(m_oCurrentDeleteMessageHandle.u32MsgHandleUpper);
   }

   ETG_TRACE_USR2(("2 Message remaining to delete::%d", m_lMessageHandlesListForDelete.size()));

   if (m_lMessageHandlesListForDelete.isEmpty())
   {
      most_msgfi_tclMsgDeleteMessageMethodResult l_oDeleteMessageMethodResult_MR;

      if (f_bStatus != SUCCESS)
      {
         l_oDeleteMessageMethodResult_MR.e8DeletionStatus.enType =
               most_fi_tcl_e8_MsgDeletionStatus::FI_EN_E8MSG_DELETE_UNSUCCESSFUL;
      }
      else
      {
         l_oDeleteMessageMethodResult_MR.e8DeletionStatus.enType =
               most_fi_tcl_e8_MsgDeletionStatus::FI_EN_E8MSG_DELETE_SUCCESS;
      }

      l_oDeleteMessageMethodResult_MR.oDeleteMessageHandles =
            m_oDeleteMessageMethodStart.oDeleteMessageHandles;

      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_DeleteMessage_Return(
            l_oDeleteMessageMethodResult_MR);
   }
   else
   {
      bDeleteMessageFromDevice();
   }
}

tVoid FileSystemManager::vMessageListChangeNotify(tU16 f_u16ListHandle, tU32 f_u32ListLength,
      most_fi_tcl_e8_MsgListChangeType::tenType f_oListChangeType, tU32 f_u32ChangeItemIndex)
{
   ETG_TRACE_USR4(("vMessageListChangeNotify Called"));
   most_msgfi_tclMsgMessageListChangeStatus l_oMessageListChangeStatus;
   most_fi_tcl_MsgChangeItems l_oChangeItems;

   l_oChangeItems.u32Items.push_back(f_u32ChangeItemIndex);

   l_oMessageListChangeStatus.u16ListHandle = f_u16ListHandle;
   l_oMessageListChangeStatus.e8ListChangeType.enType = f_oListChangeType;
   l_oMessageListChangeStatus.u16ListLength = static_cast<tU16>(f_u32ListLength);
   l_oMessageListChangeStatus.u32NumItems = 1;

   l_oMessageListChangeStatus.oChangeItems = l_oChangeItems;

   fc_messaging_tclService_Messaging::m_poMessagingService->vMessageListChange(
         l_oMessageListChangeStatus);
}

tBool FileSystemManager::bFindConversationMessages(
      most_msgfi_tclMsgGetConversationMessagesMethodStart& f_roGetConversationMessagesMethodStart)
{
   ETG_TRACE_USR4(("bFindConversationMessages Called"));
   tU8 l_u8ReturnValue = 0;

   m_oGetConversationMessagesMethodStart = f_roGetConversationMessagesMethodStart;

   l_u8ReturnValue = u8CheckAllMessageLists(
         f_roGetConversationMessagesMethodStart.oMessageHandle.u8DeviceHandle, e8CreateMessageListRequestForConversationMessage);

   if (l_u8ReturnValue == 0)
   {
      ETG_TRACE_USR2(("All lists are present"));
      bGetConversationMessageHandles(f_roGetConversationMessagesMethodStart);
   }
   else
   {
      ETG_TRACE_USR2(("Inbox list and/or Sent list not present"));
   }
   return true;
}

tU8 FileSystemManager::u8CheckAllMessageLists(tU8 f_u8DeviceHandle, enCreateMessageListRequest createMessageListRequest)
{
   ETG_TRACE_USR4(("u8CheckAllMessageLists Called"));

   FolderNode* l_poFolderNode;
   most_msgfi_tclMsgCreateMessageListMethodStart l_oCreateMessageListMethodStart;

   l_oCreateMessageListMethodStart.u8DeviceHandle = f_u8DeviceHandle;

   l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);

   if (l_poFolderNode && (l_poFolderNode->m_pvMessageList->size() == 0))
   {
      ETG_TRACE_USR1(("Inbox list is not present"));

      l_oCreateMessageListMethodStart.e8FolderType.enType =
            most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX;
      l_oCreateMessageListMethodStart.e8MessageListType.enType =
            most_fi_tcl_e8_MsgMessageListType::FI_EN_E8MSG_LIST_SMS_MMS;

      m_enCreateMessageListRequest = createMessageListRequest;

      vCreateMessageList(l_oCreateMessageListMethodStart);

      return 1;
   }

   l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_SENT);

   if (l_poFolderNode && (l_poFolderNode->m_pvMessageList->size() == 0))
   {
      ETG_TRACE_USR1(("Sent list is not present"));

      l_oCreateMessageListMethodStart.e8FolderType.enType =
            most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT;
      l_oCreateMessageListMethodStart.e8MessageListType.enType =
            most_fi_tcl_e8_MsgMessageListType::FI_EN_E8MSG_LIST_SMS_MMS;

      m_enCreateMessageListRequest = createMessageListRequest;

      vCreateMessageList(l_oCreateMessageListMethodStart);
      return 1;
   }

   return 0;
}

tVoid FileSystemManager::bGetConversationMessageHandles(
      most_msgfi_tclMsgGetConversationMessagesMethodStart& f_roGetConversationMessagesMethodStart)
{
   ETG_TRACE_USR4(("bGetConversationMessageHandles Called"));

   // Bugfix for GMMY16-7568 and GMMY16-7536: Nullpointerexception in
   // /opt/bosch/gm/processes/fc_messaging_out.out" in thread AE_60

   tU32 u32ListHandle;

   u32ListHandle = f_roGetConversationMessagesMethodStart.oMessageHandle.u32MsgHandleLower;

   ETG_TRACE_USR4(("bGetConversationMessageHandles u32ListHandle: %d", u32ListHandle));

   FolderNode* poFolderNode;

   poFolderNode = poSearchNodeByListHandle(u32ListHandle);

   if (poFolderNode)
   {
      ETG_TRACE_USR4(("bGetConversationMessageHandles poFolderNode exists"));
      int l_u32Index;
      int l_u32MessageListLength;
      most_fi_tcl_MsgMessageListSliceResultItem l_oMessageListSliceResultItem;

      l_u32MessageListLength = poFolderNode->m_pvMessageList->size();

      for (l_u32Index = 0; l_u32Index < l_u32MessageListLength; l_u32Index++)
      {
         if (poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle ==
               f_roGetConversationMessagesMethodStart.oMessageHandle)
         {
            ETG_TRACE_USR2(("Match found"));
            l_oMessageListSliceResultItem = poFolderNode->m_pvMessageList->at(l_u32Index);
            break;
         }
      }

      tU32 l_u32MatchFound = 0;

      l_u32MatchFound = u32FindConversationMessageHandlesInList(l_oMessageListSliceResultItem);

      ETG_TRACE_USR2(("Number of match found::%d", l_u32MatchFound));

      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_GetConversationMessages_MethodResult(
            m_vConversationMessageHandles, l_u32MatchFound);

      // clear the vector
      m_vConversationMessageHandles.clear();
   }
   else
   {
      ETG_TRACE_USR4(("bGetConversationMessageHandles poFolderNode is null"));
      fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_GetConversationMessage_Error();
   }
}

QString FileSystemManager::sReverse(const QString f_sStr)
{
   ETG_TRACE_USR4(("sReverse Called"));
   tU16 l_u16Strlen, l_u16Index;
   QChar l_Char;
   QString l_sReversedStr(g_u8PhoneNumberLength);
   QString l_sStringToReturn(g_u8PhoneNumberLength);

   l_u16Strlen = static_cast<tU16>(f_sStr.size());
   for (l_u16Index = 0; l_u16Index < l_u16Strlen; l_u16Index++)
   {
      l_Char = f_sStr[l_u16Index];
      l_sReversedStr.prepend(l_Char);
   }

   l_u16Strlen = static_cast<tU16>(l_sReversedStr.size());
   for (l_u16Index = 0; l_u16Index < l_u16Strlen; l_u16Index++)
   {
      l_Char = l_sReversedStr[l_u16Index];
      if (l_Char == ':')
      {
         break;
      }

      l_sStringToReturn.append(l_Char);
   }

   return l_sStringToReturn;
}

tU32 FileSystemManager::u32FindConversationMessageHandlesInList(
      most_fi_tcl_MsgMessageListSliceResultItem& f_roMessageListSliceResultItem)
{
   ETG_TRACE_USR4(("u32FindConversationMessageHandlesInList Called"));

   QVector<most_fi_tcl_MsgMessageListSliceResultItem> l_oMessageListSliceResultItem;
   FolderNode* l_poFolderNode;
   int l_u32Index;
   QString l_sSubject;
   QString l_sPhoneNumber;
   QString l_sStringToCompare;
   int l_u32MessageListLength;

   l_sSubject = f_roMessageListSliceResultItem.sSubject.szValue;
   l_sPhoneNumber = f_roMessageListSliceResultItem.sPhoneNumber.szValue;

   l_sSubject = sReverse(l_sSubject);
   l_sPhoneNumber = sReverse(l_sPhoneNumber);

   l_sPhoneNumber.truncate(g_u8PhoneNumberLength);
   ETG_TRACE_USR4(("Phone number to compare::%s", l_sPhoneNumber.toUtf8().constData()));

   l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);

   if (l_poFolderNode)
   {
      if (l_poFolderNode->m_pvMessageList)
      {
         l_u32MessageListLength = l_poFolderNode->m_pvMessageList->size();

         for (l_u32Index = 0; l_u32Index < l_u32MessageListLength; l_u32Index++)
         {
            if (f_roMessageListSliceResultItem.e8MessageType.enType ==
                  most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_EMAIL)
            {
               l_sStringToCompare = sReverse(l_poFolderNode->m_pvMessageList->at(l_u32Index).sSubject.szValue);

               if (!QString::compare(l_sStringToCompare, l_sSubject, Qt::CaseInsensitive))
               {
                  l_oMessageListSliceResultItem.push_back(l_poFolderNode->m_pvMessageList->at(l_u32Index));
               }
            }
            else
            {
               l_sStringToCompare = sReverse(l_poFolderNode->m_pvMessageList->at(l_u32Index).sPhoneNumber.szValue);

               l_sStringToCompare.truncate(g_u8PhoneNumberLength);

               ETG_TRACE_USR2(("l_sStringToCompare to compare in inbox::%s", l_sStringToCompare.toUtf8().constData()));

               if (!QString::compare(l_sStringToCompare, l_sPhoneNumber, Qt::CaseInsensitive))
               {
                  ETG_TRACE_USR2(("Match found"));

                  l_oMessageListSliceResultItem.push_back(l_poFolderNode->m_pvMessageList->at(l_u32Index));
               }
            }
         }
      }
   }

   l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_SENT);

   if (l_poFolderNode)
   {
      if (l_poFolderNode->m_pvMessageList)
      {
         l_u32MessageListLength = l_poFolderNode->m_pvMessageList->size();

         for (l_u32Index = 0; l_u32Index < l_u32MessageListLength; l_u32Index++)
         {
            if (f_roMessageListSliceResultItem.e8MessageType.enType ==
                  most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_EMAIL)
            {
               l_sStringToCompare = sReverse(l_poFolderNode->m_pvMessageList->at(l_u32Index).sSubject.szValue);

               if (!QString::compare(l_sStringToCompare, l_sSubject, Qt::CaseInsensitive))
               {

                  l_oMessageListSliceResultItem.push_back(l_poFolderNode->m_pvMessageList->at(l_u32Index));
               }
            }
            else
            {
               l_sStringToCompare = sReverse(l_poFolderNode->m_pvMessageList->at(l_u32Index).sPhoneNumber.szValue);

               l_sStringToCompare.truncate(g_u8PhoneNumberLength);

               ETG_TRACE_USR2(("l_sStringToCompare to compare in sent::%s", l_sStringToCompare.toUtf8().constData()));

               if (!QString::compare(l_sStringToCompare, l_sPhoneNumber, Qt::CaseInsensitive))
               {
                  ETG_TRACE_USR2(("Match found"));
                  l_oMessageListSliceResultItem.push_back(l_poFolderNode->m_pvMessageList->at(l_u32Index));
               }
            }
         }
      }
   }

   bSortMessageList(&l_oMessageListSliceResultItem);

   tU8 l_u8Index;
   tU32 l_u32ConversationMessageCount = 0;
   tU8 l_au8ConversationMessageHandle[9];
   const tU8 l_cu8NumConversationMessage = g_u8NumConversationMessage;

   tU8 *p1 = NULLPTR, *p2 = NULLPTR;

   for (l_u32Index = 0;
         (l_u32Index < l_oMessageListSliceResultItem.size() && (l_u32ConversationMessageCount < l_cu8NumConversationMessage));
         l_u32Index++)
   {
      most_fi_tcl_ShortStream l_oConversationMessageHandle;

      l_au8ConversationMessageHandle[0] = l_oMessageListSliceResultItem.at(l_u32Index).oMessageHandle.u8DeviceHandle;

      p1 = l_au8ConversationMessageHandle + 1;
      p2 = (tU8*) const_cast<tU32*>(&l_oMessageListSliceResultItem.at(l_u32Index).oMessageHandle.u32MsgHandleUpper); //lint fix
      p2 = p2 + 3;

      for (l_u8Index = 0; l_u8Index < 4; l_u8Index++)
      {
         *p1 = *p2;
         p1++;
         p2--;
      }

      p1 = l_au8ConversationMessageHandle + 5;
      p2 = (tU8*) const_cast<tU32*>(
            &l_oMessageListSliceResultItem.at(l_u32Index).oMessageHandle.u32MsgHandleLower); //lint fix
      p2 = p2 + 3;

      for (l_u8Index = 0; l_u8Index < 4; l_u8Index++)
      {
         *p1 = *p2;
         p1++;
         p2--;
      }

      l_oConversationMessageHandle.vSetData(l_au8ConversationMessageHandle, 9);
      m_vConversationMessageHandles.push_back(l_oConversationMessageHandle);

      l_u32ConversationMessageCount++;
   }

   return l_u32ConversationMessageCount;
}

tBool FileSystemManager::bSortMessageList(
      QVector<most_fi_tcl_MsgMessageListSliceResultItem>* pMessageList)
{
   ETG_TRACE_USR4(("bSortMessageList Called"));

   std::sort(pMessageList->begin(), pMessageList->end(), bCompareByTimeStamp);

   return true;
}

tBool FileSystemManager::bSortConversationList(QVector<most_fi_tcl_MsgConversationListSliceResultItem>* pConversationList)
{
   ETG_TRACE_USR4(("bSortConversationList() called"));

   std::sort(pConversationList->begin(), pConversationList->end(), bCompareConversationByTimeStamp);

   return true;
}

tBool FileSystemManager::bSortConversationDetailList(QVector<most_fi_tcl_MsgConversationDetailListItem>* pConversationDetailList)
{
   ETG_TRACE_USR4(("bSortConversationDetailList() called"));

   std::sort(pConversationDetailList->begin(), pConversationDetailList->end(), bCompareConversationDetailByTimeStamp);

   return true;
}

tVoid FileSystemManager::vAddMessageinConversationList(most_fi_tcl_MsgMessageListSliceResultItem& messageListSliceResultItem,
      tU32 attachmentSize, most_fi_tcl_e8_MsgMessageStatus::tenType messageStatus,
      most_fi_tcl_e8_MsgAddressFieldType::tenType addressFieldType)
{
   ETG_TRACE_USR4(("vAddMessageinConversationList() Called"));

   most_fi_tcl_MsgConversationHandle conversationHandle;
   most_fi_tcl_MsgConversationListSliceResultItem conversationListSliceResultItem;

   FolderNode* folderNode;
   QString qstrPhoneNumber;
   tBool matchFound = false;

   folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);

   if (folderNode && folderNode->m_pvConversationList)
   {
      if (messageListSliceResultItem.e8MessageType.enType == most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_EMAIL)
      {
         int index;
         QString qstrSubject;
         QString l_sStringToCompare;
         qstrSubject = messageListSliceResultItem.sSubject.szValue;
         qstrSubject = sReverse(qstrSubject);

         int conversationListSize = folderNode->m_pvConversationList->size();
         for (index = 0; (!qstrSubject.isEmpty()) && (index < conversationListSize); index++)
         {
            l_sStringToCompare = sReverse(folderNode->m_pvConversationList->at(index).sSubject.szValue);

            if (!QString::compare(l_sStringToCompare, qstrSubject, Qt::CaseInsensitive))
            {
               //Match found, update conversation list;
               //TODO FOR EMAIL
            }
         }
      }
      else
      {
         qstrPhoneNumber = messageListSliceResultItem.sPhoneNumber.szValue;
         qstrPhoneNumber = sReverse(qstrPhoneNumber);
         qstrPhoneNumber.truncate(g_u8PhoneNumberLength);
         qstrPhoneNumber = qstrPhoneNumber.trimmed();

         ETG_TRACE_USR4(("Phone number to compare : %s", qstrPhoneNumber.toUtf8().constData()));

         QMap<QString, tU32>::iterator it;
         it = m_mapPhoneNoAndConversationID.find(qstrPhoneNumber);

         if (it != m_mapPhoneNoAndConversationID.end())
         {
            ETG_TRACE_USR2(("Match found, Updating the conversation in Conversation List"));

            matchFound = true;

            //Get the conversation handle, this is required to update the Conversation Detail List
            //conversationHandle.u8DeviceHandle = folderNode->m_pvConversationList->at(index).oConversationHandle.u8DeviceHandle;
            conversationHandle.u32ConversationID = it.value();

            QVector<most_fi_tcl_MsgConversationListSliceResultItem>::iterator oConvListIter;

            for(oConvListIter = folderNode->m_pvConversationList->begin(); oConvListIter != folderNode->m_pvConversationList->end();)
            {
               if(conversationHandle.u32ConversationID == oConvListIter->oConversationHandle.u32ConversationID)
               {
                  //Update the below fields only if the processing message is latest.
                  if(0 < timeStampCompareResult(messageListSliceResultItem.oMessageDateTime, oConvListIter->oLastActivity))
                  {
                     //Update the DateTime, Subject, AttachmentSize, MessageType and UnreadMessageCount from latest message
                     oConvListIter->oLastActivity = messageListSliceResultItem.oMessageDateTime;
                     oConvListIter->sSubject.bSet(messageListSliceResultItem.sSubject.szValue); //Subject will be truncated later
                     oConvListIter->u32AttachmentSize = attachmentSize;
                     oConvListIter->e8MessageType.enType = messageListSliceResultItem.e8MessageType.enType;
                  }

                  if(false == messageListSliceResultItem.bReadStatusFlag)
                  {
                     oConvListIter->u8UnreadMessageCount++;
                  }

                  oConvListIter->u32NumberOfMessages++;

                  oConvListIter->oAddressField.e8AddressFieldType.enType = addressFieldType;
                  //below field updates are not necessary
                  //oConvListIter->oAddressField.sFirstName.bSet();
                  //oConvListIter->oAddressField.sLastName.bSet();
                  //oConvListIter->oAddressField.sEmailAddress.bSet();
                  //oConvListIter->oAddressField.sPhoneNumber.bSet();
                  //oConvListIter->u32ContactHandle = 0;

                  break;
               }
               else
               {
                  oConvListIter++;
               }
            }
         }
      }

      if(false == matchFound)
      {
         ETG_TRACE_USR4(("Match not found, adding the message as conversation into Conversation List"));

         //first message, add to conversation list
         conversationHandle.u8DeviceHandle = messageListSliceResultItem.oMessageHandle.u8DeviceHandle;
         conversationHandle.u32ConversationID = ++m_u32ConversationID;

         if(!qstrPhoneNumber.isEmpty())
         {
            m_mapPhoneNoAndConversationID.insert(qstrPhoneNumber, conversationHandle.u32ConversationID);
         }

         conversationListSliceResultItem.oConversationHandle = conversationHandle;
         conversationListSliceResultItem.oLastActivity = messageListSliceResultItem.oMessageDateTime;
         conversationListSliceResultItem.sSubject.bSet(messageListSliceResultItem.sSubject.szValue); //Subject will be truncated later
         conversationListSliceResultItem.u32AttachmentSize = attachmentSize;
         conversationListSliceResultItem.e8MessageType.enType = messageListSliceResultItem.e8MessageType.enType;

         if(true == messageListSliceResultItem.bReadStatusFlag)
         {
            conversationListSliceResultItem.u8UnreadMessageCount = 0;
         }
         else
         {
            conversationListSliceResultItem.u8UnreadMessageCount = 1;
         }

         conversationListSliceResultItem.u32NumberOfMessages = 1;

         //Address field
         conversationListSliceResultItem.oAddressField.e8AddressFieldType.enType = addressFieldType;
         conversationListSliceResultItem.oAddressField.sFirstName.bSet(messageListSliceResultItem.sFirstName.szValue);
         conversationListSliceResultItem.oAddressField.sLastName.bSet(messageListSliceResultItem.sLastName.szValue);
         conversationListSliceResultItem.oAddressField.sEmailAddress.bSet(messageListSliceResultItem.sEmailAddress.szValue);
         conversationListSliceResultItem.oAddressField.sPhoneNumber.bSet(messageListSliceResultItem.sPhoneNumber.szValue);
         conversationListSliceResultItem.u32ContactHandle = 0;

         folderNode->m_pvConversationList->push_back(conversationListSliceResultItem);
      }

      //This has been done in RequestSliceConversationList MethodReturn
      //bSortConversationList(folderNode->m_pvConversationList);

      FileSystem::vAddMessageInConversationDetailList(conversationHandle.u32ConversationID, messageListSliceResultItem,
            attachmentSize, messageStatus, addressFieldType);
   }

   //Read messages from device
   m_lReadingMessageHandlesList.append(messageListSliceResultItem.oMessageHandle);
}

tVoid FileSystemManager::vGetMessagesForConversation()
{
   ETG_TRACE_USR4(("vGetMessagesForConversation() called"));

   if(FALSE == m_lReadingMessageHandlesList.isEmpty())
   {
      most_fi_tcl_MsgMessageHandle f_roMessageHandle;
      f_roMessageHandle = m_lReadingMessageHandlesList.takeFirst();

      vGetMessage(f_roMessageHandle, e8ConversationDetail);
   }
   else
   {
      //MessageListChange update to clients
      FolderNode* l_poConvFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);;

      if(l_poConvFolderNode && l_poConvFolderNode->m_pvConversationList)
      {
         if(m_enCreateMessageListRequest == e8CreateMessageListRequestForConversationFolder)
         {
            tU8 bRet = u8CheckAllMessageLists(static_cast<tU8>(l_poConvFolderNode->m_u32ListHandle >> 8), e8CreateMessageListRequestForConversationFolder);

            if(bRet == 0)
            {
               fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_CreateMessageList_Return(
                     static_cast<tU16>(l_poConvFolderNode->m_u32ListHandle), static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()));

               //Send MessageListChange for ConversationList
               vMessageListChangeNotify((tU16)l_poConvFolderNode->m_u32ListHandle,
                     static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
                     most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_CONTENT_CHANGED, 0);

               m_enCreateMessageListRequest = e8CreateMessageListRequestInvalid;
            }
         }
         else
         {
            vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
                  static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
                  most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED, 0); // will be zero :)

            MessagingMutex::messagingMutexUnlock();
         }
      }
   }
}

tVoid FileSystemManager::vGetMessagesForSubject(most_fi_tcl_MsgMessageHandle f_roMessageHandle)
{
   ETG_TRACE_USR4(("vGetMessagesForSubject() called"));

   most_fi_tcl_MsgMessageHandle* g_messageHandle = new most_fi_tcl_MsgMessageHandle;
   if(g_messageHandle)
   {
      g_messageHandle->u8DeviceHandle = f_roMessageHandle.u8DeviceHandle;
      g_messageHandle->u32MsgHandleUpper = f_roMessageHandle.u32MsgHandleUpper;
      g_messageHandle->u32MsgHandleLower = f_roMessageHandle.u32MsgHandleLower;
      struct Job* l_prJob = NULLPTR;
      _BP_TRY_BEGIN
      {
         l_prJob = new Job;
      }
      _BP_CATCH_ALL
      {
         ETG_TRACE_USR4(("vGetMessagesForSubject() Exception Caught"));
         g_messageHandle->vDestroy();
         OSAL_DELETE g_messageHandle;
         return;
      }
      _BP_CATCH_END

      if(l_prJob)
      {
         l_prJob->m_pfMethod  = &fc_messaging_tclService_Messaging::vHandle_GetMessageforSubject;
         l_prJob->u8DeviceHandle = f_roMessageHandle.u8DeviceHandle;
         l_prJob->u16CmdCounter = 0;
         l_prJob->u16FunctionID = 0;
         l_prJob->u16RegisterID = 0;
         l_prJob->u16SourceAppID = 0;
         l_prJob->m_pvMethodStart = g_messageHandle;

         if(0 != MessagingMutex::messagingMutexTrylock(l_prJob))
         {
            ETG_TRACE_USR4(("Lock for Get Message for Subject not obtained:Added to workqueue"));
            tVoid*  pCustodialLose = l_prJob ;  //To remove LINT warning : Custodial Pointer
            (tVoid) pCustodialLose ;
            return;
         }
         OSAL_DELETE l_prJob;
      }

      vGetMessage(f_roMessageHandle, e8SubjectUpdate);
      g_messageHandle->vDestroy();
      OSAL_DELETE g_messageHandle;
   }
}

tVoid FileSystemManager::vUpdateMessageContentInConversationDetailList(most_fi_tcl_MsgMessageHandle oMessageHandle, QString sMessageContent)
{
   ETG_TRACE_USR4(("vUpdateMessageContentInConversationDetailList() called"));

   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
   if (folderNode)
   {
      QMap< tU32, QVector<most_fi_tcl_MsgConversationDetailListItem> >::iterator oConvDetailListIter;

      for (oConvDetailListIter = folderNode->m_pvConversationDetailList.begin();
            oConvDetailListIter != folderNode->m_pvConversationDetailList.end(); oConvDetailListIter++)
      {
         QVector<most_fi_tcl_MsgConversationDetailListItem>::iterator oConvDetailListItemIter;

         bSortConversationDetailList(&oConvDetailListIter.value()); //TODO check timing

         for(oConvDetailListItemIter = oConvDetailListIter.value().begin(); oConvDetailListItemIter != oConvDetailListIter.value().end(); )
         {
            if((oMessageHandle.u8DeviceHandle == oConvDetailListItemIter->oMessageHandle.u8DeviceHandle) &&
                  (oMessageHandle.u32MsgHandleUpper == oConvDetailListItemIter->oMessageHandle.u32MsgHandleUpper) &&
                  (oMessageHandle.u32MsgHandleLower == oConvDetailListItemIter->oMessageHandle.u32MsgHandleLower))
            {
               //TODO is tU8 sufficient here, check this. it is possible that index position can exceed 255.
               tU8 u8MsgIndexInConversationDetail = static_cast<tU8>(oConvDetailListItemIter - oConvDetailListIter.value().begin());

               //Update sMessageContent field
               oConvDetailListItemIter->sMessageContent.bSet(sMessageContent.toUtf8());

               if(0 == u8MsgIndexInConversationDetail)
               {
                  vUpdateSubjectInConversationList(oConvDetailListIter.key(), sMessageContent);
               }

               break;
            }
            else
            {
               oConvDetailListItemIter++;
            }
         }
      }
   }
}

tVoid FileSystemManager::vUpdateShortMessageInMessageList(most_fi_tcl_MsgMessageHandle oMessageHandle, QString sMessageContent)
{
   ETG_TRACE_USR4(("vUpdateShortMessageInMessageList() called"));
   int l_u32Index;
   int l_u32MessageListLength;
   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);
   if (folderNode)
   {
      l_u32MessageListLength = folderNode->m_pvMessageList->size();

      for (l_u32Index = 0; l_u32Index < l_u32MessageListLength; l_u32Index++)
      {
         if((oMessageHandle.u8DeviceHandle == folderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u8DeviceHandle) &&
                  (oMessageHandle.u32MsgHandleUpper == folderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u32MsgHandleUpper) &&
                  (oMessageHandle.u32MsgHandleLower == folderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u32MsgHandleLower))
         {
             ETG_TRACE_USR4(("Short Message Updated called"));
             (*folderNode->m_pvMessageList)[l_u32Index].sShortMessage.bSet(sMessageContent.toUtf8());
             vMessageListChangeNotify((tU16) folderNode->m_u32ListHandle,
        	                static_cast<unsigned int>(folderNode->m_pvMessageList->size()),
        	                most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,static_cast<unsigned int>(l_u32Index));
             break;
         }
      }
   }

   MessagingMutex::messagingMutexUnlock();
}

tVoid FileSystemManager::vUpdateSubjectInConversationList(tU32 u32ConversationID, QString sSubject)
{
   ETG_TRACE_USR4(("vUpdateSubjectInConversationList() called"));

   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);

   if (folderNode && folderNode->m_pvConversationList)
   {
      QVector<most_fi_tcl_MsgConversationListSliceResultItem>::iterator oConvListIter;

      for(oConvListIter = folderNode->m_pvConversationList->begin(); oConvListIter != folderNode->m_pvConversationList->end();)
      {
         if(u32ConversationID == oConvListIter->oConversationHandle.u32ConversationID)
         {
            sSubject.truncate(CONVERSATION_LIST_SUBJECT_LENGTH);
            oConvListIter->sSubject.bSet(sSubject.toUtf8());

            break;
         }
         else
         {
            oConvListIter++;
         }
      }
   }
}

tVoid FileSystemManager::vUpdateReadStatusFlagInConversationDetailList(most_fi_tcl_MsgMessageHandle oMessageHandle, tBool bReadStatusFlag)
{
   ETG_TRACE_USR4(("vUpdateReadStatusFlagInConversationDetailList() called"));

   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
   if (!folderNode)
   {
      ETG_TRACE_USR4(("Conversation Folder is NULL"));
      return;
   }

   QMap< tU32, QVector<most_fi_tcl_MsgConversationDetailListItem> >::iterator oConvDetailListIter;

   for (oConvDetailListIter = folderNode->m_pvConversationDetailList.begin();
         oConvDetailListIter != folderNode->m_pvConversationDetailList.end(); oConvDetailListIter++)
   {
      QVector<most_fi_tcl_MsgConversationDetailListItem>::iterator oConvDetailListItemIter;

      //Sorting already has been done while updating MessageContent, also not required for this update
      for(oConvDetailListItemIter = oConvDetailListIter.value().begin(); oConvDetailListItemIter != oConvDetailListIter.value().end(); oConvDetailListItemIter++)
      {
         if((oMessageHandle.u8DeviceHandle == oConvDetailListItemIter->oMessageHandle.u8DeviceHandle) &&
               (oMessageHandle.u32MsgHandleUpper == oConvDetailListItemIter->oMessageHandle.u32MsgHandleUpper) &&
               (oMessageHandle.u32MsgHandleLower == oConvDetailListItemIter->oMessageHandle.u32MsgHandleLower))
         {
            //Update bReadStatusFlag field
            oConvDetailListItemIter->bReadStatusFlag = bReadStatusFlag;

            //Update UnreadMessageCount in Conversation List also
            vUpdateReadStatusFlagInConversationList(oConvDetailListIter.key(), bReadStatusFlag);
         }
      }
   }
}

tVoid FileSystemManager::vUpdateReadStatusFlagInConversationList(tU32 u32ConversationID, tBool bReadStatusFlag)
{
   ETG_TRACE_USR4(("vUpdateReadStatusFlagInConversationList() called"));

   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
   if (!folderNode)
   {
      ETG_TRACE_USR4(("Conversation Folder is NULL"));
      return;
   }

   if (folderNode->m_pvConversationList && bReadStatusFlag)
   {
      for(tU8 index = 0; index < folderNode->m_pvConversationList->size(); index++)
      {
         if(folderNode->m_pvConversationList->at(index).oConversationHandle.u32ConversationID == u32ConversationID)
         {
            (*folderNode->m_pvConversationList)[index].u8UnreadMessageCount--;
            break;
         }
      }
   }
}

tVoid FileSystemManager::vDeleteMessageFromConversationList(most_fi_tcl_MsgMessageHandle oMessageHandle)
{
   ETG_TRACE_USR4(("vDeleteMessageFromConversationList() called"));

   tU8 u8ConversationIndex = 0;
   tU8 u8DeletedConversationDetailIndex = 0xFF;

   //Remove from Conversation Detail List
   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
   if (folderNode && folderNode->m_pvConversationList)
   {
      QVector<most_fi_tcl_MsgConversationListSliceResultItem>::iterator oConvListIter;
      QMap< tU32, QVector<most_fi_tcl_MsgConversationDetailListItem> >::iterator oConvDetailListIter;

      for (oConvDetailListIter = folderNode->m_pvConversationDetailList.begin();
            ((oConvDetailListIter != folderNode->m_pvConversationDetailList.end()) && (0xFF == u8DeletedConversationDetailIndex)); oConvDetailListIter++)
      {
         QVector<most_fi_tcl_MsgConversationDetailListItem>::iterator oConvDetailListItemIter;

         bSortConversationDetailList(&oConvDetailListIter.value());

         for(oConvDetailListItemIter = oConvDetailListIter.value().begin(); oConvDetailListItemIter != oConvDetailListIter.value().end(); )
         {
            if((oConvDetailListItemIter->oMessageHandle.u8DeviceHandle == oMessageHandle.u8DeviceHandle) &&
                  (oConvDetailListItemIter->oMessageHandle.u32MsgHandleUpper == oMessageHandle.u32MsgHandleUpper) &&
                  (oConvDetailListItemIter->oMessageHandle.u32MsgHandleLower == oMessageHandle.u32MsgHandleLower))
            {
               tBool readStatusFlag = oConvDetailListItemIter->bReadStatusFlag;

               //TODO is tU8 sufficient here, check this. it is possible that index position can exceed 255.
               u8DeletedConversationDetailIndex = static_cast<tU8>(oConvDetailListItemIter - oConvDetailListIter.value().begin());

               ETG_TRACE_USR4(("Match found at index: %d", u8DeletedConversationDetailIndex));

               //Remove the message item in the list
               oConvDetailListItemIter = oConvDetailListIter.value().erase(oConvDetailListItemIter);

               ETG_TRACE_USR4(("Remaining items in the ConversationDetailList: %d", oConvDetailListIter.value().size()));

               if(0 < oConvDetailListIter.value().size())
               {
                  //If deleted element is in top of the list, then update the Conversation List
                  if(0 == u8DeletedConversationDetailIndex)
                  {
                     //update conversation list
                     for(tU8 index = 0; index < folderNode->m_pvConversationList->size(); index++)
                     {
                        if(folderNode->m_pvConversationList->at(index).oConversationHandle.u32ConversationID == oConvDetailListIter.key())
                        {
                           (*folderNode->m_pvConversationList)[index].oLastActivity = oConvDetailListIter.value().at(0).oMessageDateTime;

                           QString sSubject = QString::fromUtf8(oConvDetailListIter.value().at(0).sMessageContent.szValue);
                           sSubject.truncate(CONVERSATION_LIST_SUBJECT_LENGTH); //truncate to 160 chars

                           (*folderNode->m_pvConversationList)[index].sSubject.bSet(sSubject.toUtf8());
                           (*folderNode->m_pvConversationList)[index].u32AttachmentSize = oConvDetailListIter.value().at(0).u32AttachmentSize;
                           (*folderNode->m_pvConversationList)[index].e8MessageType.enType = oConvDetailListIter.value().at(0).e8MessageType.enType;

                           //Check deleted message's read status and update UnreadMessageCount
                           if(false == readStatusFlag)
                           {
                              //if not read then decrement the value. else ignore it
                              (*folderNode->m_pvConversationList)[index].u8UnreadMessageCount--;
                           }

                           (*folderNode->m_pvConversationList)[index].u32NumberOfMessages--;

                           //bSortConversationList(folderNode->m_pvConversationList); //not required here

                           break;
                        }
                     }
                  }

                  //Send Message List Change update (ITEMS_CHANGED) if Conversation updated
                  vMessageListChangeNotify(static_cast<tU16>(folderNode->m_u32ListHandle),
                        static_cast<tU32>(folderNode->m_pvConversationList->size()),
                        most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,
                        static_cast<tU32>(u8ConversationIndex));
               }
               else
               {
                  for(oConvListIter = folderNode->m_pvConversationList->begin(); oConvListIter != folderNode->m_pvConversationList->end();)
                  {
                     if(oConvListIter->oConversationHandle.u32ConversationID == oConvDetailListIter.key())
                     {
                        //Remove the PhoneNumber and ConversationID mapping
                        QString qstrPhoneNumber = oConvListIter->oAddressField.sPhoneNumber.szValue;
                        qstrPhoneNumber = sReverse(qstrPhoneNumber);
                        qstrPhoneNumber.truncate(g_u8PhoneNumberLength);
                        qstrPhoneNumber = qstrPhoneNumber.trimmed();

                        ETG_TRACE_USR4(("Phone number to delete : %s", qstrPhoneNumber.toUtf8().constData()));

                        QMap<QString, tU32>::iterator it;
                        it = m_mapPhoneNoAndConversationID.find(qstrPhoneNumber);

                        if(it != m_mapPhoneNoAndConversationID.end())
                        {
                           m_mapPhoneNoAndConversationID.erase(it);
                        }

                        //Delete the conversation completely
                        folderNode->m_pvConversationList->erase(oConvListIter);

                        //sorting not require here since item is removed and no update in the last activity
                        //bSortConversationList(folderNode->m_pvConversationList);

                        break;
                     }
                     else
                     {
                        oConvListIter++;
                     }
                  }

                  //Delete Conversation entry in Conversation Detail List
                  oConvDetailListIter = folderNode->m_pvConversationDetailList.erase(oConvDetailListIter);

                  //Send Message List Change update (ITEMS_REMOVED) if Conversation deleted
                  vMessageListChangeNotify(static_cast<tU16>(folderNode->m_u32ListHandle),
                        static_cast<tU32>(folderNode->m_pvConversationList->size()),
                        most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_REMOVED,
                        static_cast<tU32>(u8ConversationIndex));
               }

               break;
            }
            else
            {
               oConvDetailListItemIter++;
            }
         }

         u8ConversationIndex++; //increment index value, iterating to next conversation
      }
   }
}

tVoid FileSystemManager::vSetMsgUnreadMessageHandles(QList<most_fi_tcl_MsgMessageHandle> oUnreadMessageHandles)
{
   while(TRUE != oUnreadMessageHandles.isEmpty())
   {
      m_lUnreadMessageHandlesList.append(oUnreadMessageHandles.takeFirst());
   }

   vSetMsgReadStatusFlagInDevice();
}

tVoid FileSystemManager::vSetMsgReadStatusFlagInDevice()
{
   ETG_TRACE_USR4(("vSetMsgReadStatusFlagInDevice() called"));

   if(TRUE != m_lUnreadMessageHandlesList.isEmpty())
   {
      m_oCurrentSetMessageHandle = m_lUnreadMessageHandlesList.takeFirst();

      QMap<tU32, MessageTypeDbusMessageHandleInfo>::const_iterator l_it;
      l_it = m_DbusMessageHandleAndMostUpperHandleMap.find(m_oCurrentSetMessageHandle.u32MsgHandleUpper);

      if (l_it != m_DbusMessageHandleAndMostUpperHandleMap.end())
      {
         ETG_TRACE_USR4(("DBus MessageHandle found in Map"));
         QString l_sDbusMessageHandle;
         most_fi_tcl_e8_MsgMessageListType l_e8MessageListType;

         l_sDbusMessageHandle = l_it.value().m_sDbusMessageHandle;
         l_e8MessageListType = l_it.value().m_oMessageListType;

         (tBool)DbusClientInterface::getInstance().messagingMapSetMsgStatus(m_oCurrentSetMessageHandle.u8DeviceHandle ,l_sDbusMessageHandle,
               l_e8MessageListType, MSG_STATUS_READ);
      }
   }
}

tVoid FileSystemManager::vSetMsgReadStatusReturn(tU8 u8Status)
{
   FolderNode* l_poFolderNode;
   l_poFolderNode = poSearchNodeByListHandle(m_oCurrentSetMessageHandle.u32MsgHandleLower);

   if (!l_poFolderNode)
   {
      return;
   }

   int u32Index;
   int u32MessageListLength;

   u32MessageListLength = l_poFolderNode->m_pvMessageList->size();

   for (u32Index = 0; u32Index < u32MessageListLength; u32Index++)
   {
      if (l_poFolderNode->m_pvMessageList->at(u32Index).oMessageHandle.u32MsgHandleUpper
            == m_oCurrentSetMessageHandle.u32MsgHandleUpper)
      {
         ETG_TRACE_USR1(("Match found at index: %d", u32Index));

         if(SUCCESS == u8Status)
         {
            //tBool msgReadStatus = l_poFolderNode->m_pvMessageList->at(u32Index).bReadStatusFlag;

            (*l_poFolderNode->m_pvMessageList)[u32Index].bReadStatusFlag = true;

            vUpdateReadStatusFlagInConversationDetailList(m_oCurrentSetMessageHandle, true);
         }

         break;
      }
   }

   if(TRUE != m_lUnreadMessageHandlesList.isEmpty())
   {
      vSetMsgReadStatusFlagInDevice();
   }
   else
   {
      vMessageListChangeNotify((tU16) l_poFolderNode->m_u32ListHandle,
            static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()),
            most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,
            static_cast<unsigned int>(u32Index));

      //send message list change for conversation folder also
      FolderNode* l_poConvFolderNode;
      l_poConvFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);

      if(l_poConvFolderNode)
      {
         vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
               static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,
               0); //TODO index needs to be updated
      }

      MessagingMutex::messagingMutexUnlock();
   }
}

tVoid FileSystemManager::vSetCreateMessageListInProgressFolderName(QString f_sFolderName)
{
   ETG_TRACE_USR4(("vSetCreateMessageListInProgressFolderName Called"));
   m_sCreateMessageListInProgressFolderName = f_sFolderName;
}

/* Bugfix for GMMY15-5992 Large empty gap is present in text messages list */
QString FileSystemManager::sGetCreateMessageListInProgressFolderName()
{
   return m_sCreateMessageListInProgressFolderName;
}

tVoid FileSystemManager::vNewIncomingMessageReceived(tU8 f_u8DeviceHandle, MsgListing_t* f_poMessageList)
{
   ETG_TRACE_USR4(("vNewIncomingMessageReceived Called"));

   most_fi_tcl_MsgMessageHandle l_oMessageHandle;

   l_oMessageHandle.u8DeviceHandle = f_u8DeviceHandle;

   FolderNode* l_poConvFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);;
   tU8 u8ConvListSize = 0;

   if(l_poConvFolderNode && l_poConvFolderNode->m_pvConversationList)
   {
      u8ConvListSize = static_cast<tU8>(l_poConvFolderNode->m_pvConversationList->size());
   }

   ETG_TRACE_USR4(("Inserting info into Inbox folder"));
   vSetCreateMessageListInProgressFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);

   l_oMessageHandle.u32MsgHandleUpper = u32AddMessageInList(f_u8DeviceHandle, f_poMessageList);

   FolderNode* l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);

   ETG_TRACE_USR4(("got info from inbox folder"));

   if (l_poFolderNode)
   {
      l_oMessageHandle.u32MsgHandleLower = l_poFolderNode->m_u32ListHandle;
	  
      /*CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging */
      tU8 u8MessgeType = f_poMessageList->u8GetMessageType();
      tU8 u8MessgeNotifyType = f_poMessageList->u8GetNotifyType();
	  
      vMessageNotify(l_oMessageHandle, u8MessgeType, u8MessgeNotifyType);
      
      // Bug-Fix for GMMY15-1229 - Two successive New incoming messages.

      tU32 u32ChangeItemIndex = 0;
      //Bug fix for GMMY15-9513 Null Pointer Exception In Messaging.out
      if (l_poFolderNode->m_pvMessageList->size() > 1)
      {
         most_fi_tcl_MsgMessageListSliceResultItem l_oMessageListSliceResultItem;
         QVector<most_fi_tcl_MsgMessageListSliceResultItem>::iterator it = l_poFolderNode->m_pvMessageList->end();
         it--;
         l_oMessageListSliceResultItem = *it;
         if (true == bCompareByTimeStamp(l_oMessageListSliceResultItem, l_poFolderNode->m_pvMessageList->at(0)))
         {
            u32ChangeItemIndex = 0;
         }
         else if (true == bCompareByTimeStamp(l_oMessageListSliceResultItem, l_poFolderNode->m_pvMessageList->at(1)))
         {
            u32ChangeItemIndex = 1;
         }
         vSortMessageList(static_cast<tU8>(u32ChangeItemIndex));
      }
      vMessageListChangeNotify((tU16) l_poFolderNode->m_u32ListHandle,
            static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()),
            most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_ADDED, u32ChangeItemIndex);
   }

   if(l_poConvFolderNode && l_poConvFolderNode->m_pvConversationList)
   {
      if(l_poConvFolderNode->m_pvConversationList->size() > u8ConvListSize)
      {
         vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
               static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_ADDED, 0); // will be zero :)
      }
      //ITEMS_CHANGED will be sent after message read from the device
      //else
      //{
      //   vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
      //         static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
      //         most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED, 0); // will be zero :)
      //}
   }

   // Bugfix for GMMY16-7664: Contact name displayed as mass code in the incoming text alert
   NewIncomingMessageInfo l_oNewIncoimgMessageInfo;
   l_oNewIncoimgMessageInfo.m_oMessageHandle = l_oMessageHandle;

   l_oNewIncoimgMessageInfo.m_sSenderAddress = QString::fromUtf8(f_poMessageList->sGetSenderAddress().constData());
   ETG_TRACE_USR4(("vNewIncomingMessageReceived Sender Address :%s:", f_poMessageList->sGetSenderAddress().constData()));
   l_oNewIncoimgMessageInfo.m_sSenderName = QString::fromUtf8(f_poMessageList->sGetSenderName().constData());
   l_oNewIncoimgMessageInfo.m_u8MessageType = f_poMessageList->u8GetMessageType();

   // Bugfix for GMMY16-5286: [CT} Sender Name in Text Inbox view is not presented in the format
   // that the contact list was last view. Sender name is always shown as First Name - Last Name
   if (FALSE == f_poMessageList->sGetSenderAddress().isEmpty())
   {
      ETG_TRACE_USR4(("vNewIncomingMessageReceived Sender Address exists"));
      m_lNewIncoimgMessageInfoList.append(l_oNewIncoimgMessageInfo);
      QString sSenderAddress = QString::fromUtf8(f_poMessageList->sGetSenderAddress().constData());
      ETG_TRACE_USR4(("Lookup SenderAddress :%s in PhonebookMap", sSenderAddress.toUtf8().constData()));

      if(Phonebook_Detail::pGetPhonebookInstance(f_u8DeviceHandle))
      {
         Phonebook_Detail::pGetPhonebookInstance(f_u8DeviceHandle)->vSearchPhonebookMap(sSenderAddress, e8NewIncomingMsg, f_u8DeviceHandle);
      }
   }
   else if (FALSE == f_poMessageList->sGetSenderName().isEmpty())
   {
      ETG_TRACE_USR4(("vNewIncomingMessageReceived only Sender Name exists"));
      QString sName = QString::fromUtf8(f_poMessageList->sGetSenderName().constData());
      FileSystemManager::vSendNewMessageAlert(sName, "", &l_oNewIncoimgMessageInfo);
   }
   else
   {
      ETG_TRACE_USR4(("vNewIncomingMessageReceived both Sender Name and Sender Address are empty"));
      FileSystemManager::vSendNewMessageAlert("", "", &l_oNewIncoimgMessageInfo);
   }

#ifdef CONVERSATION_MESSAGES_SUPPORT
   if(MessagingMutex::messagingMutexTrylock(NULLPTR) == 0)
   {
      vGetMessagesForConversation();
   }
#endif
   if((m_MessageListfilterType == most_fi_tcl_e8_MsgMessageListFilterType::FI_EN_E8MSG_LIST_FILTER_CURRENT_MAP_SESSION) && (f_poMessageList->sGetSubject().isEmpty()))
   {
      vGetMessagesForSubject(l_oMessageHandle);
   }
}

int timeStampCompareResult(const most_fi_tcl_MsgMessageDateTime& dateTime1,
      const most_fi_tcl_MsgMessageDateTime& dateTime2)
{
   ETG_TRACE_USR4(("timeStampCompareResult Called"));
   int result;
   int first, second;

   //Start Year
   first = atoi(dateTime1.oMessageDate.sCldrYear.szValue);
   second = atoi(dateTime2.oMessageDate.sCldrYear.szValue);
   result = first - second;

   if (result)
      return result;
   //End Year

   //Start Month
   first = atoi(dateTime1.oMessageDate.sCldrMonth.szValue);
   second = atoi(dateTime2.oMessageDate.sCldrMonth.szValue);
   result = first - second;

   if (result)
      return result;
   //End Month

   //Start Day
   first = atoi(dateTime1.oMessageDate.sCldrDay.szValue);
   second = atoi(dateTime2.oMessageDate.sCldrDay.szValue);
   result = first - second;

   if (result)
      return result;
   //End Day

   //Start

   first = atoi(dateTime1.oMessageTime.sHours.szValue);
   second = atoi(dateTime2.oMessageTime.sHours.szValue);
   result = first - second;

   if (result)
      return result;
   //End

   //Start Minutes
   first = atoi(dateTime1.oMessageTime.sMinutes.szValue);
   second = atoi(dateTime2.oMessageTime.sMinutes.szValue);
   result = first - second;

   if (result)
      return result;
   //End Minutes

   //Start Sec
   first = atoi(dateTime1.oMessageTime.sSeconds.szValue);
   second = atoi(dateTime2.oMessageTime.sSeconds.szValue);
   result = first - second;

   if (result)
      return result;
   //End Sec

   return result; //result would be zero here
}

bool bCompareByTimeStamp(const most_fi_tcl_MsgMessageListSliceResultItem& item1,
      const most_fi_tcl_MsgMessageListSliceResultItem& item2)
{
   int result;

   result = timeStampCompareResult(item1.oMessageDateTime, item2.oMessageDateTime);

   if (result < 0)
      return false;
   else if (result > 0)
      return true;

   return false;
}

bool bCompareConversationByTimeStamp(const most_fi_tcl_MsgConversationListSliceResultItem& item1,
      const most_fi_tcl_MsgConversationListSliceResultItem& item2)
{
   int result;

   result = timeStampCompareResult(item1.oLastActivity, item2.oLastActivity);

   if (result < 0)
      return false;
   else if (result > 0)
      return true;

   return false;
}

bool bCompareConversationDetailByTimeStamp(const most_fi_tcl_MsgConversationDetailListItem& item1,
      const most_fi_tcl_MsgConversationDetailListItem& item2)
{
   int result;

   result = timeStampCompareResult(item1.oMessageDateTime, item2.oMessageDateTime);

   if (result < 0)
      return false;
   else if (result > 0)
      return true;

   return false;
}

tVoid FileSystemManager::vSortMessageList(tU8 u8Position)
{
   ETG_TRACE_USR4(("vSortMessageList Called"));
   FolderNode* l_poFolderNode = NULLPTR;
   l_poFolderNode = poSearchNodeByFolderName(m_sCreateMessageListInProgressFolderName);
   if (l_poFolderNode)
   {
      //Bug-Fix for GMMY15-9513 - Null pointer exception in Messaging
      if (l_poFolderNode->m_pvMessageList->size() > 1)
      {
         QVector<most_fi_tcl_MsgMessageListSliceResultItem>::iterator it;
         most_fi_tcl_MsgMessageListSliceResultItem l_oMessageListSliceResultItem;
         it = l_poFolderNode->m_pvMessageList->end();
         it--;
         l_oMessageListSliceResultItem = *it;
         l_poFolderNode->m_pvMessageList->erase(it);

         // Bug-Fix for GMMY15-1229 - Two successive New incoming messages
         // l_poFolderNode->m_pvMessageList->prepend(l_oMessageListSliceResultItem);
         l_poFolderNode->m_pvMessageList->insert(u8Position, l_oMessageListSliceResultItem);
      }
   }
}

FileSystemManager* FileSystemManager::poFileSystemManager(most_fi_tcl_MsgMessageHandle& f_roMostMessageHandle)
{
   ETG_TRACE_USR4(("poFileSystemManager Called"));
   FileSystemManager* l_poFileSystemManager;

   QMap<tU32, MessageTypeDbusMessageHandleInfo>::iterator l_it;

   l_it = m_DbusMessageHandleAndMostUpperHandleMap.find(f_roMostMessageHandle.u32MsgHandleUpper);
   if (l_it != m_DbusMessageHandleAndMostUpperHandleMap.end())
   {
      QString serviceName;

      serviceName = DbusClientInterface::getInstance().getCurrentActiveService(f_roMostMessageHandle.u8DeviceHandle, l_it.value().m_oMessageListType.enType);
      l_poFileSystemManager = DbusClientInterface::getInstance().getFileSystemManager(f_roMostMessageHandle.u8DeviceHandle, serviceName);
   }
   else
   {
      return NULLPTR;
   }

   return l_poFileSystemManager;
}

tBool FileSystemManager::bRecoverMessageStart(most_fi_tcl_MsgMessageHandle& f_roMessageHandle)
{
   ETG_TRACE_USR4(("bRecoverMessageStart Called"));

   FolderNode* l_poFolderNode;
   most_fi_tcl_MsgMessageListSliceResultItem l_oMessageListSliceResultItem;
   int l_u32Index;
   int l_u32MessageListLen;

   ETG_TRACE_USR4(("Take the message from delete folder"));

   l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_DELETED);

   if (l_poFolderNode)
   {
      l_u32MessageListLen = l_poFolderNode->m_pvMessageList->size();

      for (l_u32Index = 0; l_u32Index < l_u32MessageListLen; l_u32Index++)
      {
         if (l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle == f_roMessageHandle)
         {
            ETG_TRACE_USR4(("Message found in delete folder"));
            l_oMessageListSliceResultItem = l_poFolderNode->m_pvMessageList->at(l_u32Index);

            l_poFolderNode->m_pvMessageList->remove(l_u32Index);
            break;
         }
      }

      // Send the list change for delete folder
      vMessageListChangeNotify((tU16) l_poFolderNode->m_u32ListHandle,
            static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()),
            most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_REMOVED,
            static_cast<unsigned int>(l_u32Index));
   }

   l_poFolderNode = poSearchNodeByListHandle(f_roMessageHandle.u32MsgHandleLower);

   if (l_poFolderNode)
   {
      l_poFolderNode->m_pvMessageList->push_back(l_oMessageListSliceResultItem);

      std::sort(l_poFolderNode->m_pvMessageList->begin(), l_poFolderNode->m_pvMessageList->end(), bCompareByTimeStamp);

      l_u32MessageListLen = l_poFolderNode->m_pvMessageList->size();

      for (l_u32Index = 0; l_u32Index < l_u32MessageListLen; l_u32Index++)
      {
         if (l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle == f_roMessageHandle)
         {
            ETG_TRACE_USR2(("Message found in folder"));
            break;
         }
      }

      vMessageListChangeNotify((tU16) l_poFolderNode->m_u32ListHandle, static_cast<unsigned int>(l_u32MessageListLen),
            most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_ADDED, static_cast<unsigned int>(l_u32Index));
   }

   return true;
}

/* Fix for GMMY15-10748, GMMY15-10758 and GMMY15-10756 */
tVoid FileSystemManager::vSendNewMessageAlert(QString f_sSenderFirstName, QString f_sSenderLastName,
      NewIncomingMessageInfo* f_poNewIncoimgMessageInfo)
{
   ETG_TRACE_USR4(("vSendNewMessageAlert Entered"));
   most_fi_tcl_String l_sDynamicText1, l_sDynamicText2;
   QString l_sSenderName;
   NewIncomingMessageInfo l_oNewIncomingMessageInfo;

   // Fix for GMMY15-10748, GMMY15-10758 and GMMY15-10756
   if (f_poNewIncoimgMessageInfo)
   {
      ETG_TRACE_USR4(("vSendNewMessageAlert f_poNewIncoimgMessageInfo exists"));
      l_oNewIncomingMessageInfo = *f_poNewIncoimgMessageInfo;
   }
   else
   {
      if (m_lNewIncoimgMessageInfoList.isEmpty())
      {
         return; // Should not come here
      }

      l_oNewIncomingMessageInfo = m_lNewIncoimgMessageInfoList.front();
      m_lNewIncoimgMessageInfoList.pop_front();
   }

   // BugFix for GMNGA-55019 - HMI does not display Phone number in Text Alert for New
   // Message from unknown contacts. When Phone Book could not resolve the Number with a
   // contact name, send the senderAddress to the AlertManager

   if (f_sSenderFirstName.isEmpty() && f_sSenderLastName.isEmpty())
   {
      // Bugfix for GMMY16-5286: [CT} Sender Name in Text Inbox view is not presented in the format
      // that the contact list was last view. Sender name is always shown as First Name - Last Name
      if (!l_oNewIncomingMessageInfo.m_sSenderName.isEmpty())
      {
         l_sSenderName = l_oNewIncomingMessageInfo.m_sSenderName;
      }
      else
      {
         l_sSenderName = l_oNewIncomingMessageInfo.m_sSenderAddress;
      }
   }
   else
   {
      //MY16-11101 Get Preferred Phonebook sort order
      enPreferredPhonebookSortOrder ePreferredPhonebookSortOrder =
            fc_messaging_tclApp::poGetInstance()->m_poClientHandlerPhonebook->enGetPreferredPhonebookSortOrder();
      if (e8PreferredSortOrderLastNameFirstName == ePreferredPhonebookSortOrder)
      {
         ETG_TRACE_USR4(("e8PreferredSortOrderLastNameFirstName"));
         if (f_sSenderLastName.isEmpty())
            l_sSenderName = f_sSenderFirstName;
         else
            l_sSenderName = f_sSenderLastName + " " + f_sSenderFirstName;
      }
      else
      {
         if (e8PreferredSortOrderInvalid == ePreferredPhonebookSortOrder)
         {
            ETG_TRACE_USR4(("invalid phonebook sort order: so use default sort order"));
         }
         if (f_sSenderFirstName.isEmpty())
            l_sSenderName = f_sSenderLastName;
         else
            l_sSenderName = f_sSenderFirstName + " " + f_sSenderLastName;
      }
   }

   l_sDynamicText1.bSet(l_sSenderName.toUtf8().constData());

   // Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   FileSystemManager* l_poFileSystemManager;
   QString serviceName;

   tU8 deviceHandle = l_oNewIncomingMessageInfo.m_oMessageHandle.u8DeviceHandle;
   serviceName = DbusClientInterface::getInstance().getCurrentActiveService(deviceHandle);

   l_poFileSystemManager = DbusClientInterface::getInstance().getFileSystemManager(deviceHandle, serviceName);

   if (l_poFileSystemManager)
   {
      l_poFileSystemManager->vSendNewMessageListChange();
   }
}

//Bugfix for GMMY15-5992 Large empty gap is present in text messages list
//This function will support max two consecutive messages only.If it is beyond that, like 3 or
//more consecutive messages, then it will fail to update contact information.
void FileSystemManager::vSendNewMessageListChange()
{
   ETG_TRACE_USR4(("vSendNewMessageListChange Entered"));
   FolderNode* l_poFolderNode;
   l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);

   if (l_poFolderNode)
   {
      //Sending the messageListChange for multiple messages with regard to the Phonebook contact update is redundant as
      //the HMI calls the RequestSliceMessageList in common after receiving the ITEMS_CHANGED update and not pertaining
      //to a particular message.
      //Extract deviceHandle from ListHandle
      tU8 deviceHandle = static_cast<tU8>(((l_poFolderNode->m_u32ListHandle & 0x00000F00) >> 8));
      ETG_TRACE_USR4(("vSendNewMessageListChange: DeviceHandle = %d", deviceHandle));

      //Bugfix for GMMY15-5992 Large empty gap is present in text messages list
      if(Phonebook_Detail::pGetPhonebookInstance(deviceHandle))
      {
         Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vUpdateNewMsgData(l_poFolderNode);
      }

      vMessageListChangeNotify((tU16) l_poFolderNode->m_u32ListHandle,
                     static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()),
                     most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,0);

      FolderNode* l_poConvFolderNode;
      l_poConvFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);

      if (l_poConvFolderNode)
      {
         if(Phonebook_Detail::pGetPhonebookInstance(deviceHandle))
         {
            Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vUpdateConversationListData(l_poConvFolderNode);
         }

         vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
               static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED, 0);
      }
   }
}
//gmmy15_8172 : Text message remains in inbox when deleted from phone
tU32 FileSystemManager::u32ConvertDbusHandleToUpperHandle(QString f_sDbusMessageHandle)
{
   ETG_TRACE_USR4(("u32ConvertDbusHandleToUpperHandle Called"));
   tU32 l_u32DbusMessageHandleKey = 0; //lint fix
   QMap<tU32, MessageTypeDbusMessageHandleInfo>::iterator l_it;
   for (l_it = m_DbusMessageHandleAndMostUpperHandleMap.begin();
         l_it != m_DbusMessageHandleAndMostUpperHandleMap.end(); ++l_it)
   {
      if (l_it.value().m_sDbusMessageHandle == f_sDbusMessageHandle)
      {
         l_u32DbusMessageHandleKey = l_it.key();
         break;
      }
   }

   ETG_TRACE_USR4(("u32ConvertDbusHandleToUpperHandle : Called l_u32DbusMessageHandleKey = %d", l_u32DbusMessageHandleKey));
   return l_u32DbusMessageHandleKey;
}

tVoid FileSystemManager::vRemoveDbusMessageHandleonDeletion(tU32 l_u32UpperHandle)
{
   QMap<tU32, MessageTypeDbusMessageHandleInfo>::iterator l_it;
   l_it = m_DbusMessageHandleAndMostUpperHandleMap.find(l_u32UpperHandle);

   if(l_it != m_DbusMessageHandleAndMostUpperHandleMap.end())
   {
      m_DbusMessageHandleAndMostUpperHandleMap.erase(l_it);
   }
}

tBool FileSystemManager::bMessageDeletedFromPhoneDevice(tU32 l_u32UpperHandle, tU8 u8FolderType, tU8 u8MessageType)
{
   ETG_TRACE_USR4(("bMessageDeletedFromPhoneDevice Called"));
   //Lint fix  AI_CONNECTIVITY_15.0V18
   FolderNode* l_poFolderNode = NULLPTR;
   if (u8FolderType == most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX)
   {
      l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);
   }
   //CMG3G-1494
   else if (u8FolderType == most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT)
   {
      l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_SENT);
   }

   if (!l_poFolderNode)
   {
      return FALSE;
   }

   int l_u32Index;
   int l_u32ListLength;

   l_u32ListLength = l_poFolderNode->m_pvMessageList->size();

   for (l_u32Index = 0; l_u32Index < l_u32ListLength; l_u32Index++)
   {
      if (l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u32MsgHandleUpper == l_u32UpperHandle)
      {
         // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
         vMessageNotify(l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle, u8MessageType, (tU8)most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_MSG_DELETED);

         //Delete from Conversation List
         vDeleteMessageFromConversationList(l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle);

         //Delete from Message List
         l_poFolderNode->m_pvMessageList->remove(l_u32Index);

         vMessageListChangeNotify(static_cast<tU16>(l_poFolderNode->m_u32ListHandle),
               static_cast<tU32>(l_poFolderNode->m_pvMessageList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_REMOVED,
               static_cast<tU32>(l_u32Index));
         break;
      }
   }
   return TRUE;
}

/* Bugfix for NCG3D-86810 */
tBool FileSystemManager::bMessageReadStatusChanged(tU32 l_u32UpperHandle, tU8 u8FolderType)
{
   ETG_TRACE_USR4(("bMessageReadStatusChanged Called"));

   FolderNode* l_poFolderNode = NULLPTR;
   if (u8FolderType == most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX)
   {
      l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_INBOX);
   }
   else if (u8FolderType == most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT)
   {
      l_poFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_SENT);
   }

   if (!l_poFolderNode)
   {
      return FALSE;
   }

   int l_u32Index;
   int l_u32ListLength;

   l_u32ListLength = l_poFolderNode->m_pvMessageList->size();

   for (l_u32Index = 0; l_u32Index < l_u32ListLength; l_u32Index++)
   {
      if (l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle.u32MsgHandleUpper == l_u32UpperHandle)
      {
         (*l_poFolderNode->m_pvMessageList)[l_u32Index].bReadStatusFlag = true;

         vMessageListChangeNotify(static_cast<tU16>(l_poFolderNode->m_u32ListHandle),
               static_cast<tU32>(l_poFolderNode->m_pvMessageList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,
               static_cast<tU32>(l_u32Index));


         FolderNode* l_poConvFolderNode;
         l_poConvFolderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);

         if(l_poConvFolderNode)
         {
            //send ReadStatusChange update for Conversation
            vUpdateReadStatusFlagInConversationDetailList(l_poFolderNode->m_pvMessageList->at(l_u32Index).oMessageHandle, true);

            vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
                  static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
                  most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED,
                  0); //TODO index needs to be updated
         }
         break;
      }
   }
   return TRUE;
}

tVoid FileSystemManager::vResetNewMsgHandleListAndFolderHandle()
{
   ETG_TRACE_USR4(("vResetNewMsgHandleListAndFolderHandle Called"));
   m_lNewIncoimgMessageInfoList.clear();
   m_su32FolderHandle = 0;
}

/* Bugfix for GMMY15-11135 */
e8GetMessageCaller FileSystemManager::e8CurrentGetMessageCaller()
{
   ETG_TRACE_USR4(("e8CurrentGetMessageCaller Called"));
   return m_eGetMessageCaller;
}

tVoid FileSystemManager::vSetGetMessageFailure(tBool bGetMsgFailure)
{
   ETG_TRACE_USR4(("vSetGetMessageFailure Called"));
   m_bGetMsgFailure = bGetMsgFailure;
}

/* Bugfix for GMMY16-18639, GMMY16-19799: FirstName, LastName returned should
 * not be a phone number and PhoneNumber returned should always be valid */
tCString FileSystemManager::sGetName(most_fi_tcl_String sName)
{
   ETG_TRACE_USR4(("FileSystemManager::sGetName received :%s:", sName.szValue));

   QString sTempName = QString::fromUtf8(sName.szValue);

   //Check if at least two digits are present
   QRegExp rxDigit("[0-9]");
   tU8 u8Count = static_cast<tU8>(sTempName.count(rxDigit));

   if (u8Count >= 2)
   {
      //Check if any invalid characters for phone number are/is present
      QRegExp rxInvalidCharacters("[^ ()-/\\\\*#+ABCD,TP!W@;pw0-9]");
      u8Count = static_cast<tU8>(sTempName.count(rxInvalidCharacters));
      ETG_TRACE_USR4(("sGetName u8Count: %d", u8Count));

      if (u8Count == 0)
      {
         //Name received is a phone number, clear and send empty values
         sTempName.clear();
         QByteArray baSender = sTempName.toUtf8();
         ETG_TRACE_USR4(("sGetName sending :%s:", baSender.data()));
         return baSender.constData();
      }
   }

   //Not a phone number, return the same
   ETG_TRACE_USR4(("sGetName sending :%s:", sName.szValue));
   return (tCString) sName.szValue;
}
//CMG3G-1494
most_fi_tcl_e8_MsgMessageListType::tenType FileSystemManager::enGetCurrentMessageListType()
{
   return FileSystemManager::enCurrentMessageListType;
}

// CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging

tVoid FileSystemManager::vMessageNotify(most_fi_tcl_MsgMessageHandle f_oMessageHandle,
                                        tU8 f_u8MsgType,
                                        tU8 f_u8MsgNotificationType)
{
   ETG_TRACE_USR4(("FileSystemManager::vMessageNotify - called"));
   trFC_Msg_Notification rFC_Msg_Notification;
   tU8 u8MessgeType = 0;
   
   if(f_u8MsgType == MSG_DBUS_MESSAGE_TYPE_EMAIL)
   {
        u8MessgeType = most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_EMAIL;
   }
   else if(f_u8MsgType == MSG_DBUS_MESSAGE_TYPE_MMS)
   {
        u8MessgeType = most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_MMS;
   }
   else
   {
        u8MessgeType = most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_SMS;
   }
   
   if(f_u8MsgNotificationType == 0xFF)
   {
       ETG_TRACE_USR4(("FileSystemManager::vMessageNotify: f_u8MsgNotificationType is incorrect"));
       return;
   }
   
   rFC_Msg_Notification.u8MessgeType = u8MessgeType;
   rFC_Msg_Notification.u8MessgeNotificationType = f_u8MsgNotificationType;
   rFC_Msg_Notification.u8DeviceHandle = f_oMessageHandle.u8DeviceHandle;
   rFC_Msg_Notification.u32MsgHandleUpper = f_oMessageHandle.u32MsgHandleUpper;
   rFC_Msg_Notification.u32MsgHandleLower = f_oMessageHandle.u32MsgHandleLower;
   rFC_Msg_Notification.rMapNoitfyData.pacMessageHandle  = NULLPTR;
   
   fc_messaging_tclService_Messaging::m_poMessagingService->vMsgNotificationstatus(&rFC_Msg_Notification);
}
