/*
 * FC_Messaging_FileSystem.cpp
 *
 *  Created on: Dec 14, 2011
 *      Author: rakesh
 */
//append


#include "FC_Messaging_FileSystem.h"
#include "../FC_Messaging_service_Messaging.h"
#include "../FC_Messaging_main.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_FILESYSTEM
#include "trcGenProj/Header/FC_Messaging_FileSystem.cpp.trc.h"
#endif


tU32 FileSystem::m_su32FolderHandle;

FileSystem::FileSystem()
{
   ETG_TRACE_USR4(("FileSystem : Called"));
}

tU32 FileSystem::u32GenerateUniqueFolderHandle(tU32 deviceHandle)
{
   ETG_TRACE_USR4(("FileSystem::u32GenerateUniqueFolderHandle() deviceHandle: %d", deviceHandle));

   m_su32FolderHandle &=0x000000FF;
   m_su32FolderHandle++;
   m_su32FolderHandle |= deviceHandle;

   ETG_TRACE_USR4(("FileSystem::u32GenerateUniqueFolderHandle() m_su32FolderHandle: %d", m_su32FolderHandle));
   return m_su32FolderHandle;
}

FolderNode* FileSystem::poSearchNodeByFolderName(QString f_sFolderName)
{
   ETG_TRACE_USR4(("FileSystem::poSearchNodeByFolderName : Called"));

   DirectoryStructure::iterator l_it;

   for (l_it = m_oDirectoryStructure.begin();
         l_it != m_oDirectoryStructure.end(); l_it++)
   {
      if (l_it.value().m_sFolderName == f_sFolderName)
      {
         ETG_TRACE_USR4(("poSearchNodeByFolderName : match found"));
         return &l_it.value();
      }
   }

   return NULLPTR;
}

tVoid FileSystem::vAddFolderNode(QString f_sParentFolderName, QString f_sFolderName, tU8 deviceHandle)
{
   ETG_TRACE_USR4(("FileSystem::vAddFolderNode : Called"));

   DirectoryStructure::iterator l_it;
   for (l_it = m_oDirectoryStructure.begin();
         l_it != m_oDirectoryStructure.end(); l_it++)
   {
      if ((l_it.key() == f_sParentFolderName) && (l_it.value().m_sFolderName == f_sFolderName))
      {
         ETG_TRACE_USR2(("Folder %s with the same parent folder is already there", f_sFolderName.toUtf8().constData()));
         return;
      }
   }

   FolderNode l_oFolderNode;

   l_oFolderNode.m_sFolderName = f_sFolderName;
   l_oFolderNode.m_u32FolderHandle = u32GenerateUniqueFolderHandle(static_cast<unsigned int>(deviceHandle << 8));
   l_oFolderNode.m_u32ListHandle = l_oFolderNode.m_u32FolderHandle;

   if(!QString::compare(MSG_DBUS_FOLDER_TYPE_CONVERSATION, f_sFolderName))
   {
      l_oFolderNode.m_pvConversationList = new QVector<most_fi_tcl_MsgConversationListSliceResultItem>;
   }
   else
   {
      l_oFolderNode.m_pvMessageList = new QVector<most_fi_tcl_MsgMessageListSliceResultItem>;
   }

   m_oDirectoryStructure.insert(f_sParentFolderName, l_oFolderNode);
}

FolderNode* FileSystem::poSearchNodeByListHandle(tU32 f_u32ListHandle)
{
   ETG_TRACE_USR4(("FileSystem::poSearchNodeByListHandle : Called"));

   DirectoryStructure::iterator l_it;

   for (l_it = m_oDirectoryStructure.begin();
         l_it != m_oDirectoryStructure.end(); l_it++)
   {
      if (l_it.value().m_u32ListHandle == f_u32ListHandle)
      {
         ETG_TRACE_USR4(("poSearchNodeByListHandle : match found"));
         return &l_it.value();
      }
   }
   return NULLPTR;
}

FolderNode* FileSystem::poSearchNodeByFolderHandle(tU32 f_u32FolderHandle)
{
   ETG_TRACE_USR4(("FileSystem::poSearchNodeByFolderHandle : Called"));

   DirectoryStructure::iterator l_it;

   for (l_it = m_oDirectoryStructure.begin();
         l_it != m_oDirectoryStructure.end(); l_it++)
   {
      if (l_it.value().m_u32FolderHandle == f_u32FolderHandle)
      {
         ETG_TRACE_USR4(("poSearchNodeByFolderHandle : match found"));
         return &l_it.value();
      }
   }

   return NULLPTR;
}

tVoid FileSystem::vAddMessageInList(QString f_sFolderName, most_fi_tcl_MsgMessageListSliceResultItem& f_roMessageListSliceResultItem)
{
   ETG_TRACE_USR4(("FileSystem::vAddMessageInList : Called"));

   FolderNode* l_poFolderNode;
   l_poFolderNode = poSearchNodeByFolderName(f_sFolderName);
   if (l_poFolderNode)
   {
      f_roMessageListSliceResultItem.oMessageHandle.u32MsgHandleLower = l_poFolderNode->m_u32ListHandle;

      l_poFolderNode->m_pvMessageList->push_back(f_roMessageListSliceResultItem);
   }
}

tVoid FileSystem::vAddMessageInConversationDetailList(tU32 u32ConversationID,
      most_fi_tcl_MsgMessageListSliceResultItem& oMessageListSliceResultItem,
      tU32 attachmentSize, most_fi_tcl_e8_MsgMessageStatus::tenType messageStatus,
      most_fi_tcl_e8_MsgAddressFieldType::tenType addressFieldType)
{
   ETG_TRACE_USR4(("vAddMessageInConversationDetailList() called"));

   FolderNode* folderNode = poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
   if (folderNode)
   {
      most_fi_tcl_MsgConversationDetailListItem oConversationDetailListItem;

      //Message Handle
      oConversationDetailListItem.oMessageHandle = oMessageListSliceResultItem.oMessageHandle;

      //Message Date and Time
      oConversationDetailListItem.oMessageDateTime.oMessageDate.sCldrYear.bSet(
            oMessageListSliceResultItem.oMessageDateTime.oMessageDate.sCldrYear.szValue);
      oConversationDetailListItem.oMessageDateTime.oMessageDate.sCldrMonth.bSet(
            oMessageListSliceResultItem.oMessageDateTime.oMessageDate.sCldrMonth.szValue);
      oConversationDetailListItem.oMessageDateTime.oMessageDate.sCldrDay.bSet(
            oMessageListSliceResultItem.oMessageDateTime.oMessageDate.sCldrDay.szValue);
      oConversationDetailListItem.oMessageDateTime.oMessageTime.sHours.bSet(
            oMessageListSliceResultItem.oMessageDateTime.oMessageTime.sHours.szValue);
      oConversationDetailListItem.oMessageDateTime.oMessageTime.sMinutes.bSet(
            oMessageListSliceResultItem.oMessageDateTime.oMessageTime.sMinutes.szValue);
      oConversationDetailListItem.oMessageDateTime.oMessageTime.sSeconds.bSet(
            oMessageListSliceResultItem.oMessageDateTime.oMessageTime.sSeconds.szValue);

      //Message Content
      oConversationDetailListItem.sMessageContent.bSet(oMessageListSliceResultItem.sShortMessage.szValue);

      //Attachment Size (Note: attachment feature not supported)
      oConversationDetailListItem.u32AttachmentSize = attachmentSize;

      //Message Status, Type and Read Status
      oConversationDetailListItem.e8MessageType.enType = oMessageListSliceResultItem.e8MessageType.enType;
      oConversationDetailListItem.e8MessageStatus.enType = messageStatus;
      oConversationDetailListItem.bReadStatusFlag = oMessageListSliceResultItem.bReadStatusFlag;

      //Address Field
      oConversationDetailListItem.oAddressField.e8AddressFieldType.enType = addressFieldType;
      oConversationDetailListItem.oAddressField.sFirstName.bSet(oMessageListSliceResultItem.sFirstName.szValue);
      oConversationDetailListItem.oAddressField.sLastName.bSet(oMessageListSliceResultItem.sLastName.szValue);
      oConversationDetailListItem.oAddressField.sEmailAddress.bSet(oMessageListSliceResultItem.sEmailAddress.szValue);
      oConversationDetailListItem.oAddressField.sPhoneNumber.bSet(oMessageListSliceResultItem.sPhoneNumber.szValue);

      QMap<tU32, QVector<most_fi_tcl_MsgConversationDetailListItem> >::iterator it;
      it = folderNode->m_pvConversationDetailList.find(u32ConversationID);

      if(it != folderNode->m_pvConversationDetailList.end())
      {
         //conversation is available, so adding to existing detail list
         folderNode->m_pvConversationDetailList[u32ConversationID].push_back(oConversationDetailListItem);
      }
      else
      {
         //conversation is not available, so creating new detail list
         QVector<most_fi_tcl_MsgConversationDetailListItem> oItem;
         oItem.push_back(oConversationDetailListItem);
         folderNode->m_pvConversationDetailList.insert(u32ConversationID, oItem);
      }
   }
}

FileSystem::~FileSystem()
{
   ETG_TRACE_USR4(("~FileSystem : Called"));

   DirectoryStructure::iterator l_it;

   for (l_it = m_oDirectoryStructure.begin();
         l_it != m_oDirectoryStructure.end(); l_it++)
   {
      delete l_it.value().m_pvMessageList;

      if(l_it.value().m_pvConversationList)
      {
         delete l_it.value().m_pvConversationList;
      }

      l_it.value().m_pvConversationDetailList.clear();
   }

   m_oDirectoryStructure.clear();
}
