#ifndef FC_MESSAGING_PHONEBOOK_H
#define FC_MESSAGING_PHONEBOOK_H

#include "FC_Messaging_Debug.h"
//Bugfix for GMMY15-5992 Large empty gap is present in text messages list
#include "FileSystemManager/FC_Messaging_FileSystemManager.h"

struct ContactInfo
{
   QString m_sFirstName;
   QString m_sLastName;
   tU32    m_u32ContactHandle;

   ContactInfo()
   {
      m_sFirstName = "";
      m_sLastName = "";
      m_u32ContactHandle = 0;
   }
};

enum e8SearchPhonebookCaller
{
   e8CreateMsgList,
   e8NewIncomingMsg,
   e8NewSendMsg,
   e8SearchAfterPBdownload
};

enum e8PbDownloadStatus
{
    e8DownloadNotStarted,
    e8DownloadComplete
};

class Phonebook_Detail
{
private:
   static Phonebook_Detail* m_poPhonebook[MAXIMUM_DEVICE_SUPPORT];

   //Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   //Bugfix for GMMY15-9649 Exception in "messaging.out"
   QMap<QString,ContactInfo> m_oPBSearchResultMap;
   QMap<QString,tU16> m_oMsgListMap;
   QMap<QString,tU16> m_oNewMsgMap;
   static tU16 m_u16CmdCounter;
   e8PbDownloadStatus m_e8DownloadStatus;

   //Create a singleton, so make these function private
   Phonebook_Detail();
   ~Phonebook_Detail();
   Phonebook_Detail(const Phonebook_Detail&);

   //Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   void vUpdateMsgListContacts(tU8 deviceHandle);
   void vUpdateMsgListData(FileSystemManager* l_poFileSystemManager);
   FileSystemManager* poGetFileSystemManager(tU8 deviceHandle);

public:
   static Phonebook_Detail* pGetPhonebookInstance(tU8 deviceHandle);
   static void vDestroyPhonebookInstance(tU8 deviceHandle);

   //Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   void vSearchPhonebookMap(QString f_sContactNumber,e8SearchPhonebookCaller f_oSearchPhonebookCaller, tU8 deviceHandle);
   void vUpdatePhonebookMap(tU16 f_u16CmdCounter, ContactInfo l_oContactInfo, tU8 deviceHandle);
   void vPostCreateMessageListComplete(tU8 deviceHandle);
   void vUpdateConversationListData(FolderNode* l_poConvFolderNode);
   void vUpdateNewMsgData(FolderNode* l_poFolderNode);
   void vSetDownloadState(e8PbDownloadStatus e8_DownloadState);
   e8PbDownloadStatus vGetDownloadState();
};

#endif // FC_MESSAGING_PHONEBOOK_H
