#include "FC_Messaging_phonebook.h"
#include "FC_Messaging_main.h"
#include "FC_Messaging_clienthandler_Phonebook.h"
#include "FC_Messaging_service_Messaging.h"
#include "DbusClient/FC_Messaging_Datatype.h"
#include "DbusClient/FC_Messaging_DbusClientInterface.h"
#include "FileSystemManager/FC_Messaging_FileSystem.h"

//Bugfix for GMMY15-5992 Large empty gap is present in text messages list
//#include "FC_Messaging_EOLSupport.h"

#define NEW_MSG_UPDATE_COUNT 5
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_phonebook.cpp.trc.h"
#endif

Phonebook_Detail* Phonebook_Detail::m_poPhonebook[MAXIMUM_DEVICE_SUPPORT];
tU16 Phonebook_Detail::m_u16CmdCounter = 0;

Phonebook_Detail::Phonebook_Detail()
{
   //Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   //Bugfix for GMMY15-9649 Exception in "messaging.out"
   m_oPBSearchResultMap.clear();
   m_oMsgListMap.clear();
   m_oNewMsgMap.clear();
   m_e8DownloadStatus = e8DownloadNotStarted;
}

Phonebook_Detail::~Phonebook_Detail()
{
   //Bugfix for GMMY15-9649 Exception in "messaging.out"
   m_oPBSearchResultMap.clear();
   m_oMsgListMap.clear();
   m_oNewMsgMap.clear();
   m_e8DownloadStatus = e8DownloadNotStarted;
}

Phonebook_Detail* Phonebook_Detail::pGetPhonebookInstance(tU8 deviceHandle)
{
   if (!((deviceHandle >= MINIMUM_DEVICE_HANDLE) && (deviceHandle <= MAXIMUM_DEVICE_HANDLE)))
   {
      ETG_TRACE_USR4(("pGetPhonebookInstance: Invalid DeviceHandle"));
      return NULLPTR;
   }

   if(!m_poPhonebook[deviceHandle])
   {
      m_poPhonebook[deviceHandle] = new Phonebook_Detail;
   }

   return m_poPhonebook[deviceHandle];
}

void Phonebook_Detail::vDestroyPhonebookInstance(tU8 deviceHandle)
{
   //Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   ETG_TRACE_USR4(("Phonebook_Detail::vDestroyPhonebookInstance called"));

   if ((deviceHandle >= MINIMUM_DEVICE_HANDLE) && (deviceHandle <= MAXIMUM_DEVICE_HANDLE))
   {
      if(m_poPhonebook[deviceHandle])
      {
         ETG_TRACE_USR4(("vDestroyPhonebookInstance delete m_poPhonebook"));
         delete m_poPhonebook[deviceHandle];
         m_poPhonebook[deviceHandle] = NULLPTR;
      }
   }
   else
   {
      ETG_TRACE_USR4(("vDestroyPhonebookInstance: Invalid DeviceHandle"));
   }
}

void Phonebook_Detail::vSearchPhonebookMap(QString f_sContactNumber,e8SearchPhonebookCaller f_oSearchPhonebookCaller, tU8 deviceHandle)
{
   ETG_TRACE_USR4(("Phonebook_Detail::vSearchPhonebookMap called"));

   switch(f_oSearchPhonebookCaller)
   {
      case e8CreateMsgList:
      case e8NewSendMsg:
      {
         ETG_TRACE_USR4(("vSearchPhonebookMap e8CreateMsgList/e8NewSendMsg"));

         if(f_sContactNumber.isEmpty() == true)
         {
            ETG_TRACE_USR4(("vSearchPhonebookMap ContactNumber is empty"));
            return;
         }
         //lint fix
         //Bugfix for GMMY15-9649 Exception in "messaging.out"
         if (m_oPBSearchResultMap.contains(f_sContactNumber))
         {
            ETG_TRACE_USR4(("vSearchPhonebookMap ContactNumber exists in m_oPBSearchResultMap"));

            if(e8NewSendMsg == f_oSearchPhonebookCaller)
            {
               FileSystemManager* l_poFileSystemManager = poGetFileSystemManager(deviceHandle);
               if (l_poFileSystemManager)
               {
                  //Update contact info for all messages in sent items
                  vUpdateMsgListData(l_poFileSystemManager);
               }
            }
         }
         else if (m_oMsgListMap.contains(f_sContactNumber))
         {
            ETG_TRACE_USR4(("vSearchPhonebookMap ContactNumber exists in m_oMsgListMap"));
         }
         else if((Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vGetDownloadState()) == e8DownloadComplete)
         {
            m_u16CmdCounter++;

            //Bugfix for GMMY15-9649 Exception in "messaging.out"
            m_oMsgListMap.insert(f_sContactNumber, m_u16CmdCounter);

            ETG_TRACE_USR4(("vSearchPhonebookMap Msglist m_u16CmdCounter  %d", m_u16CmdCounter));
            ETG_TRACE_USR4(("vSearchPhonebookMap Msglist m_oMsgListMap size  %d", m_oMsgListMap.size()));

            fc_messaging_tclApp::poGetInstance()->m_poClientHandlerPhonebook->vSearchPhoneBook(
                  deviceHandle, f_sContactNumber.toUtf8().data(), m_u16CmdCounter);
         }
         else
         {
            m_u16CmdCounter++;
            m_oMsgListMap.insert(f_sContactNumber,m_u16CmdCounter);
         }
      }
         break;

      case e8NewIncomingMsg:
      {
         ETG_TRACE_USR4(("vSearchPhonebookMap e8NewIncomingMsg"));

         //Request is from new incoming message
         if(f_sContactNumber.isEmpty() == true)
         {
            ETG_TRACE_USR4(("vSearchPhonebookMap NewMsg ContactNumber is empty"));
            FileSystemManager::vSendNewMessageAlert("", "");
            return;
         }
         //Bugfix for GMMY15-9649 Exception in "messaging.out"
         if(m_oPBSearchResultMap.contains(f_sContactNumber))
         {
            //send dynamic alert and messagelistchange property update
            ETG_TRACE_USR4(("vSearchPhonebookMap NewMsg ContactNumber exists in PBSearchResultMap"));

            ContactInfo l_oContactInfo = m_oPBSearchResultMap.value(f_sContactNumber);
            FileSystemManager::vSendNewMessageAlert(l_oContactInfo.m_sFirstName, l_oContactInfo.m_sLastName);
         }
         else if(m_oNewMsgMap.contains(f_sContactNumber))
         {
            ETG_TRACE_USR4(("vSearchPhonebookMap NewMsg ContactNumber exists in NewMsgMap"));
            return;
         }
         else if((Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vGetDownloadState()) == e8DownloadComplete)
         {
            //Search ContactInfo in phonebook
            m_u16CmdCounter++;

            //Bugfix for GMMY15-9649 Exception in "messaging.out"
            m_oNewMsgMap.insert(f_sContactNumber, m_u16CmdCounter);

            ETG_TRACE_USR4(("vSearchPhonebookMap NewMsg m_u16CmdCounter  %d", m_u16CmdCounter));
            ETG_TRACE_USR4(("vSearchPhonebookMap NewMsg m_oNewMsgMap size  %d", m_oNewMsgMap.size()));

            fc_messaging_tclApp::poGetInstance()->m_poClientHandlerPhonebook->vSearchPhoneBook(
                  deviceHandle, f_sContactNumber.toUtf8().data(), m_u16CmdCounter);
         }
         else
         {
            m_u16CmdCounter++;
            m_oNewMsgMap.insert(f_sContactNumber,m_u16CmdCounter);
         }
      }
         break;

      case e8SearchAfterPBdownload:
      {
         ETG_TRACE_USR4(("vSearchPhonebookMap e8SearchAfterPBdownload"));
         if((0 == m_oMsgListMap.size()) && 0 == m_oNewMsgMap.size())
         {
            return;
         }

         QMap<QString,tU16>::iterator MsgListMapIt;
         MsgListMapIt = m_oMsgListMap.begin();
         ETG_TRACE_USR4(("vSearchPhonebookMap m_oMsgListMap size  %d", m_oMsgListMap.size()));
         while(MsgListMapIt != m_oMsgListMap.end())
         {
            fc_messaging_tclApp::poGetInstance()->m_poClientHandlerPhonebook->vSearchPhoneBook(
                  deviceHandle,MsgListMapIt.key().toUtf8().data(),MsgListMapIt.value());

            ++MsgListMapIt;
         }
         QMap<QString,tU16>::iterator NewMsgMapIt;
         NewMsgMapIt = m_oNewMsgMap.begin();
         ETG_TRACE_USR4(("vSearchPhonebookMap m_oNewMsgMap size  %d", m_oMsgListMap.size()));
         while(NewMsgMapIt != m_oNewMsgMap.end())
         {
            fc_messaging_tclApp::poGetInstance()->m_poClientHandlerPhonebook->vSearchPhoneBook(
                deviceHandle,NewMsgMapIt.key().toUtf8().data(),NewMsgMapIt.value());

            ++NewMsgMapIt;
         }
      }
         break;
   }
}

void Phonebook_Detail::vUpdatePhonebookMap(tU16 f_u16CmdCounter, ContactInfo l_oContactInfo, tU8 deviceHandle)
{
   ETG_TRACE_USR4(("Phonebook_Detail::vUpdatePhonebookMap f_u16CmdCounter %d", f_u16CmdCounter));
   ETG_TRACE_USR4(("vUpdatePhonebookMap f_sFirstName %s", l_oContactInfo.m_sFirstName.toUtf8().constData()));
   ETG_TRACE_USR4(("vUpdatePhonebookMap f_sLastName %s", l_oContactInfo.m_sLastName.toUtf8().constData()));

   // Bugfix for GMMY15-9649 Exception in "messaging.out"
   QString l_sPhoneNumber = m_oNewMsgMap.key(f_u16CmdCounter);

   if((l_sPhoneNumber.isEmpty()) == false)
   {
      ETG_TRACE_USR4(("vUpdatePhonebookMap PhoneNumber exists in NewMsgMap"));

      m_oPBSearchResultMap.insert(l_sPhoneNumber,l_oContactInfo);

      m_oNewMsgMap.remove(l_sPhoneNumber);

      FileSystemManager::vSendNewMessageAlert(l_oContactInfo.m_sFirstName, l_oContactInfo.m_sLastName);
   }
   else
   {
      // Bugfix for GMMY15-9649 Exception in "messaging.out"
      l_sPhoneNumber = m_oMsgListMap.key(f_u16CmdCounter);

      if((l_sPhoneNumber.isEmpty()) == false)
      {
         ETG_TRACE_USR4(("vUpdatePhonebookMap PhoneNumber exists in MsgListMap"));

         m_oPBSearchResultMap.insert(l_sPhoneNumber,l_oContactInfo);

         m_oMsgListMap.remove(l_sPhoneNumber);

         if(TRUE == m_oMsgListMap.isEmpty())
            vUpdateMsgListContacts(deviceHandle);
      }
      else
      {
         ETG_TRACE_ERR(("CmdCounter does not exists"));
      }
   }
}

void Phonebook_Detail::vUpdateMsgListContacts(tU8 deviceHandle)
{
   ETG_TRACE_USR4(("Phonebook_Detail::vUpdateMsgListContacts"));

   FileSystemManager* l_poFileSystemManager = poGetFileSystemManager(deviceHandle);

   if (l_poFileSystemManager)
   {
      //Update contact info for all messages in inbox
      vUpdateMsgListData(l_poFileSystemManager);

      QString l_sFolderName = l_poFileSystemManager->sGetCreateMessageListInProgressFolderName();
      FolderNode* l_poFolderNode = l_poFileSystemManager->poSearchNodeByFolderName(l_sFolderName);

      if(l_poFolderNode)
      {
         l_poFileSystemManager->vMessageListChangeNotify((tU16)l_poFolderNode->m_u32ListHandle,
               static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()),
               most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_CONTENT_CHANGED, 0);
      }
   }
   else
   {
      ETG_TRACE_USR4(("vUpdateMsgListContacts FileSystemManager is NULL"));
   }
}

void Phonebook_Detail::vPostCreateMessageListComplete(tU8 deviceHandle)
{
	ETG_TRACE_USR4(("Phonebook_Detail::vPostCreateMessageListComplete"));

	FileSystemManager* l_poFileSystemManager = poGetFileSystemManager(deviceHandle);
	if (l_poFileSystemManager)
	{
		vUpdateMsgListData(l_poFileSystemManager);
		l_poFileSystemManager->vCreateMessageListComplete();
	}
	else
	{
		ETG_TRACE_USR4(("vPostCreateMessageListComplete FileSystemManager is NULL"));
	}
}

FileSystemManager* Phonebook_Detail::poGetFileSystemManager(tU8 deviceHandle)
{
   ETG_TRACE_USR4(("Phonebook_Detail::poGetFileSystemManager"));

   //CMG3G-1494 - Changes for Email support and sent items folder
   ETG_TRACE_USR4(("Phonebook_Detail::Current message list type is %u", FileSystemManager::enGetCurrentMessageListType()));

   QString serviceName;

   serviceName = DbusClientInterface::getInstance().getCurrentActiveService(deviceHandle, FileSystemManager::enGetCurrentMessageListType());
   return DbusClientInterface::getInstance().getFileSystemManager(deviceHandle, serviceName);
}

void Phonebook_Detail::vUpdateMsgListData(FileSystemManager* l_poFileSystemManager)
{
   ETG_TRACE_USR4(("Phonebook_Detail::vUpdateMsgListData"));

   QString l_sFolderName;

   l_sFolderName = l_poFileSystemManager->sGetCreateMessageListInProgressFolderName();
   FolderNode* l_poFolderNode = l_poFileSystemManager->poSearchNodeByFolderName(l_sFolderName);

   //lint fix
   if(l_poFolderNode)
   {
      int l_u32Index;
      int l_u32MessageListSize;

      l_u32MessageListSize = l_poFolderNode->m_pvMessageList->size();

      ETG_TRACE_USR4(("Phonebook_Detail::vUpdateMsgListData m_pvMessageList->size %d", l_poFolderNode->m_pvMessageList->size()));

      QVector<most_fi_tcl_MsgMessageListSliceResultItem>::iterator l_MessageListIt = l_poFolderNode->m_pvMessageList->begin();

      QMap<QString,ContactInfo>::iterator l_PBSearchResultMapIt;
      for(l_u32Index = 0;l_u32Index < l_u32MessageListSize;l_u32Index++)
      {
         // Bugfix for GMMY15-9649 Exception in "messaging.out"
         l_PBSearchResultMapIt = m_oPBSearchResultMap.find((*l_MessageListIt).sPhoneNumber.szValue);
         if(l_PBSearchResultMapIt != m_oPBSearchResultMap.end())
         {
            //NCG3D-104125
            if(((FALSE == l_PBSearchResultMapIt.value().m_sFirstName.isEmpty()) || (FALSE == l_PBSearchResultMapIt.value().m_sLastName.isEmpty())))
            {
               (*l_MessageListIt).sFirstName.bSet(l_PBSearchResultMapIt.value().m_sFirstName.toUtf8().constData());
               (*l_MessageListIt).sLastName.bSet(l_PBSearchResultMapIt.value().m_sLastName.toUtf8().constData());
               (*l_MessageListIt).u32ContactHandle = l_PBSearchResultMapIt.value().m_u32ContactHandle;
            }
            else
            {
            	ETG_TRACE_USR4(("First Name and Last Name from PhoneBook is Empty ,Existing Sender Name is retained"));
            }
		 
         }
	     l_MessageListIt++;
      }

      //Update FirstName, LastName and ContactHandle
      FolderNode* l_poConvFolderNode = l_poFileSystemManager->poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
      if(l_poConvFolderNode)
      {
         vUpdateConversationListData(l_poConvFolderNode);
         //Implementation for RTC284278
         ETG_TRACE_USR4(("Message List Change Notify for Conversation List Contact Update"));
         l_poFileSystemManager->vMessageListChangeNotify((tU16)l_poConvFolderNode->m_u32ListHandle,
                        static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
                        most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_CONTENT_CHANGED, 0);

      }
   }
}

void Phonebook_Detail::vUpdateNewMsgData(FolderNode* l_poFolderNode)
{
	ETG_TRACE_USR4(("Phonebook_Detail::vUpdateNewMsgData"));
	//lint fix
	if(l_poFolderNode)
	{
		//Update ContactInfo for first few messages
		tU8 u8Counter;
		tU32 l_u32Index;

		if(l_poFolderNode->m_pvMessageList->size() < NEW_MSG_UPDATE_COUNT)
		{
			u8Counter = static_cast<tU8>(l_poFolderNode->m_pvMessageList->size());
		}
		else
		{
			u8Counter = NEW_MSG_UPDATE_COUNT;
		}

		QVector<most_fi_tcl_MsgMessageListSliceResultItem>::iterator l_MessageListIt =
				l_poFolderNode->m_pvMessageList->begin();

		QMap<QString,ContactInfo>::iterator l_PBSearchResultMapIt;
		for(l_u32Index = 0; l_u32Index < u8Counter; l_u32Index++)
		{
			l_PBSearchResultMapIt = m_oPBSearchResultMap.find((*l_MessageListIt).sPhoneNumber.szValue);
			if(l_PBSearchResultMapIt != m_oPBSearchResultMap.end())
			{
			   if(((FALSE == l_PBSearchResultMapIt.value().m_sFirstName.isEmpty()) || (FALSE == l_PBSearchResultMapIt.value().m_sLastName.isEmpty())))
			   {
			      (*l_MessageListIt).sFirstName.bSet(l_PBSearchResultMapIt.value().m_sFirstName.toUtf8().constData());
			      (*l_MessageListIt).sLastName.bSet(l_PBSearchResultMapIt.value().m_sLastName.toUtf8().constData());
			      (*l_MessageListIt).u32ContactHandle = l_PBSearchResultMapIt.value().m_u32ContactHandle;
			   }
			   else
			   {
			      ETG_TRACE_USR4(("First Name and Last Name from PhoneBook is Empty ,Existing Sender Name is retained"));
			   }
			}
			l_MessageListIt++;
		}
	}
	else
	{
		ETG_TRACE_USR4(("vUpdateNewMsgData FolderNode is NULL"));
	}
}

void Phonebook_Detail::vUpdateConversationListData(FolderNode* l_poConvFolderNode)
{
   ETG_TRACE_USR4(("vUpdateConversationListData() called"));

   if(l_poConvFolderNode)
   {
      QVector<most_fi_tcl_MsgConversationListSliceResultItem>::iterator oConvListIter;

      QMap<QString,ContactInfo>::iterator l_PBSearchResultMapIt;
      for(oConvListIter = l_poConvFolderNode->m_pvConversationList->begin(); oConvListIter != l_poConvFolderNode->m_pvConversationList->end(); oConvListIter++)
      {
         l_PBSearchResultMapIt = m_oPBSearchResultMap.find((*oConvListIter).oAddressField.sPhoneNumber.szValue);
         if(l_PBSearchResultMapIt != m_oPBSearchResultMap.end())
         {
            if(((FALSE == l_PBSearchResultMapIt.value().m_sFirstName.isEmpty()) || (FALSE == l_PBSearchResultMapIt.value().m_sLastName.isEmpty())))
            {
               (*oConvListIter).oAddressField.sFirstName.bSet(l_PBSearchResultMapIt.value().m_sFirstName.toUtf8().constData());
               (*oConvListIter).oAddressField.sLastName.bSet(l_PBSearchResultMapIt.value().m_sLastName.toUtf8().constData());
               (*oConvListIter).u32ContactHandle = l_PBSearchResultMapIt.value().m_u32ContactHandle;

               //Update Conversation Detail List (using ConversationID)
               QMap< tU32, QVector<most_fi_tcl_MsgConversationDetailListItem> >::iterator oConvDetailListIter;

               oConvDetailListIter = l_poConvFolderNode->m_pvConversationDetailList.find((*oConvListIter).oConversationHandle.u32ConversationID);

               if(oConvDetailListIter != l_poConvFolderNode->m_pvConversationDetailList.end())
               {
                  QVector<most_fi_tcl_MsgConversationDetailListItem>::iterator oConvDetailListItemIter;

                  //Sorting already has been done while updating MessageContent, also not required for this update
                  for(oConvDetailListItemIter = oConvDetailListIter.value().begin(); oConvDetailListItemIter != oConvDetailListIter.value().end(); oConvDetailListItemIter++)
                  {
                     //Update bReadStatusFlag field
                     oConvDetailListItemIter->oAddressField.sFirstName.bSet(l_PBSearchResultMapIt.value().m_sFirstName.toUtf8().constData());
                     oConvDetailListItemIter->oAddressField.sLastName.bSet(l_PBSearchResultMapIt.value().m_sLastName.toUtf8().constData());
                     oConvDetailListItemIter->u32ContactHandle = l_PBSearchResultMapIt.value().m_u32ContactHandle;
                  }
               }

            }
            else
            {
               ETG_TRACE_USR4(("First Name and Last Name from PhoneBook is Empty ,Existing Sender Name is retained"));
            }
         }
      }
   }
}

void Phonebook_Detail::vSetDownloadState(e8PbDownloadStatus e8_DownloadState)
{
   ETG_TRACE_USR4(("vSetDownloadState() called"));
   m_e8DownloadStatus = e8_DownloadState;
}

e8PbDownloadStatus Phonebook_Detail::vGetDownloadState()
{
   ETG_TRACE_USR4(("vGetDownloadState() called"));
   return m_e8DownloadStatus;

}

