/****************************************************************************
*******************************************************************************/

#ifndef _FC_MESSAGING_MAIN_H_
#define _FC_MESSAGING_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "FC_Messaging_Defines.h"
#include "DbusClient/FC_Messaging_Macro.h"
#include "../Configuration/Messaging/Msg_FeatureConfig.h"

#define FC_MESSAGING_UPDATEINBOX_TIMER_ID 1
#define FC_MESSAGING_MAPERRORRETRY_TIMER_ID 2
#define FC_MESSAGING_MAPCAPABILITYRETRY_TIMER_ID 3

#define FC_MESSAGING_AUDIOROUTEREQUEST_WAIT_TIMER_ID 6
#define FC_MESSAGING_AUDIOROUTEREQUEST_WAIT_TIMEOUT 20000 //20sec
#define FC_MESSAGING_OUTBOXCHECK_WAIT_TIMER_ID 20
#define FC_MESSAGING_OUTBOXCHECK_WAIT_TIMER_TIMEOUT 5000 //5sec


#define FC_MESSAGING_MNSCONNECTIONRETRY_TIMER_ID 100

#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

//Messaging build for G3G
#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
#define FC_MESSAGING_THREAD_ID                  "FC_MESSAGING_THREAD"
#define FC_MESSAGING_DEFAULT_PRIORITY           105
#define FC_MESSAGING_DEFAULT_STACK_SIZE         16384
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
enum tenTrcTraceClassFC_Messaging
{
   TR_CLASS_FC_MESSAGING_APPLICATION = TR_COMP_CONNECTIVITY + 16,    // traceclass: 0x3b10
   TR_CLASS_FC_MESSAGING_SERVICE = TR_COMP_CONNECTIVITY + 16 + 1,    // traceclass: 0x3b11
   TR_CLASS_FC_MESSAGING_SQLITE = TR_COMP_CONNECTIVITY + 16 + 2,     // traceclass: 0x3b12
   TR_CLASS_FC_MESSAGING_DBUS = TR_COMP_CONNECTIVITY + 16 + 3,       // traceclass: 0x3b13
   TR_CLASS_FC_MESSAGING_FILESYSTEM = TR_COMP_CONNECTIVITY + 16 + 4  // traceclass: 0x3b14
};

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

typedef std::map< tU8, tBool > tMap_DevHandle_SettingState;
typedef std::map< tU8, tU16 > tMap_DevHandle_MsgHandle;
typedef std::map< tU8, std::string > tMap_DevHandle_DevAddress;

class ahl_tclBaseOneThreadApp;

class fc_messaging_tclClientHandler_Phonebook;

class Messaging_DefSetHandler;

class fc_messaging_tclClientHandler_BluetoothSetings;

class fc_messaging_tclService_Messaging;

class fc_messaging_tclClientHandler_Diaglib;

class fc_messaging_tclClientHandler_Phonebook;

class fc_messaging_tclAudioRouteHandler;
class fc_messaging_tclGenericWrapper;
class fc_messaging_ClientHandler_SDS;

class fc_messaging_tclApp : public ahl_tclBaseOneThreadApp
{
public:
   fc_messaging_tclClientHandler_BluetoothSetings* GetBtSetting()
   {
      return m_poClientHandlerBluetoothSetings;
   }

   fc_messaging_tclApp(tVoid);
   virtual ~fc_messaging_tclApp(tVoid);
   static fc_messaging_tclApp* m_poMainAppInstance;
   //This is new function defined to enable/disable service of Messanging
   static tVoid fc_messaging_set_service(tBool on);

   /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_messaging_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_messaging_tclApp& operator=(const fc_messaging_tclApp &oFC_Messaging);

   /**************************************************************************
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
    * 'fc_messaging_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_messaging_tclApp(const fc_messaging_tclApp &oFC_Messaging);

   /**************************************************************************
    * Overriding ahl_tclBaseOneThreadApp methods.
    **************************************************************************/
   virtual tBool bOnInit() OVERRIDE;
   virtual tVoid vOnApplicationClose() OVERRIDE;
   virtual tVoid vOnTimer(tU16 nTimerId) OVERRIDE;
   virtual tVoid vOnLoadSettings() OVERRIDE;
   virtual tVoid vOnSaveSettings() OVERRIDE;
   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage) OVERRIDE;

//Messaging build for G3G
#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
   static fc_messaging_tclApp* theServer();
   tVoid vInitializeThread();
   static tVoid vStartMainLoop(tVoid *);
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3
   static fc_messaging_tclApp* poGetInstance();

   fc_messaging_tclAudioRouteHandler* poGetAudioRouteHandler(tVoid)
   {
      NORMAL_M_ASSERT(m_poAudioRouteHandler);
      return m_poAudioRouteHandler; //Check
   };

   fc_messaging_tclGenericWrapper* poGetGenericWrapper (tVoid)
   {
      NORMAL_M_ASSERT(m_poGenericWrapper);
      return m_poGenericWrapper;
   };

   fc_messaging_ClientHandler_SDS* poGetClientHandler_SDS (tVoid)
   {
      NORMAL_M_ASSERT(m_poClientHandler_SDS);
      return m_poClientHandler_SDS;
   };

public:

   static fc_messaging_tclClientHandler_Phonebook* m_poClientHandlerPhonebook;

   static fc_messaging_tclService_Messaging* m_poMessaging;

   fc_messaging_tclClientHandler_BluetoothSetings *m_poClientHandlerBluetoothSetings;

   static Messaging_DefSetHandler* m_poDefSet;

   static Messaging_DefSetHandler* poGetDefSetInstance();
   diaglib::tclServiceDiaglib* m_poDiaglibService;
   fc_messaging_tclClientHandler_Diaglib* m_poClientHandlerDiaglib;
   tU32 u32DoUpdateInboxTime;
   static tU16 m_UCID;

//Messaging build for G3G
#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
   OSAL_tThreadID m_hRxThreadId;
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

private:
   fc_messaging_tclAudioRouteHandler* m_poAudioRouteHandler;
   fc_messaging_tclGenericWrapper* m_poGenericWrapper;
   fc_messaging_ClientHandler_SDS* m_poClientHandler_SDS;
};

#endif//_FC_MESSAGING_MAIN_H_

