/*******************************************************************************
 *
 * FILE:          FC_Messaging_clienthandler_SDS.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA client-handler for the service TTS_SDS.
 *
 * AUTHOR:        Sandeep Arjun
 *
 * COPYRIGHT:    (c) 2014  Robert Bosch RBEI, Coimbatore
 *
 *******************************************************************************/
/******************************************************************************/
/*                                                                            */
/* Protection against multiple includes                                       */
/*                                                                            */
/******************************************************************************/
#ifndef _FC_MESSAGING_CLIENTHANDLER_SDS_H_
#define _FC_MESSAGING_CLIENTHANDLER_SDS_H_
#include "../DbusClient/FC_Messaging_Macro.h"
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class most_fi_tcl_String;

class fc_messaging_ClientHandler_SDS : public ahl_tclBaseOneThreadClientHandler
{
public:

   fc_messaging_ClientHandler_SDS(fc_messaging_tclApp* poMainAppl); // Parameterized Constructor
   virtual ~fc_messaging_ClientHandler_SDS() FINAL; // Destructor

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/

   tBool bPrepareVoiceOutput_MethodStart();
   tBool bSynthesizeSpeak_MethodStart(most_fi_tcl_String sText);
   tBool bAbortPrompt_MethodStart();

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
private:

   /***************************************************************************
    * Default Constructor, copy constructor and assignment operator are made private
    * so that instances of these files cannot be created elsewhere.
    ***************************************************************************/
   fc_messaging_ClientHandler_SDS(tVoid);
   fc_messaging_ClientHandler_SDS& operator=(const fc_messaging_ClientHandler_SDS &rfoClientHandler);
   fc_messaging_ClientHandler_SDS(const fc_messaging_ClientHandler_SDS &rfoClientHandler);

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

   tVoid vHandle_SynthesizeSpeak(amt_tclServiceData* poMessage);
   /* This is the handler function used to handle the incoming message FID
    SDS_TTSFI_C_U16_SYNTHESIZESPEAK. Based on the opcode suitable action is
    taken by the function*/

   tVoid vHandle_PrepareVoiceOutput(amt_tclServiceData* poMessage);
   /* This is the handler function used to handle the incoming message FID
    SDS_TTSFI_C_U16_PREPAREVOICEOUTPUT. Based on the opcode suitable action is
    taken by the function*/

   tVoid vHandle_AbortPrompt(amt_tclServiceData* poMessage);
   /* This is the handler function used to handle the incoming message FID
    SDS_TTSFI_C_U16_ABORTPROMPT. Based on the opcode suitable action is
    taken by the function*/

   /***************************************************************************
    * Internal handler functions which are used to handle various incoming
    * messages
    ***************************************************************************/

   /***************************************************************************
    * Class data members
    ***************************************************************************/
   fc_messaging_tclApp* m_poMainApp;

   /***************************************************************************
    * Primitive Data members
    ***************************************************************************/

   /***************************************************************************
    * User Defined DataTypes
    ***************************************************************************/

   // Message map definition macro
   DECLARE_MSG_MAP (fc_messaging_ClientHandler_SDS)
};

#endif /* _FC_MESSAGING_CLIENTHANDLER_SDS_H_ */
