/*******************************************************************************
*                                                                               
* FILE:          FC_Messaging_clienthandler_Phonebook.h             
*                                                                               
* SW-COMPONENT:  FC_Messaging application                                  
*                                                                               
* PROJECT:                                                                      
*                                                                               
* DESCRIPTION:   CCA client-handler for the service Phonebook.              
*                                                                               
* AUTHOR:        Ravi K                                                            
*                                                                               
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim                          
*                                                                               
*******************************************************************************/

#ifndef _FC_MESSAGING_CLIENTHANDLER_PHONEBOOK_H_
#define _FC_MESSAGING_CLIENTHANDLER_PHONEBOOK_H_

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

#include "FC_Messaging_Debug.h"  
#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"

//Bugfix for GMMY16-11101
enum enPreferredPhonebookSortOrder
{
   e8PreferredSortOrderFirstNameLastName = 0, e8PreferredSortOrderLastNameFirstName = 1, e8PreferredSortOrderInvalid = 2
};

class ahl_tclBaseOneThreadClientHandler;

class fc_messaging_tclClientHandler_Phonebook 
      : public ahl_tclBaseOneThreadClientHandler
{
public:

   fc_messaging_tclClientHandler_Phonebook(tVoid);
   fc_messaging_tclClientHandler_Phonebook(fc_messaging_tclApp* poMainAppl);
   virtual ~fc_messaging_tclClientHandler_Phonebook() FINAL;

   /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
    * 'fc_messaging_tclClientHandler_Phonebook' which has no
    *  assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_messaging_tclClientHandler_Phonebook& operator=
		   (const fc_messaging_tclClientHandler_Phonebook &oClientHandler);

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   //tVoid vProcessTimer(tU16 u16TimerId);

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

   // Add your CCA message handler function prototypes here.
   tVoid  vSearchPhoneBook(tU8 u8DeviceHandle,tString pstr_phonenumber, tU16 CmdCounter = 0);
   tVoid  vHandle_SearchPhoneBook_MethodError(amt_tclServiceData* poMessage);
   tVoid  vHandle_SearchPhoneBook_MethodResult(amt_tclServiceData* poMessage);

   // Bugfix for GMMY15-5992 Large empty gap is present in text messages list
   tVoid  vHandle_DownloadStateExtended(amt_tclServiceData* poMessage);

   // Bugfix for issue GMMY16-11101: [CT]Text message sender names are not
   // shown in the same format as is displayed in the contacts list
   tVoid vHandle_PreferredPhonebookSortOrder_Status(amt_tclServiceData* poMessage);
   enPreferredPhonebookSortOrder enGetPreferredPhonebookSortOrder();

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_messaging_tclClientHandler_Phonebook) 

private :
   void vStringCopy(char *dest, const char* src, tU32 dest_size);

   enPreferredPhonebookSortOrder m_enPreferredPhonebookSortOrder; //Bugfix for GMMY16-11101
   std::map<tU16, tU8> m_mapCmdCounterDeviceHandle; //Required for SearchPhonebook.MethodError
};

#endif // _FC_MESSAGING_CLIENTHANDLER_PHONEBOOK_H_

