/*******************************************************************************
*                                                                               
* FILE:          FC_Messaging_clienthandler_Phonebook.cpp           
*                                                                               
* SW-COMPONENT:  FC_Messaging application                                  
*                                                                               
* PROJECT:       Bosch                                                              
*                                                                               
* DESCRIPTION:   CCA client-handler for the service Phonebook.              
*                                                                               
* AUTHOR:        Rakesh Kumar, Omveer
*                                                                               
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim                          
*                                                                               
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "FC_Messaging_Debug.h"
#include "FC_Messaging_main.h"
#include "FC_Messaging_clienthandler_Phonebook.h"
#include "FileSystemManager/FC_Messaging_FileSystemManager.h"
#include "FC_Messaging_service_Messaging.h"
/* Bugfix for GMMY15-5992 Large empty gap is present in text messages list */
#include "FC_Messaging_phonebook.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of used service
//Include FI interface of PhoneBook Settings
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO
#include "conn_most_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_clienthandler_Phonebook.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

 // Version defines for used service


/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_messaging_tclClientHandler_Phonebook, ahl_tclBaseWork)

   // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
   // method should be called on receiving a specific message.
   ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_SEARCHPHONEBOOK, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ,vHandle_SearchPhoneBook_MethodResult)
   ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_SEARCHPHONEBOOK, AMT_C_U8_CCAMSG_OPCODE_ERROR        ,vHandle_SearchPhoneBook_MethodError )

   ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_DOWNLOADSTATEEXTENDED, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandle_DownloadStateExtended)

   // Bugfix for issue GMMY16-11101: [CT]Text message sender names are not
   // shown in the same format as is displayed in the contacts list */
   ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_PREFERREDPHONEBOOKSORTORDER, AMT_C_U8_CCAMSG_OPCODE_STATUS ,vHandle_PreferredPhonebookSortOrder_Status)

END_MSG_MAP()


/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_messaging_tclClientHandler_Phonebook::
*     fc_messaging_tclClientHandler_Phonebook(fc_messaging_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_messaging_tclClientHandler_Phonebook::
 fc_messaging_tclClientHandler_Phonebook(fc_messaging_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_FB_PHONEBOOK,
      /* MajorVersion of used Service */ MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION ,
      /* MinorVersion of used Service */ MOST_PHONBKFI_C_U16_SERVICE_MINORVERSION )
{
   ETG_TRACE_USR4(("fc_messaging_tclClientHandler_Phonebook() entered."));

   vAddAutoRegisterForProperty(MOST_PHONBKFI_C_U16_PREFERREDPHONEBOOKSORTORDER);//Bugfix for GMMY16-11101
   vAddAutoRegisterForProperty(MOST_PHONBKFI_C_U16_DOWNLOADSTATEEXTENDED);

   m_enPreferredPhonebookSortOrder = e8PreferredSortOrderInvalid; //Fix for CMG3G-5833
   m_mapCmdCounterDeviceHandle.clear();
}

/*******************************************************************************
*
* FUNCTION: fc_messaging_tclClientHandler_Phonebook::
*             ~fc_messaging_tclClientHandler_Phonebook(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_messaging_tclClientHandler_Phonebook::
  ~fc_messaging_tclClientHandler_Phonebook(tVoid)
{
   ETG_TRACE_USR4(("~fc_messaging_tclClientHandler_Phonebook() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_messaging_tclClientHandler_Phonebook::
							   vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_messaging_tclClientHandler_Phonebook::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable PHONEBOOK AVAILABLE"));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_messaging_tclClientHandler_Phonebook::
					             vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_messaging_tclClientHandler_Phonebook::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable PHONEBOOK GONE"));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_messaging_tclClientHandler_Phonebook::
						 vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
//tVoid fc_messaging_tclClientHandler_Phonebook::vProcessTimer(tU16 u16TimerId)
//{
//	 ETG_TRACE_USR4(("Called =%d",u16TimerId));
//  u16TimerId =u16TimerId; // Removed lint Warning
//  if(TRUE == bIfServiceAvailable())
//  {
//    // Create message for used service.
//  }
//}

/*******************************************************************************
 ** FUNCTION:   vHandle_DeviceList_Status(..)
*******************************************************************************/
/* DESCRIPTION:
 *   This is a handler function for DeviceList property status
 *   
 *  PARAMETERS:
 *     IN:   poMessage        : This is the received message from a client
 *  RETURNVALUE: None
 ******************************************************************************/
void fc_messaging_tclClientHandler_Phonebook::vStringCopy(char *dest, const char* src, tU32 dest_size)
{
   if (!src)
   {
      ETG_TRACE_USR4(("vStringCopy : src is NULL"));
      return;
   }

   if (strlen(src) + 1 > dest_size)
   {
      ETG_TRACE_USR4(("vStringCopy : src string greater that dest size"));

      // Truncate the string or dont't mind to copy ?
      //return;
   }

   strncpy(dest, src, dest_size-1);
   dest[dest_size-1] = '\0';
}


/*******************************************************************************
*
* FUNCTION: tVoid  vSearchPhoneBook
*
* DESCRIPTION: search name in phonebook
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid  fc_messaging_tclClientHandler_Phonebook::vSearchPhoneBook(tU8 f_u8DeviceHandle,tString f_psPhoneNumber, tU16 CmdCounter)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook:: vSearchPhoneBook Entered"));

   most_phonbkfi_tclMsgSearchPhoneBookMethodStart l_oSearchPhoneBook_MS ;

   //fill the parameters
   l_oSearchPhoneBook_MS.u8DeviceHandle = f_u8DeviceHandle ;
   l_oSearchPhoneBook_MS.sPhoneNumber.bSet(f_psPhoneNumber);

   ETG_TRACE_USR4(("PhoneNumber To Search :: %s",f_psPhoneNumber));
   ETG_TRACE_USR4(("u8DeviceHandle :: %d",f_u8DeviceHandle));

   fi_tclVisitorMessage oMSMsg(l_oSearchPhoneBook_MS, MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);

   // Here the message related header information is added and by this the
   // creation of the message is completed.
   vInitServiceData( oMSMsg,                       // ServiceDataMsg
         CmdCounter,                               // CmdCounter
         MOST_PHONBKFI_C_U16_SEARCHPHONEBOOK,      // Function ID
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART        // Opcode
   );

   if (oMSMsg.bIsValid())
   {
      ail_tenCommunicationError enResult = AIL_EN_N_NO_ERROR;

      if (bIfServiceAvailable())
      {
         // Post message
         enResult = _poMainAppl->enPostMessage(&oMSMsg, TRUE);
      }
      else
      {
         ETG_TRACE_ERR(("vSearchPhoneBook() PhoneBook service unavailable"));

         enResult = AIL_EN_N_REGISTRATION_DENIED_SERVICE_NOT_FOUND;
      }

      if (enResult != AIL_EN_N_NO_ERROR)
      {
         ETG_TRACE_ERR(("oSearchPhoneBook_MS:Error  enResult:: %d",enResult));

         if (!oMSMsg.bDelete())
         {
            ETG_TRACE_ERR(("vSearchPhoneBook() Message deletion failed."));
         }

         // We can come here e.g. if the client has changed his application
         // state to OFF in the meantime. Therefore we don't throw an assert.
         // NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
         m_mapCmdCounterDeviceHandle.insert(std::pair<tU16, tU8>(CmdCounter, f_u8DeviceHandle));
      }
   }
   else
   {
      ETG_TRACE_ERR(("vSearchPhoneBook() Invalid Send Message"));
   }

   l_oSearchPhoneBook_MS.vDestroy();
}
/*******************************************************************************
*
* FUNCTION: vHandle_SearchPhoneBook_MethodResult()
*
* DESCRIPTION: MethodResult Handler for SearchPhoneBook From phonebook
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid  fc_messaging_tclClientHandler_Phonebook::vHandle_SearchPhoneBook_MethodResult(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vHandle_SearchPhoneBook_MethodResult() Entered"));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   most_phonbkfi_tclMsgSearchPhoneBookMethodResult l_oSearchPhoneBookMethodResult_MR;

   if (oVisitorMsg.s32GetData(l_oSearchPhoneBookMethodResult_MR,
         MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR1(("ContactDetailType:: %u", ETG_ENUM(TR_CONTDETAILTYPE, l_oSearchPhoneBookMethodResult_MR.e8ContactDetailType.enType)));

      ContactInfo l_oContactInfo;
      l_oContactInfo.m_sFirstName = QString::fromUtf8(l_oSearchPhoneBookMethodResult_MR.sFirstName.szValue);
      l_oContactInfo.m_sLastName = QString::fromUtf8(l_oSearchPhoneBookMethodResult_MR.sLastName.szValue);
      l_oContactInfo.m_u32ContactHandle = l_oSearchPhoneBookMethodResult_MR.u32ContactHandle;

      // Bugfix for GMMY15-5992 Large empty gap is present in text messages list
      if(Phonebook_Detail::pGetPhonebookInstance(l_oSearchPhoneBookMethodResult_MR.u8DeviceHandle))
      {
         Phonebook_Detail::pGetPhonebookInstance(l_oSearchPhoneBookMethodResult_MR.u8DeviceHandle)->vUpdatePhonebookMap(poMessage->u16GetCmdCounter(),
               l_oContactInfo, l_oSearchPhoneBookMethodResult_MR.u8DeviceHandle);
      }
   }
   else
   {
      ETG_TRACE_ERR(( "vHandle_SearchPhoneBook_MethodResult:Error in oVisitorMsg.s32GetData"));
   }

   std::map<tU16, tU8>::iterator it = m_mapCmdCounterDeviceHandle.find(poMessage->u16GetCmdCounter());
   if (it != m_mapCmdCounterDeviceHandle.end())
   {
      m_mapCmdCounterDeviceHandle.erase(it);
   }

   l_oSearchPhoneBookMethodResult_MR.vDestroy();
}

/*******************************************************************************
*
* FUNCTION: vHandle_SearchPhoneBook_MethodError()
*
* DESCRIPTION: MethodError Handler for SearchPhoneBook From phonebook
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid  fc_messaging_tclClientHandler_Phonebook::vHandle_SearchPhoneBook_MethodError(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage ;
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vHandle_SearchPhoneBook_MethodError() Entered"));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   most_phonbkfi_tclMsgSearchPhoneBookError searchPhoneBookMethodError;

   if (oVisitorMsg.s32GetData(searchPhoneBookMethodError,
         MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
   {
      ContactInfo l_oContactInfo;
      l_oContactInfo.m_sFirstName = "";
      l_oContactInfo.m_sLastName = "";
      l_oContactInfo.m_u32ContactHandle = 0;

      // Bugfix for GMMY15-5992 Large empty gap is present in text messages list
      std::map<tU16, tU8>::iterator it = m_mapCmdCounterDeviceHandle.find(poMessage->u16GetCmdCounter());
      if (it != m_mapCmdCounterDeviceHandle.end())
      {
         if(Phonebook_Detail::pGetPhonebookInstance(it->second))
         {
            Phonebook_Detail::pGetPhonebookInstance(it->second)->vUpdatePhonebookMap(poMessage->u16GetCmdCounter(), l_oContactInfo, it->second);
         }
         m_mapCmdCounterDeviceHandle.erase(it);
      }
   }

   searchPhoneBookMethodError.vDestroy();
}



tVoid  fc_messaging_tclClientHandler_Phonebook::vHandle_DownloadStateExtended(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vHandle_DownloadStateExtended Entered"));

   if(poMessage)
   {
      fi_tclVisitorMessage oVisitorMsg(poMessage);
      most_phonbkfi_tclMsgDownloadStateExtendedStatus l_DownloadStateExtendedStatus;

      if ( oVisitorMsg.s32GetData(l_DownloadStateExtendedStatus, MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
      {

         tU8 u8DownloadStateExtendedStreamSize = (tU8)(l_DownloadStateExtendedStatus.oDownloadStateExtendedStream.oItems.size());
         for (tU8 u8Index = 0; u8Index < u8DownloadStateExtendedStreamSize; u8Index++)
         {
            tU8 deviceHandle = l_DownloadStateExtendedStatus.oDownloadStateExtendedStream.oItems[u8Index].u8DeviceHandle;
            ETG_TRACE_USR4(("vHandle_DownloadStateExtended Entered: DeviceHandle = %d", deviceHandle));
            if (Phonebook_Detail::pGetPhonebookInstance(deviceHandle))
            {
               if(((l_DownloadStateExtendedStatus.oDownloadStateExtendedStream.oItems[u8Index].e8PhoneBookDownloadState.enType == most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended::FI_EN_E8PBDS_COMPLETE) || 
                    (l_DownloadStateExtendedStatus.oDownloadStateExtendedStream.oItems[u8Index].e8PhoneBookDownloadState.enType == most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended::FI_EN_E8PBDS_LIMIT_REACHED)) &&
                       ((Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vGetDownloadState()) == e8DownloadNotStarted))
               {
                  ETG_TRACE_USR4(("vHandle_DownloadStateExtended Entered: DownloadState is PBDS_COMPLETE"));
                  //Set DownloadState for device
                  Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vSetDownloadState(e8DownloadComplete);
                  Phonebook_Detail::pGetPhonebookInstance(deviceHandle)->vSearchPhonebookMap(NULLPTR, e8SearchAfterPBdownload, deviceHandle);

               }

            }
            else
            {
               ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook:: Phonebook_Detail is NULL"));
            }

          }
       }
       l_DownloadStateExtendedStatus.vDestroy();
   }
}


/*******************************************************************************
*
* FUNCTION: vHandle_PreferredPhonebookSortOrder_Status()
*
* DESCRIPTION: Handler for PreferredPhonebookSortOrder Status update from FC_Phonebook
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************/

tVoid  fc_messaging_tclClientHandler_Phonebook::vHandle_PreferredPhonebookSortOrder_Status(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook:: vHandle_PreferredPhonebookSortOrder_Status Entered"));
   if (poMessage)
   {
      fi_tclVisitorMessage oVisitorMsg(poMessage);
      most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus oPreferredPhonebookSortOrder_Status;

      if (oVisitorMsg.s32GetData(oPreferredPhonebookSortOrder_Status, MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
      {
         switch(oPreferredPhonebookSortOrder_Status.e8PreferredPhoneBookSortOrder.enType)
         {
            case most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder::FI_EN_E8PREFERRED_SORT_ORDER_FIRSTNAME:
               m_enPreferredPhonebookSortOrder = e8PreferredSortOrderFirstNameLastName;
               break;
            case most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder::FI_EN_E8PREFERRED_SORT_ORDER_LASTNAME:
               m_enPreferredPhonebookSortOrder = e8PreferredSortOrderLastNameFirstName;
               break;

            default:
               m_enPreferredPhonebookSortOrder = e8PreferredSortOrderInvalid;
               break;
         }

         ETG_TRACE_USR4(("vHandle_PreferredPhonebookSortOrder_Status PhonebookSorderOrder: %d", m_enPreferredPhonebookSortOrder));
      }
   }
}

enPreferredPhonebookSortOrder  fc_messaging_tclClientHandler_Phonebook::enGetPreferredPhonebookSortOrder()
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook:: enGetPreferredPhonebookSortOrder Entered"));
   return m_enPreferredPhonebookSortOrder;
}
