/************************************************************************
* FILE:         FC_Messaging_clienthandler_Diaglib.h
* PROJECT:      
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Implementation of a RoutineControl listener.
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author                 | Modification
* 12.11.10  | TMS Plischke    | Inital version
*
*************************************************************************/
// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef FC_MESSAGING_CLIENTHANDLER_DIAGLIB_H
#define FC_MESSAGING_CLIENTHANDLER_DIAGLIB_H

/**
* Message are received by implementing ListenerInterfaces and registering 
* them with diagnosis library. This demo shows two ways to achieve this.
* SystemSets are handled in this class. For RoutineControl we create an
* extra classe that handles requests for two different routines.
*/
// +++ Adjust class prefix +++
class fc_messaging_tclClientHandler_Diaglib: public diaglib::tclRoutineControlListenerIF,
   public diaglib::tclDiagnosisDataListenerIF //, public tclBTSetBluetoothFeatureSupport
{
public:
   //---sbv2hi---
   static fc_messaging_tclClientHandler_Diaglib *m_poBtDiaglib;
   static fc_messaging_tclClientHandler_Diaglib* pGetInstance(tVoid);
   // tBool m_bServerAvailable;

   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_messaging_tclClientHandler_Diaglib(diaglib::tclServiceDiaglib* pDiaglibService);
   virtual ~fc_messaging_tclClientHandler_Diaglib() FINAL;

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++

   /***************************************************************************
   * RoutineControl methods
   ***************************************************************************/
   virtual tU32 vOnGetRoutineResult (
      tU32 u32RoutineId,
      diaglib::tContext MsgContext
      ) OVERRIDE;

   virtual tU32 vOnRoutineControlAbort (
      tU32 u32RoutineId,
      diaglib::tContext MsgContext
      ) OVERRIDE;

   virtual tU32 vOnRoutineControlStart (
      tU32 u32RoutineId,
      tU32 u32Bitmask,
      const diaglib::tclParameterVector& oParamVector,
      diaglib::tContext MsgContext
      ) OVERRIDE;

   virtual tU32 vOnDiagnosisDataRead (
      tU32 u32DiagDataId,
      diaglib::tContext MsgContext
      ) OVERRIDE;

   tU32 vOnDiagnosisDataWrite (
      tU32 u32DiagDataId,
      const diaglib::tclParameterVector& oParamVector,
      diaglib::tContext MsgContext
      ) OVERRIDE;

private:
   diaglib::tclServiceDiaglib* mpDiaglibService;
   fc_messaging_tclClientHandler_Diaglib();//lint !e1704 Info 1704 , eliminating lint warnings
};
#endif //FC_MESSAGING_CLIENTHANDLER_DIAGLIB_H
