/*******************************************************************************
 *
 * FILE:        	FC_Messaging_WorkQueue.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_MESSAGING_WORKQUEUE_H_
#define _FC_MESSAGING_WORKQUEUE_H_

#include "FC_Messaging_main.h"
#include "pthread.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#include "FC_Messaging_service_Messaging.h"

typedef tVoid (fc_messaging_tclService_Messaging::*MethodStart)(amt_tclServiceData* poMessage, struct Job* prJob);

struct Job
{
   MethodStart m_pfMethod;
   tU8 u8DeviceHandle;
   tU16 u16SourceAppID;
   tU16 u16RegisterID;
   tU16 u16CmdCounter;
   tU16 u16FunctionID;
   tVoid* m_pvMethodStart;
};

struct jobNode
{
   Job* prJob;
   jobNode* prNextJobNode;
};

class WorkQueue
{
public:

   static tVoid vCreateWorkQueue();
   static tVoid vDestroyWorkQueue();
   static WorkQueue* poGetWorkQueue();

   tVoid vInsertNewJob(struct Job* prJob);
   tVoid vFetchNextJob();
   tVoid vClearWorkQueue();

private:

   static WorkQueue* s_poWorkQueue;
   static QMutex s_oMutexLock;

   tU8 m_u8Size;
   jobNode* m_prHead;
   jobNode* m_prTail;


   WorkQueue();
   ~WorkQueue();

   tVoid vSendToCCAThread(Job* prJob);
};

#endif /* FC_MESSAGING_WORKQUEUE_H_ */
