/*******************************************************************************
 *
 * FILE:        	FC_Messaging_StateMachine.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"

#include "pthread.h"

#ifndef FC_MESSAGING_STATEMACHINE_H_
#define FC_MESSAGING_STATEMACHINE_H_

class MessagingMutex
{
	private:
		static MessagingMutex* poMessagingMutexObject;
		pthread_mutex_t messagingDbusMutex;
		static pthread_t WorkQueueThreadID;
	public:
		MessagingMutex();
		~MessagingMutex();

		static MessagingMutex* messagingMutexInit();
		static void messagingMutexDestroy();
        static int messagingMutexTrylock(struct Job *f_prJob);
		static int messagingMutexUnlock();
		static void *WorkQueueScheduler(void *ptr);
};

#endif /* FC_MESSAGING_STATEMACHINE_H_ */
