/**
 * @file FC_Messaging_EvoDbusClient.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */
#ifndef _FC_MESSAGING_EVO_DBUS_CLIENT_H_
#define _FC_MESSAGING_EVO_DBUS_CLIENT_H_

// work-around for Qt "signals" macro
#ifdef signals
# undef signals
# define __define_signals__
#endif

#include <gio/gio.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dbus-shared.h>
#include <../generated/FC_Messaging_DbusClient_bindings_freedesktop.h>
#include <../generated/FC_Messaging_DbusClient_bindings_client.h>
#include <../generated/FC_Messaging_DbusClient_bindings_message.h>
#include <../generated/FC_Messaging_DbusClient_bindings_message_access.h>
#include <../generated/FC_Messaging_DbusClient_bindings_transfer.h>
#include <../generated/FC_Messaging_DbusClient_bindings_object_manager.h>

#include "../ServiceAccountManager/FC_Messaging_ServiceNameAccountManager.h"
#include "FC_Messaging_DbusClientInterface.h"
#include <QString>

#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#include "conn_most_fi_if.h"

// work-around for Qt "signals" macro
#ifdef __define_signals__
# define signals protected
# undef __define_signals__
#endif

enum msgCallback
{
   UNDEFINED_CB = 0,
   LIST_FOLDER_CB = 1,
   LIST_MESSAGES_CB = 2,
   PUSH_MESSAGE_CB = 3,
   GET_MESSAGE_CB = 4,
   SET_MSG_STATUS_READ_CB = 5,
   SET_MSG_STATUS_DELETED_CB = 6,

   LAST_CB
};

enum notificationFunctionMap
{
   NOTIFICATION_FUNC_1 = 1,
   NOTIFICATION_FUNC_2 = 2
};

class EvolutionDbusClient
{
public:
   /**
    * Constructor
    */
   EvolutionDbusClient();

   /**
    * Destructor
    */
   ~EvolutionDbusClient();

   //Get capabilities

   /**
    * Create Session
    */
   tBool messagingMapCreateSession(::std::string bluetoothDeviceAddress);

   /**
    * Remove Session
    */
   void messagingMapRemoveSession();

   void doMapRetry();

   void messagingMapSessionConnected();

   void messagingMapSessionDisconnected();

   void setClientSessionPath(tString sessionPath);

   void clearClientSessionPath();

   /**
    * DBus Properties Proxy for MessageAccess Properties Changed
    */
   void createDBusPropertiesProxyForMessageAccessPropertiesChanged(std::string sessionPath);

   /**
    * DBus Properties Proxy for Transfer Properties Changed
    */
   void createDBusPropertiesProxyForTransferPropertiesChanged(std::string transferPath);

   //Chg instance

   /**
    * Notification Registry
    */
   void messagingMapNotificationRegistry();

   /**
    * Handle Message Notification
    */
   void handleNewMessageNotification(const most_msgfi_tclMsgCreateMessageListMethodStart* createMessageListMethodStart);

   /**
    * Update Inbox
    */
   tBool messagingMapUpdateInbox();

   /**
    * List Folders
    */
   tBool messagingMapListFolder(::std::string folderName);

   tVoid sendFolderListRequest(tenFC_Msg_FolderListRequestStatus folderListRequestStatus);

   /**
    * List filter fields
    */
   void messagingMapListFilterFields();

   /**
    * List Messages
    */
   tBool messagingMapListMsg(most_msgfi_tclMsgCreateMessageListMethodStart createMessageListMethodStart,
         tU16 listMaxCount = MAXIMUM_LIST_COUNT,
         e8MapListMsgCaller mapListMsgCaller = e8MapListMsgCallerCreateMessageList, tU16 listStartOffset = LIST_START_OFFSET);

   /**
    * Push Message
    */
   tBool messagingMapPushMessage(SendMessage* sendMessage);

   /**
    * Get
    */
   tBool messagingMapGet(const MessageTypeDbusMessageHandleInfo& messageTypeDbusMessageHandleInfo);

   /**
    * Set Msg Status
    */
   tBool messagingMapSetMsgStatus(::std::string messageHandle, most_fi_tcl_e8_MsgMessageListType messageListType, tU8 operation);

   /**
    * Cancel
    */
   void messagingMapCancel();

   //-------------------------------------------------
   static void setCurrentOutgoingDeviceId(tU8 deviceHandle);

   static tU8 getCurrentOutgoingDeviceId();

   static EvolutionDbusClient* getDeviceInstance(tU8 deviceHandle);

   static void messagingDeviceConnectionStatus(tU8 deviceHandle, std::string bluetoothDeviceAddress);

   static void messagingDeviceDisconnected(tU8 deviceHandle, tBool mapOnOff = false);

   static void handleDeviceDisconnection();

   static void switchMapOn();

   static void switchMapOff();

   static void vConnectDeviceToMAPSession(tU8 deviceHandle);

   static void vDisconnectDeviceFromMAPSession(tU8 deviceHandle);

   static void registerClientSignals();

   static void registerObjectManagerSignals();

   static void unregisterClientSignals();

   static void unregisterObjectManagerSignals();

   static void unrefClientProxy();

   static void unrefObjectManagerProxy();

   tBool createMessageAccessProxy();

   tBool getWaitForMapListMsgCompSignal();

   tVoid setWaitForMapListMsgCompSignal(tBool waitForMapListMsgCompSignal);

   tBool getMapNotifyStatus();

   MsgRead_t* getMsgReadObject();

   MsgListing_t* getMsgListObject();

   tVoid updateMapDeviceConnectionStatus(tU8 mapConnectionState);

   tVoid setSignatureText(::std::string signatureText);

   static void setRetryTimerRunningStatus(tBool retryTimerRunningStatus);

   static tBool getRetryTimerRunningStatus();

   tVoid vSetMapRetryCount(tU8 u8RetryCount = MAX_MAP_RETRY);

   tU8 vGetMapRetryCount();

   //-------------------------------------------------
   static GDBusConnection* _evoMsgBus; /**< GDBus connection for Evolution*/
   static OrgBluezObexClient* _proxyClient; /**< pointer for org.bluez.obex.client*/
   static OrgFreedesktopDBusObjectManager* _proxyObjectManager;

   MsgRead_t _msgReadObject;
   MsgListing_t _msgListObject;
   ServiceNameAccountManager _serviceNameAccountManager;

protected:
   /**
    * Callback & Generic functions
    */
   static void clientSessionCreatedCallback(OrgBluezObexClient *object, const gchar *arg_address, const gchar *arg_session, guchar arg_remode_instance, const gchar *arg_UUID);

   static void clientSessionRemovedCallback(OrgBluezObexClient *object, const gchar *arg_address, const gchar *arg_session, guchar arg_remode_instance, const gchar *arg_UUID);

   static void onObjectManagerInterfacesAdded(
         OrgFreedesktopDBusObjectManager *object,
         const gchar *arg_object,
         GVariant *arg_interfaces);

   static void onObjectManagerInterfacesRemoved(
            OrgFreedesktopDBusObjectManager *object,
            const gchar *arg_object,
            const gchar *const *arg_interfaces);

   static void onDBusMessageAccessPropertiesChangedCallback(OrgFreedesktopDBusProperties *object,
         const gchar *arg_interface,
         GVariant *arg_changed_properties,
         const gchar *const *arg_invalidated_properties);

   static void onDBusTransferPropertiesChangedCallback(OrgFreedesktopDBusProperties *object,
         const gchar *arg_interface,
         GVariant *arg_changed_properties,
         const gchar *const *arg_invalidated_properties);

   void getNotificationType(::std::string data, guchar& type);

   void getNotificationMsgType(::std::string data, guchar& msgType);

   void getNotificationData(::std::string data, ::std::size_t position, tString* value);

   void getNotificationFolderType(::std::string data, ::std::size_t position, most_fi_tcl_e8_MsgFolderType::tenType& folder);

   //Testing
   static void onNewMessageNotification1(OrgBluezObexMessageAccess *object, GVariant *arg_data, const gchar *arg_path);

   static void onNewMessageNotification2(OrgBluezObexMessageAccess *object, GVariant *arg_data, const gchar *arg_path);

   static void onNewMessageNotification(OrgBluezObexMessageAccess *object, GVariant *arg_data, const gchar *arg_path);

   void getSendMessageList(most_fi_tcl_e8_MsgFolderType::tenType enFolderType = most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX,
                           most_fi_tcl_e8_MsgMessageListType::tenType enMsgType = most_fi_tcl_e8_MsgMessageListType::FI_EN_E8MSG_LIST_SMS_MMS,
                           QByteArray msgHandle = NULL,
                           tU8 msgNotificationType = 0xFF);

   static void messagingMapUpdateInboxCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   void handleMapListFolderComplete(tU16 listSize);

   void handleMapListFolderData(GVariant* folderList, tU16& listSize);

   static void messagingMapListFoldersCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   static void messagingMapSetFolderForListFoldersCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   void sendListMessagesError();

   void handleListMessagesComplete(tU16 listSize);

   void handleListMessagesData(GVariant* msgList, tU16 listSize);

   static void messagingMapListMessagesCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   void sendPushMessageStatus(tU8 status);

   tBool constructbMessage(SendMessage* sendMessage);

   static void messagingMapPushMessageCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   tBool isMultipartMessage(::std::string subject, ::std::string& finalboundary);

   void parseMessageBodyContent(::std::string& subject);

   void sendGetMessageError();

   void sendGetMessageSuccess();

   static void messagingMapGetCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   void messagingMapSetMsgStatusCallback(msgCallback callback, tU8 status);

   static void messagingMapCancelCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);

   //-------------------------------------------------
   static tBool isValidDeviceHandle(tU8 deviceHandle);

   static tU8 getDeviceHandle(const OrgBluezObexMessageAccess* proxy);

   static EvolutionDbusClient* getBluetoothDeviceObject(const OrgBluezObexMessageAccess* proxy);

   static EvolutionDbusClient* getBluetoothDeviceObject(const gchar* session);

   static EvolutionDbusClient* getDeviceInstanceFromTransferPath(std::string transferPath);

   friend tBool DbusClientInterface::getMapMsgCapabilityInfo(tU8 deviceHandle, MsgCapability_t& msgCapabilityInfo);

   //-------------------------------------------------

   static tU8 _currentOutgoingDeviceId; /**< current outgoing device id*/
   static QMutex _deviceListMutex;

   tU8 _deviceHandle;
   ::std::string _currentActiveEmailService;
   ::std::string _currentActiveSMSMMSService;
   MsgCapability_t _msgCapabilityInfo;
   e8MapListMsgCaller _mapListMsgCaller;
   tU8 _filterMessageType;
   bool _mapSentMsgAlertSent;
   tU16 _msgCountDeviceInbox;
   enSearchType _inboxSearchType;
   QMutex _newMsgHandleListMutex;
   QList<QByteArray> _newMessageHandleList;
   tBool _mapNotifyStatus;
   QMap<QByteArray, tU8> _msgNotifyMap;
   QList<QByteArray> _messageHandleList;
   ::std::map<std::string, msgCallback> _currentTransfer;
   DeviceConnection_t _deviceConnection;

private:
   void unregisterMessageAccessSignals();

   void unrefMessageAccessProxy(tU8 deviceHandle);

   tVoid stopTimers();

   tVoid folderListRequestComplete();

   tVoid sendMapDeviceCapabilitiesStatus();

   tVoid resetMapDeviceCapabilities();

   tString validatePhoneNumber(tString sender, tBool isAddress);

   tString convertFromNCR(tString sString);

   tU8 getIntLength(tU32 u32Value);

   tVoid unlockDBusMutex();

   //-------------------------------------------------

   static EvolutionDbusClient* _bluetoothDeviceObject[MAXIMUM_DEVICE_SUPPORT];
   static trFC_Msg_EvoSignalHandlerId _evoSignalHandlerId;
   static ::std::map<OrgBluezObexMessageAccess*, notificationFunctionMap> _newMessageNotificationMap;
   static tBool _isNewMsgNotification1inUse;
   static tBool _isNewMsgNotification2inUse;
   static tBool _isRetryTimerRunning;

   tString                           _clientSessionPath; /**< client session path for MAP profile */
   OrgBluezObexMessageAccess*        _proxyMessageAccess; /**< pointer for org.bluez.obex.messageaccess */
   OrgFreedesktopDBusProperties*     _proxyDBusPropertiesForMessageAccess;
   OrgBluezObexMessage*              _proxySetMessage;
   OrgBluezObexMessage*              _proxyGetMessage;
   ::std::vector< ::std::string >    _listFilterFields;
   tBool                             _waitForMapListMsgCompSignal;
   trFC_Msg_MapDeviceCapabilities    _mapDeviceCapabilities;
   tenFC_Msg_FolderListRequestStatus _folderListRequestStatus;
   tULong                            ulNewMsgNotification;
   tBool                             _isDeleteMessage;
   tU8                               _retryCount;
   ::std::string                     _signatureText; //Task CMG3G-12946
   //CMG3G-8286, CMG3G-8160, CMG3G-8287- ConnectMapProfile and MapConnectionStatus
   tU8                               m_MaxMapRetryCount;
};

#endif // _FC_MESSAGING_EVO_DBUS_CLIENT_H_

/** @} */
