/*******************************************************************************
 *
 * FILE:       	FC_Messaging_DbusClient_MsgListData.cpp
 *
 * SW-COMPONENT: FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION: 	Message List API's
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "FC_Messaging_DbusClient_MsgListData.h"

/*******************************************************************************
 * FUNCTION:		MsgListing_t
 * DESCRIPTION:	Constructor of MsgListing_t class.

 * PARAMETER:
 *
 * RETURNVALUE:
 ********************************************************************************/
MsgListing_t::MsgListing_t()
{
   m_u8Type = 0;
   m_u32Size = 0;
   m_u8Text =0;
   m_u8ReceptionStatus = 0 ;
   m_u32AttachSize = 0;
   m_u8Priority = 0;
   m_u8Read = 0 ;
   m_u8Sent = 0;
   m_u8Protected = 0;
   m_u8NotifyType = 0; // lint Fix
}

/*******************************************************************************
 * FUNCTION:		~MsgListing_t
 * DESCRIPTION:	Destructor of MsgListing_t class.

 * PARAMETER:
 *
 * RETURNVALUE:
 ********************************************************************************/
MsgListing_t::~MsgListing_t()
{
}

/* Bug fix for GMMY15-73 - MMS message not displayed */
/*******************************************************************************
 * FUNCTION:		vClear
 * DESCRIPTION:	Function to clear the message list data.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vClear()
{
   m_sMessageHandle.clear();
   m_sSubject.clear();
   m_sDatetime.clear();
   m_sSenderName.clear();
   m_sSenderAddress.clear();
   m_sReplytoAddress.clear();
   m_sRecipientName.clear();
   m_sRecipientAddress.clear();
   m_u8Type = 0;
   m_u32Size = 0;
   m_u8Text = 0;
   m_u8ReceptionStatus = 0;
   m_u32AttachSize = 0;
   m_u8Priority = 0;
   m_u8Read = 0;
   m_u8Sent = 0;
   m_u8Protected = 0;
   m_u8NotifyType = 0; // lint Fix
}

/*******************************************************************************
 * FUNCTION:		vSetHandle
 * DESCRIPTION:	Function to set the message handle.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetHandle(tU8* f_pu8Handle, tU8 f_u8HandleLen)
{
   tU8 l_u8Index;

   for (l_u8Index = 0; l_u8Index < f_u8HandleLen; l_u8Index++)
   {
      m_sMessageHandle[l_u8Index] = (char)f_pu8Handle[l_u8Index];
   }
}

/*******************************************************************************
 * FUNCTION:		vSetSubject
 * DESCRIPTION:	Function to set the message subject.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetSubject(tString f_sSubject)
{
   m_sSubject = f_sSubject;
}

/*******************************************************************************
 * FUNCTION:		vSetDateTime
 * DESCRIPTION:	Function to set the Data and time.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetDateTime(tString f_sDatetime)
{
   m_sDatetime = f_sDatetime;
}

/*******************************************************************************
 * FUNCTION:		vSetSenderName
 * DESCRIPTION:	Function to set the Name.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetSenderName(tString f_sSenderName)
{
   m_sSenderName = f_sSenderName;
}

/*******************************************************************************
 * FUNCTION:		vSetSenderAddress
 * DESCRIPTION:	Function to set the Sender address.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetSenderAddress(tString f_sSenderAddress)
{
   m_sSenderAddress = f_sSenderAddress;
}

/*******************************************************************************
 * FUNCTION:		vSetReplytoAddress
 * DESCRIPTION:	Function to set the reply to address.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetReplytoAddress(tString f_sReplytoAddress)
{
   m_sReplytoAddress = f_sReplytoAddress;
}

/*******************************************************************************
 * FUNCTION:		vSetRecipientName
 * DESCRIPTION:	Function to set the recipient Name.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetRecipientName(tString f_sRecipientName)
{
   m_sRecipientName = f_sRecipientName;
}

/*******************************************************************************
 * FUNCTION:		vSetRecipientAddress
 * DESCRIPTION:	Function to set the recipient address.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetRecipientAddress(tString f_sRecipientAddress)
{
   m_sRecipientAddress = f_sRecipientAddress;
}

/*******************************************************************************
 * FUNCTION:		vSetMsgListDataFlags
 * DESCRIPTION:	Function to set Data flags.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgListing_t::vSetMsgListDataFlags(tU8 f_u8Type, tU32 f_u32Size, tU8 f_u8Text,
                                         tU8 f_u8ReceptionStatus, tU32 f_u32AttachSize, tU8 f_u8Priority,
                                         tU8 f_u8Read, tU8 f_u8Sent, tU8 f_u8Protected, tU8 f_u8NotifyType)
{
   m_u8Type = f_u8Type;
   m_u32Size = f_u32Size;
   m_u8Text = f_u8Text;
   m_u8ReceptionStatus = f_u8ReceptionStatus;
   m_u32AttachSize = f_u32AttachSize;
   m_u8Priority = f_u8Priority;
   m_u8Read = !(f_u8Read);//NCG3D-5603 - To match the Read status of MapListMsgData with the Read status of MessageListSliceResult
   m_u8Sent = f_u8Sent;
   m_u8Protected = f_u8Protected;
   m_u8NotifyType = f_u8NotifyType; // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
}

QByteArray MsgListing_t::sGetMessageHandle()
{
   return m_sMessageHandle;
}

QByteArray MsgListing_t::sGetSubject()
{
   return m_sSubject;
}

QByteArray MsgListing_t::sGetDateTime()
{
   return m_sDatetime;
}

QByteArray MsgListing_t::sGetSenderName()
{
   return m_sSenderName;
}

QByteArray MsgListing_t::sGetSenderAddress()
{
   return m_sSenderAddress;
}

QByteArray MsgListing_t::sGetReplytoAddress()
{
   return m_sReplytoAddress;
}

QByteArray MsgListing_t::sGetRecipientName()
{
   return m_sRecipientName;
}

QByteArray MsgListing_t::sGetRecipientAddress()
{
   return m_sRecipientAddress;
}

tU8 MsgListing_t::u8GetMessageType()
{
   return m_u8Type;
}

tU32 MsgListing_t::u32GetMessageSize()
{
   return m_u32Size;
}

tU8 MsgListing_t::u8GetReceptionStatus()
{
   return m_u8ReceptionStatus;
}

tU8 MsgListing_t::u8GetReadStatus()
{
   return m_u8Read;
}

tU32 MsgListing_t::u32GetAttachSize()
{
   return m_u32AttachSize;
}

tU8 MsgListing_t::u8GetSentStatus()
{
   return m_u8Sent;
}

// CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
tU8 MsgListing_t::u8GetNotifyType()
{
   return m_u8NotifyType;
}
