/*******************************************************************************
 *
 * FILE:          FC_Messaging_Datatype.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:  Data Type used for Messaging Dbus Client
 *
 * AUTHOR:     Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _MESSAGING_DATATYPE_H_
#define _MESSAGING_DATATYPE_H_

#ifndef __PLACEMENT_NEW_INLINE
#define __PLACEMENT_NEW_INLINE 1
#endif

#include "FC_Messaging_Macro.h"
#include "glib.h"

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"
#include <qstringlist.h>
#include "qdebug.h"

// GetCapabilities
typedef struct DeviceConnection
{
   tU8 m_u8DeviceHandle;
   tBool m_bEmailSupport;
   tBool m_bSMSSupport;
   tBool m_bMMSSupport;
   tBool m_bUpdateInboxSupport;
   tBool m_bMessagingMemoryStatus;
   tU16 m_u16EmailAccountId;
} DeviceConnection_t;

// Message Sender tag
typedef struct tagSender_t
{
   tU8 ucNLen; // The length of N field of vcard
   tString pucN; // The N field of vcard
   tU8 ucFNLen; // The lenght of FN field of vard
   tString pucFN; // The FN field
   tU8 ucTELLen; // The TEL field length
   tString pucTEL; // The TEL field
   tU8 ucEMAILLen; // The length of Email field of vcard
   tString pucEMAIL; // The Email field of vcard
} Sender_t, *SenderPtr_t;

// Message Receiver tag
typedef struct tagReceiver_t
{
   tU8 ucNLen;
   tString pucN;
   tU8 ucFNLen;
   tString pucFN;
   tU8 ucTELLen;
   tString pucTEL;
   tU8 ucEMAILLen;
   tString pucEMAIL;
   tU8 ucBENVLevel;
} Receiver_t, *ReceiverPtr_t;

// Message Capability Structure. Getcapabilities return this info
typedef struct tagMsgCapability_t
{
   tU8 m_u8ServiceNum; // The number of supported services
   tU8 m_u8ActiveSMSServiceNumber;
   tU8 m_u8ActiveEMAILServiceNumber;
   struct
   {
      QString m_sServiceName;
      tU8 m_u8MsgType; // The message type
      tU16 m_u16AccountHandle;
   } astServiceInfo[MAX_INSTANCE_NUM];
} MsgCapability_t, *MsgCapabilityPtr_t;

struct AddressInfo
{
   QByteArray m_sLastName;
   QByteArray m_sFirstName;
   QByteArray m_sPhoneNumber;
   QByteArray m_sEmailAddress;
};

typedef struct MsgServiceInstanceInfo
{
   guchar* m_pu8ServiceName;
   guchar m_u8MsgType;
} MsgServiceInstanceInfo_t, *MsgServiceInstanceInfoPtr_t;

// Message attachment tag
typedef struct Attach_t
{
   tU8 ucName[256];
   tU32 ulAttachmentDataSize;
   tString pcAttachmentData;
} AttachmentList_t, *AttachmentListPtr_t;

enum e8GetMessageCaller
{
   e8ReadMessageAloud = 0,
   e8GetMessageStart = 1,
   e8NewIncomingMessage = 2,
   e8SendMessage = 3,
   e8ConversationDetail = 4,
   e8SubjectUpdate = 5
};

enum e8MapListMsgCaller
{
   e8MapListMsgCallerSendMessage,
   e8MapListMsgCallerNewIncomingMessage,
   e8MapListMsgCallerCreateMessageList,
   e8MapListMsgCallerOutboxCheck
};

enum enCreateMessageListRequest
{
   e8CreateMessageListRequestForConversationFolder = 0,
   e8CreateMessageListRequestForConversationMessage = 1,
   e8CreateMessageListRequestInvalid = 2
};

enum e8ReadMessageAloudCaller
{
   e8ReadMessageAloudMethod = 0,
   e8ReadMessageAloudExtendedMethod = 1,
   e8DeviceDisconnected = 2
};

// Two consecutive New Incoming Message Bug-Fix GMMY15-1259
enum enSearchType
{
   e8Forward = 0,
   e8Reverse = 1,
   e8SearchByHandle = 2
};

typedef struct tagSendMessageData
{
   QByteArray* pacMessageHandle;
   tU8 u8FolderType;
   tU8 u8MessageType; // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
} MapNotifySignalLoopBackData;

typedef struct tagLoopBackMessageData
{
public:
   tU32 u32FunctionId;
   tU8 u8DeviceHandle;
   tU8 ucStatus;
   tU16 u16Private;
   tVoid* vpData;
   QString sServiceName;

   tagLoopBackMessageData()
   {
      vpData = NULLPTR;
      u32FunctionId = 0;
      u8DeviceHandle = 0;
      ucStatus = 0;
      u16Private = 0;
   }
} LoopBackMessageData;

// Task CMG3G-7698: IS2201_API for device capabilities@FC_Messaging
typedef enum FC_Msg_SupportedMsgTypes
{
   FC_MSG_NO_MSG_TYPES_SUPPORTED = 0x00000000,
   FC_MSG_SMS_SUPPORT = 0x00000001,
   FC_MSG_MMS_SUPPORT = 0x00000002,
   FC_MSG_EMAIL_SUPPORT = 0x00000004
} tenFC_Msg_SupportedMsgTypes;

typedef enum FC_Msg_SupportedMapFeatures
{
   FC_MSG_NO_FEATURES_SUPPORTED = 0x00000000,
   FC_MSG_SMS_SEND_SUPPORT = 0x00000001,
   FC_MSG_MMS_SEND_SUPPORT = 0x00000002,
   FC_MSG_EMAIL_SEND_SUPPORT = 0x00000004,
   FC_MSG_ATTACHMENT_SEND_SUPPORT = 0x00000008
} tenFC_Msg_SupportedMapFeatures;

//CMG3G-8286, CMG3G-8160, CMG3G-8287- ConnectMapProfile and MapConnectionStatus
typedef enum FC_Msg_MapConnectionState
{
   FC_MSG_MAP_DISCONNECTED,
   FC_MSG_MAP_CONNECTING,
   FC_MSG_MAP_CONNECTED,
   FC_MSG_MAP_CONNECTION_FAILED
}tenFC_Msg_MapConnectionStatus;

typedef enum FC_Msg_FolderListRequestStatus
{
   FC_MSG_FOLDER_LIST_NOT_REQUESTED,
   FC_MSG_FOLDER_LIST_REQUESTED_FOR_SMSMMS_SERVICE,
   FC_MSG_FOLDER_LIST_REQUESTED_FOR_EMAIL_SERVICE
} tenFC_Msg_FolderListRequestStatus;

typedef struct FC_Msg_MapDeviceCapabilities
{
   tU8 u8DeviceHandle;
   tU16 u16SupportedMessageTypes;
   tU16 u16SupportedMapFeatures;
   struct FC_Msg_ActiveEmailAccount
   {
      tU16 u16AccountHandle;
      QString sAccountName;
   } rFC_Msg_ActiveEmailAccount;
   tU8 u8MapConnectionState;
}trFC_Msg_MapDeviceCapabilities;

//CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
typedef struct FC_Msg_Notification
{
   tU8  u8MessgeType;
   tU8  u8MessgeNotificationType;
   tU8  u8DeviceHandle;
   tU32 u32MsgHandleUpper;
   tU32 u32MsgHandleLower;
   MapNotifySignalLoopBackData rMapNoitfyData;
} trFC_Msg_Notification;

typedef struct FC_Msg_EvoSignalHandlerId
{
   tULong  ulInterfacesAdded;
   tULong  ulInterfacesRemoved;
   tULong  ulSessionCreated;
   tULong  ulSessionRemoved;
}trFC_Msg_EvoSignalHandlerId;
#endif
