/*******************************************************************************
*
* FILE:          FC_Messaging_PreDefMsg.h
*
* SW-COMPONENT:  FC_Messaging application
*
* PROJECT:       BOSCH-GM-NEXTGEN
*
* DESCRIPTION:   Provides the List of Predefined Messages 
*
* AUTHOR:        Jithin James
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/
#if !defined(FC_Messaging_PREDEFMSG_H__INCLUDED)
#define FC_Messaging_PREDEFMSG_H__INCLUDED
/*****************************************************************
| includes
|----------------------------------------------------------------*/

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
enum ePreDefMsgID {
txtTEXT_MSG_DRIVINGCANTTEXT,
txtTEXT_MSG_CALLME,
txtTEXT_MSG_ONMYWAY,
txtTEXT_MSG_RUNNINGLATE,
txtTEXT_MSG_OKAY,
txtTEXT_MSG_YES,
txtTEXT_MSG_NO,
txtTEXT_MSG_WHEREAREYOU,
txtTEXT_MSG_WHEN,
txtTEXT_MSG_END
};

enum ePreDefMsgLang  {
ENGLISH_US,
GERMAN,
ITALIAN,
SWEDISH,


FRENCH,
SPANISH_CASTILLAN,
DUTCH,
PORTUGUESE,
NORWEGIAN,
FINNISH,
DANISH,
GREEK,
JAPANESE,
ARABIC,
CHINESE_STANDARD,
POLISH,
TURKISH,
KOREAN,
TAIWANESE,
ENGLISH_UK,
HUNGARIAN,
CZECH,
SLOVAK,
RUSSIAN,
PORTUGUESE_BRAZILIAN,
THAI,
BULGARIAN,
ROMANIAN,
SLOVENIAN,
CROATIAN,
UKRAINIAN,
FRENCH_NA,
SPANISH_MEXICAN,
CANTONESE,
UZBEK,
SERBIAN,
LITHUANIAN,
ESTONIAN,
LATVIAN,
ALBANESE,
CHINESE_MANDARIN_SIMPLIFIED,
ENGLISH_AUS,
ENGLISH_JPN,
ENGLISH_PRC,
ENGLISH_CANADIAN,
ENGLISH_INDIA,
FILIPINO,
FLEMISH,
FRENCH_CANADIAN,
HEBREW,
HINDI,
INDONESIAN,
MALAY,
PERSIAN,
SPANISH_LATIN,
VIETNAMESE,
LANG_END
};
tU8 arrMsgType[txtTEXT_MSG_END] = {
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC,
most_fi_tcl_e8_MsgPredefinedMessageType::FI_EN_E8PRE_MSG_STATIC
};
tU16 u16MostLangArray[] = {
ENGLISH_US,
GERMAN,
ITALIAN,
SWEDISH,
FRENCH,
SPANISH_CASTILLAN,
DUTCH,
PORTUGUESE,
NORWEGIAN,
FINNISH,
DANISH,
GREEK,
JAPANESE,
ARABIC,
CHINESE_STANDARD,
POLISH,
TURKISH,
KOREAN,
TAIWANESE,
ENGLISH_UK,
HUNGARIAN,
CZECH,
SLOVAK,
RUSSIAN,
PORTUGUESE_BRAZILIAN,
THAI,
BULGARIAN,
ROMANIAN,
SLOVENIAN,
CROATIAN,
UKRAINIAN,
FRENCH_NA,
SPANISH_MEXICAN,
CANTONESE,
UZBEK,
SERBIAN,
LITHUANIAN,
ESTONIAN,
LATVIAN,
ALBANESE,
CHINESE_MANDARIN_SIMPLIFIED,
ENGLISH_AUS,
ENGLISH_JPN,
ENGLISH_PRC,
ENGLISH_CANADIAN,
ENGLISH_INDIA,
FILIPINO,
FLEMISH,
FRENCH_CANADIAN,
HEBREW,
HINDI,
INDONESIAN,
MALAY,
PERSIAN,
SPANISH_LATIN,
VIETNAMESE
};

const QString strlistPreDefMsg[LANG_END][txtTEXT_MSG_END] = {
{
"Driving, can't text",
"Call me",
"On my way",
"Running late",
"Okay",
"Yes",
"No",
"Where are you?",
"When?"
},

{
"Driving, Can't text [German]",
"Call me [German]",
"On my way [German]",
"Running late [German]",
"Okay [German]",
"Yes [German]",
"No [German]",
"Where are you? [German]",
"When? [German]"
},

{
"Driving, Can't text [Italian]",
"Call me [Italian]",
"On my way [Italian]",
"Running late [Italian]",
"Okay [Italian]",
"Yes [Italian]",
"No [Italian]",
"Where are you? [Italian]",
"When? [Italian]"
},

{
"Driving, Can't text [Swedish]",
"Call me [Swedish]",
"On my way [Swedish]",
"Running late [Swedish]",
"Okay [Swedish]",
"Yes [Swedish]",
"No [Swedish]",
"Where are you? [Swedish]",
"When? [Swedish]"
},

{
"Driving, Can't text [French]",
"Call me [French]",
"On my way [French]",
"Running late [French]",
"Okay [French]",
"Yes [French]",
"No [French]",
"Where are you? [French]",
"When? [French]"
},
{
"Driving, Can't text [Spanish (Castillan)]",
"Call me [Spanish (Castillan)]",
"On my way [Spanish (Castillan)]",
"Running late [Spanish (Castillan)]",
"Okay [Spanish (Castillan)]",
"Yes [Spanish (Castillan)]",
"No [Spanish (Castillan)]",
"Where are you? [Spanish (Castillan)]",
"When? [Spanish (Castillan)]"
},
{
"Driving, Can't text [Dutch]",
"Call me [Dutch]",
"On my way [Dutch]",
"Running late [Dutch]",
"Okay [Dutch]",
"Yes [Dutch]",
"No [Dutch]",
"Where are you? [Dutch]",
"When? [Dutch]"
},

{
"Driving, Can't text [Portuguese]",
"Call me [Portuguese]",
"On my way [Portuguese]",
"Running late [Portuguese]",
"Okay [Portuguese]",
"Yes [Portuguese]",
"No [Portuguese]",
"Where are you? [Portuguese]",
"When? [Portuguese]"
},

{
"Driving, Can't text [Norwegian]",
"Call me [Norwegian]",
"On my way [Norwegian]",
"Running late [Norwegian]",
"Okay [Norwegian]",
"Yes [Norwegian]",
"No [Norwegian]",
"Where are you? [Norwegian]",
"When? [Norwegian]"
},
{
"Driving, Can't text [Finnish]",
"Call me [Finnish]",
"On my way [Finnish]",
"Running late [Finnish]",
"Okay [Finnish]",
"Yes [Finnish]",
"No [Finnish]",
"Where are you? [Finnish]",
"When? [Finnish]"
},

{
"Driving, Can't text [Danish]",
"Call me [Danish]",
"On my way [Danish]",
"Running late [Danish]",
"Okay [Danish]",
"Yes [Danish]",
"No [Danish]",
"Where are you? [Danish]",
"When? [Danish]"
},

{
"Driving, Can't text [Greek]",
"Call me [Greek]",
"On my way [Greek]",
"Running late [Greek]",
"Okay [Greek]",
"Yes [Greek]",
"No [Greek]",
"Where are you? [Greek]",
"When? [Greek]"
},

{
"Driving, Can't text [Japanese]",
"Call me [Japanese]",
"On my way [Japanese]",
"Running late [Japanese]",
"Okay [Japanese]",
"Yes [Japanese]",
"No [Japanese]",
"Where are you? [Japanese]",
"When? [Japanese]"
},
{
"Driving, Can't text [Arabic]",
"Call me [Arabic]",
"On my way [Arabic]",
"Running late [Arabic]",
"Okay [Arabic]",
"Yes [Arabic]",
"No [Arabic]",
"Where are you? [Arabic]",
"When? [Arabic]"
},
{
"",
"",
"",
"",
"",
"",
"",
"",
""
},

{
"Driving, Can't text [Polish]",
"Call me [Polish]",
"On my way [Polish]",
"Running late [Polish]",
"Okay [Polish]",
"Yes [Polish]",
"No [Polish]",
"Where are you? [Polish]",
"When? [Polish]"
},

{
"Driving, Can't text [Turkish]",
"Call me [Turkish]",
"On my way [Turkish]",
"Running late [Turkish]",
"Okay [Turkish]",
"Yes [Turkish]",
"No [Turkish]",
"Where are you? [Turkish]",
"When? [Turkish]"
},

{
"Driving, Can't text [Korean]",
"Call me [Korean]",
"On my way [Korean]",
"Running late [Korean]",
"Okay [Korean]",
"Yes [Korean]",
"No [Korean]",
"Where are you? [Korean]",
"When? [Korean]"
},
{
"Driving, Can't text [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"Call me [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"On my way [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"Running late [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"Okay [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"Yes [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"No [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"Where are you? [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]",
"When? [Chinese Mandarin(Traditional Chinese character;Taiwan) =Taiwanese]"
},
{
"Driving, Can't text [English (UK)]",
"Call me [English (UK)]",
"On my way [English (UK)]",
"Running late [English (UK)]",
"Okay [English (UK)]",
"Yes [English (UK)]",
"No [English (UK)]",
"Where are you? [English (UK)]",
"When? [English (UK)]"
},

{
"Driving, Can't text [Hungarian]",
"Call me [Hungarian]",
"On my way [Hungarian]",
"Running late [Hungarian]",
"Okay [Hungarian]",
"Yes [Hungarian]",
"No [Hungarian]",
"Where are you? [Hungarian]",
"When? [Hungarian]"
},

{
"Driving, Can't text [Czech]",
"Call me [Czech]",
"On my way [Czech]",
"Running late [Czech]",
"Okay [Czech]",
"Yes [Czech]",
"No [Czech]",
"Where are you? [Czech]",
"When? [Czech]"
},

{
"Driving, Can't text [Slovakian]",
"Call me [Slovakian]",
"On my way [Slovakian]",
"Running late [Slovakian]",
"Okay [Slovakian]",
"Yes [Slovakian]",
"No [Slovakian]",
"Where are you? [Slovakian]",
"When? [Slovakian]"
},
{
"Driving, Can't text [Russian]",
"Call me [Russian]",
"On my way [Russian]",
"Running late [Russian]",
"Okay [Russian]",
"Yes [Russian]",
"No [Russian]",
"Where are you? [Russian]",
"When? [Russian]"
},
{
"Driving, Can't text [Portuguese Brazilian ]",
"Call me [Portuguese Brazilian ]",
"On my way [Portuguese Brazilian ]",
"Running late [Portuguese Brazilian ]",
"Okay [Portuguese Brazilian ]",
"Yes [Portuguese Brazilian ]",
"No [Portuguese Brazilian ]",
"Where are you? [Portuguese Brazilian ]",
"When? [Portuguese Brazilian ]"
},
{
"Driving, Can't text [Thai]",
"Call me [Thai]",
"On my way [Thai]",
"Running late [Thai]",
"Okay [Thai]",
"Yes [Thai]",
"No [Thai]",
"Where are you? [Thai]",
"When? [Thai]"
},

{
"Driving, Can't text [Bulgarian]",
"Call me [Bulgarian]",
"On my way [Bulgarian]",
"Running late [Bulgarian]",
"Okay [Bulgarian]",
"Yes [Bulgarian]",
"No [Bulgarian]",
"Where are you? [Bulgarian]",
"When? [Bulgarian]"
},
{
"Driving, Can't text [Romanian]",
"Call me [Romanian]",
"On my way [Romanian]",
"Running late [Romanian]",
"Okay [Romanian]",
"Yes [Romanian]",
"No [Romanian]",
"Where are you? [Romanian]",
"When? [Romanian]"
},
{
"Driving, Can't text [Slovenian]",
"Call me [Slovenian]",
"On my way [Slovenian]",
"Running late [Slovenian]",
"Okay [Slovenian]",
"Yes [Slovenian]",
"No [Slovenian]",
"Where are you? [Slovenian]",
"When? [Slovenian]"
},

{
"Driving, Can't text [Croatian]",
"Call me [Croatian]",
"On my way [Croatian]",
"Running late [Croatian]",
"Okay [Croatian]",
"Yes [Croatian]",
"No [Croatian]",
"Where are you? [Croatian]",
"When? [Croatian]"
},

{
"Driving, Can't text [Ukrainian]",
"Call me [Ukrainian]",
"On my way [Ukrainian]",
"Running late [Ukrainian]",
"Okay [Ukrainian]",
"Yes [Ukrainian]",
"No [Ukrainian]",
"Where are you? [Ukrainian]",
"When? [Ukrainian]"
},
{
"",
"",
"",
"",
"",
"",
"",
"",
""
},

{
"Manejando, no puedo enviar mensaje de texto",
"Llámame",
"stoy en camino",
"Estoy llegando tarde",
"Está bien",
"í",
"No",
"Where are you? [Spanish Mexican ]",
"When? [Spanish Mexican ]"
},

{
"Driving, Can't text [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"Call me [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"On my way [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"Running late [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"Okay [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"Yes [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"No [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"Where are you? [Chinese Cantonese(Traditional Chinese character;Hong-kong)]",
"When? [Chinese Cantonese(Traditional Chinese character;Hong-kong)]"
},

{
"",
"",
"",
"",
"",
"",
"",
"",
""
},

{
"Driving, Can't text [Serbian]",
"Call me [Serbian]",
"On my way [Serbian]",
"Running late [Serbian]",
"Okay [Serbian]",
"Yes [Serbian]",
"No [Serbian]",
"Where are you? [Serbian]",
"When? [Serbian]"
},

{
"Driving, Can't text [Lithuanian]",
"Call me [Lithuanian]",
"On my way [Lithuanian]",
"Running late [Lithuanian]",
"Okay [Lithuanian]",
"Yes [Lithuanian]",
"No [Lithuanian]",
"Where are you? [Lithuanian]",
"When? [Lithuanian]"
},

{
"Driving, Can't text [Estonian]",
"Call me [Estonian]",
"On my way [Estonian]",
"Running late [Estonian]",
"Okay [Estonian]",
"Yes [Estonian]",
"No [Estonian]",
"Where are you? [Estonian]",
"When? [Estonian]"
},
{
"Driving, Can't text [Latvian]",
"Call me [Latvian]",
"On my way [Latvian]",
"Running late [Latvian]",
"Okay [Latvian]",
"Yes [Latvian]",
"No [Latvian]",
"Where are you? [Latvian]",
"When? [Latvian]"
},
{
"Driving, Can't text [Albanese]",
"Call me [Albanese]",
"On my way [Albanese]",
"Running late [Albanese]",
"Okay [Albanese]",
"Yes [Albanese]",
"No [Albanese]",
"Where are you? [Albanese]",
"When? [Albanese]"
},

{
"我正在开车，将稍后回信",
"请打我电话",
"前往途中",
"要迟到了",
"好的",
"是",
"否",
"Where are you? [Chinese Mandarin(Simplified Chinese character)/Mainland]",
"When? [Chinese Mandarin(Simplified Chinese character)/Mainland]"
},
{
"Driving, Can't text [English (Australian)]",
"Call me [English (Australian)]",
"On my way [English (Australian)]",
"Running late [English (Australian)]",
"Okay [English (Australian)]",
"Yes [English (Australian)]",
"No [English (Australian)]",
"Where are you? [English (Australian)]",
"When? [English (Australian)]"
},

{
"Driving, Can't text [English (US)  for JPN]",
"Call me [English (US)  for JPN]",
"On my way [English (US)  for JPN]",
"Running late [English (US)  for JPN]",
"Okay [English (US)  for JPN]",
"Yes [English (US)  for JPN]",
"No [English (US)  for JPN]",
"Where are you? [English (US)  for JPN]",
"When? [English (US)  for JPN]"
},
{
"Driving, can't text",
"Call me",
"On my way",
"Running late",
"Okay",
"Yes",
"No",
"Where are you? [English (US)  for PRC]",
"When? [English (US)  for PRC]"
},
{
"Driving, Can't text [English Canadian]",
"Call me [English Canadian]",
"On my way [English Canadian]",
"Running late [English Canadian]",
"Okay [English Canadian]",
"Yes [English Canadian]",
"No [English Canadian]",
"Where are you? [English Canadian]",
"When? [English Canadian]"
},
{
"Driving, Can't text [English India]",
"Call me [English India]",
"On my way [English India]",
"Running late [English India]",
"Okay [English India]",
"Yes [English India]",
"No [English India]",
"Where are you? [English India]",
"When? [English India]"
},

{
"Driving, Can't text [Filipino]",
"Call me [Filipino]",
"On my way [Filipino]",
"Running late [Filipino]",
"Okay [Filipino]",
"Yes [Filipino]",
"No [Filipino]",
"Where are you? [Filipino]",
"When? [Filipino]"
},
{
"Driving, Can't text [Flemish]",
"Call me [Flemish]",
"On my way [Flemish]",
"Running late [Flemish]",
"Okay [Flemish]",
"Yes [Flemish]",
"No [Flemish]",
"Where are you? [Flemish]",
"When? [Flemish]"
},

{
"Je conduis, peux pas envoyer de message texte",
"Appelle-moi",
"Je suis en route",
"Je suis en retard",
"D'accord",
"Oui",
"Non",
"Where are you? [French Canadian ]",
"When? [French Canadian ]"
},
{
"Driving, Can't text [Hebrew]",
"Call me [Hebrew]",
"On my way [Hebrew]",
"Running late [Hebrew]",
"Okay [Hebrew]",
"Yes [Hebrew]",
"No [Hebrew]",
"Where are you? [Hebrew]",
"When? [Hebrew]"
},
{
"Driving, Can't text [Hindi]",
"Call me [Hindi]",
"On my way [Hindi]",
"Running late [Hindi]",
"Okay [Hindi]",
"Yes [Hindi]",
"No [Hindi]",
"Where are you? [Hindi]",
"When? [Hindi]"
},
{
"Driving, Can't text [Indonesian]",
"Call me [Indonesian]",
"On my way [Indonesian]",
"Running late [Indonesian]",
"Okay [Indonesian]",
"Yes [Indonesian]",
"No [Indonesian]",
"Where are you? [Indonesian]",
"When? [Indonesian]"
},
{
"Driving, Can't text [Malay]",
"Call me [Malay]",
"On my way [Malay]",
"Running late [Malay]",
"Okay [Malay]",
"Yes [Malay]",
"No [Malay]",
"Where are you? [Malay]",
"When? [Malay]"
},
{
"Driving, Can't text [Persian (Farsi / Iranian )]",
"Call me [Persian (Farsi / Iranian )]",
"On my way [Persian (Farsi / Iranian )]",
"Running late [Persian (Farsi / Iranian )]",
"Okay [Persian (Farsi / Iranian )]",
"Yes [Persian (Farsi / Iranian )]",
"No [Persian (Farsi / Iranian )]",
"Where are you? [Persian (Farsi / Iranian )]",
"When? [Persian (Farsi / Iranian )]"
},
{
"Driving, Can't text [Spanish Latin American]",
"Call me [Spanish Latin American]",
"On my way [Spanish Latin American]",
"Running late [Spanish Latin American]",
"Okay [Spanish Latin American]",
"Yes [Spanish Latin American]",
"No [Spanish Latin American]",
"Where are you? [Spanish Latin American]",
"When? [Spanish Latin American]"
},
{
"Driving, Can't text [Vietnamese]",
"Call me [Vietnamese]",
"On my way [Vietnamese]",
"Running late [Vietnamese]",
"Okay [Vietnamese]",
"Yes [Vietnamese]",
"No [Vietnamese]",
"Where are you? [Vietnamese]",
"When? [Vietnamese]"
}
};

#endif // !defined(FC_Messaging_PREDEFMSG_H__INCLUDED)

