/*******************************************************************************
 *
 * FILE:          FC_Messaging_AudioRouteHandler.cpp
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Implementation of audio routing interface
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/*******************************************************************************
 | includes:
 | 1) system- and project-includes
 | 2) needed interfaces from external components
 | 3) internal and external interfaces from this component
 |-----------------------------------------------------------------------------*/
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

#include "../FC_Messaging_main.h"
#include "../GenericWrapper/FC_Messaging_GenericWrapper.h"
#include "FC_Messaging_AudioRouteHandler.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_AudioRouteHandler.cpp.trc.h"
#endif

/*******************************************************************************
 | function implementation
 | (scope: global)
 |-----------------------------------------------------------------------------*/

/*******************************************************************************
 *
 * FUNCTION:    fc_messaging_tclAudioRouteHandler::fc_messaging_tclAudioRouteHandler
 *
 * DESCRIPTION: constructor, creates object fc_messaging_tclAudioRouteHandler
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *

 *
 *******************************************************************************/
fc_messaging_tclAudioRouteHandler::fc_messaging_tclAudioRouteHandler(fc_messaging_tclApp* poMainAppl) :
      arl_tclISource(poMainAppl)
{
   ETG_TRACE_USR1(("fc_messaging_tclAudioRouteHandler() entered"));

   m_poMainApp = poMainAppl;
}

/*******************************************************************************
 *
 * FUNCTION:    fc_messaging_tclAudioRouteHandler::~fc_messaging_tclAudioRouteHandler
 *
 * DESCRIPTION: destructor, destroys the object
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *
 *******************************************************************************/
fc_messaging_tclAudioRouteHandler::~fc_messaging_tclAudioRouteHandler()
{
   ETG_TRACE_USR1(("~fc_messaging_tclAudioRouteHandler() entered"));

   m_poMainApp = NULLPTR;
}

tVoid fc_messaging_tclAudioRouteHandler::vSetSourceAvailable(tBool bSourceAvailable)
{
   ETG_TRACE_USR1(("fc_messaging_tclAudioRouteHandler::vSetSourceAvailable"));

   vSetSrcAvailable(bSourceAvailable);
}

tVoid fc_messaging_tclAudioRouteHandler::vSetSourceAvailability(arl_tenSrcAvailability enSrcAvailability,
      arl_tenAvailabilityReason enAvailabilityReason, arl_tenSource enSource, tU16 u16SubSource)
{
   ETG_TRACE_USR1(("fc_messaging_tclAudioRouteHandler::vSetSourceAvailability"));

   if (!bSetSourceAvailability(enSrcAvailability, enAvailabilityReason, enSource, u16SubSource))
   {
      ETG_TRACE_USR1(("bSetSourceAvailability() failed"));
   }
}


/*******************************************************************************
 *
 * FUNCTION:    fc_messaging_tclAudioRouteHandler::bOnAllocate
 *
 * DESCRIPTION: Allocate request from ARL.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *              rfcoAllocRoute:         (I)   reference to Allocate route result
 *
 * RETURNVALUE: TRUE
 *
 *******************************************************************************/
tBool fc_messaging_tclAudioRouteHandler::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute)
{
   ETG_TRACE_USR1(("fc_messaging_tclAudioRouteHandler::bOnAllocate entered"));

   (tVoid) enSrcNum; //lint fix
   (tVoid) rfcoAllocRoute; //lint fix

   return TRUE;
}

/*******************************************************************************
 *
 * FUNCTION:    fc_messaging_tclAudioRouteHandler::bOnDeAllocate
 *
 * DESCRIPTION: Deallocate request from ARL.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *
 * RETURNVALUE: TRUE
 *******************************************************************************/
tBool fc_messaging_tclAudioRouteHandler::bOnDeAllocate(arl_tenSource enSrcNum)
{
   ETG_TRACE_USR1(("fc_messaging_tclAudioRouteHandler::bOnDeAllocate entered"));

   (tVoid) enSrcNum; //lint fix

   return TRUE;
}

/*******************************************************************************
 *
 * FUNCTION:    fc_messaging_tclAudioRouteHandler::bOnSrcActivity
 *
 * DESCRIPTION: Source activity request from audio routing library.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *              rfcoSrcActivity:        (I)   source activity
 *
 * RETURNVALUE: TRUE
 *
 *******************************************************************************/
tBool fc_messaging_tclAudioRouteHandler::bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
   ETG_TRACE_USR1(("fc_messaging_tclAudioRouteHandler::bOnSrcActivity entered Src No: %u Activity: %u", enSrcNum, rfcoSrcActivity.enType));

   switch (rfcoSrcActivity.enType)
   {
      case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
      {
         ETG_TRACE_USR3(("ARL_EN_ISRC_ACT_ON"));
         vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_ON);
         if(m_poMainApp && m_poMainApp->poGetGenericWrapper())
         {
            m_poMainApp->poGetGenericWrapper()->vOnSourceActivity(enSrcNum, ARL_EN_ISRC_ACT_ON);
         }
      }
      break;

      case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
      case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
      {
         ETG_TRACE_USR3(("ARL_EN_ISRC_ACT_OFF/ARL_EN_ISRC_ACT_PAUSE"));
         vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_OFF);
         //vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_PAUSE); Check this one
         if(m_poMainApp && m_poMainApp->poGetGenericWrapper())
         {
            m_poMainApp->poGetGenericWrapper()->vOnSourceActivity(enSrcNum, ARL_EN_ISRC_ACT_OFF);
         }
      }
      break;
   }
   return TRUE;
}

/*******************************************************************************
 *
 * FUNCTION:    fc_messaging_tclAudioRouteHandler::bOnMuteState
 *
 * DESCRIPTION: Result for own mute / demute request.
 *
 * PARAMETER:   enSrcNum:               (I)   source number
 *              rfcoSrcActivity:        (I)   source activity
 *
 * RETURNVALUE: TRUE
 *
 *******************************************************************************/
tBool fc_messaging_tclAudioRouteHandler::bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState)
{
   ETG_TRACE_USR4(("fc_messaging_tclAudioRouteHandler::bOnMuteState entered"));
   (tVoid) enSrcNum; //lint fix
   (tVoid) enMuteState; //lint fix
   return TRUE;
}

tBool fc_messaging_tclAudioRouteHandler::bAudioRouteRequest(arl_tenSource enSrcNum)
{
   ETG_TRACE_USR4(("fc_messaging_tclAudioRouteHandler::bAudioRouteRequest entered"));

   if (FALSE == bSetAudioRouteRequest(enSrcNum, ARL_EN_ISRC_ACT_ON))
   {
      ETG_TRACE_USR4(("Audio Route(ON) request posting failed!!"));
      return FALSE;
   }
   return TRUE;
}

tBool fc_messaging_tclAudioRouteHandler::bAudioReleaseRequest(arl_tenSource enSrcNum)
{
   ETG_TRACE_USR4(("fc_messaging_tclAudioRouteHandler::bAudioReleaseRequest entered"));

   if (FALSE == bSetAudioRouteRequest(enSrcNum, ARL_EN_ISRC_ACT_OFF))
   {
      ETG_TRACE_USR4(("Audio Route(OFF) request posting failed!!"));
      return FALSE;
   }
   return TRUE;
}
