/**
 * @file LcmRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the LcmRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for LcmRequestIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef LcmRequestIf_h
#define LcmRequestIf_h

#include "LcmCallBackIf.h"
#include "ICreateDestroyProxy.h"
#include "ILcmRequestIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class LcmRequestIf final : public asf::core::ServiceAvailableIF
, public ICreateDestroyProxy
, public ILcmRequestIf
{
public:
   /**
    * Constructor of LcmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   LcmRequestIf();

   /**
    * Destructor of LcmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~LcmRequestIf();

   /**
    * Member function Overridden from ILcmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setLcmCallBackIf(ILcmCallBackIf*) override;

   /**
    * Member function Overridden from ILcmRequestIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setSpmPhoneSubState(const pmcore::BdAddress deviceAddress, const bool phoneSubState) override;

protected:
   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void createProxy(const std::string portName) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void destroyProxy() override;

   /**
    * Member function Overridden from ILcmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerProperties() override;

   /**
    * Member function Overridden from ILcmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void deregisterProperties() override;

private:
   LcmDBusFiProxy _lcmFiProxy;
   ILcmCallBackIf* _lcmCallBackIf;

   // The below list of device addresses is those who has a valid Phone sub state true.
   pmcore::BdAddressList _bdAddressListOfPhoneSubState;

   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //LcmRequestIf_h
