/**
 * @file IpcMessageDispatcher.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IpcMessageDispatcher class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "IpcMessageDispatcher.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/IpcMessageDispatcher.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

void IpcMessageDispatcher::registerMsgHandler(MessageHandlerBase* pMsgHandler)
{
   ETG_TRACE_USR4(("IpcMessageDispatcher::registerMsgHandler entered"));

   _msgHandlerlist.push_back(pMsgHandler);
}

// TODO: Name of the function to be reconsidered
void IpcMessageDispatcher::unRegisterMsgHandlers()
{
   ETG_TRACE_USR4(("IpcMessageDispatcher::unRegisterMsgHandlers entered"));

   _msgHandlerlist.clear();
}

void IpcMessageDispatcher::updatePropertyChanged(PropertyUpdate* pPropertyUpdate)
{
   ETG_TRACE_USR4(("IpcMessageDispatcher::updatePropertyChanged entered"));

   if(pPropertyUpdate)
   {
      std::list<MessageHandlerBase*>::iterator msgHandlerListIterator;

      for (msgHandlerListIterator = _msgHandlerlist.begin(); msgHandlerListIterator != _msgHandlerlist.end(); msgHandlerListIterator++)
      {
         if(nullptr != (*msgHandlerListIterator))
         {
            (*msgHandlerListIterator)->onPropertyUpdate(pPropertyUpdate);
         }
         else
         {
            // The code execution will reach this place only on a coding error
            ETG_TRACE_ERR(("IpcMessageDispatcher::Invalid Message Handler"));
         }
      }
   }
   else
   {
      // This should not happen, only when property update is not sent correctly from CPP layer flow comes here
      ETG_TRACE_ERR(("IpcMessageDispatcher::updatePropertyChanged Invalid property update"));
   }
}
