/**
 * @file QueriedContactInfo.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the QueriedContactInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "QueriedContactInfo.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/QueriedContactInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#endif
#endif

using namespace pmcore;

namespace com
{
namespace bosch
{
namespace pmapp
{

QueriedContactInfo::QueriedContactInfo() : _firstName(""), _lastName(""), _contactHandle(CONTACT_HANDLE_DEFAULT)
{
}

QueriedContactInfo::QueriedContactInfo(const FirstName& firstName, const LastName& lastName,
      const ContactHandle& contactHandle) :
      _firstName(firstName), _lastName(lastName), _contactHandle(contactHandle)
{
}

QueriedContactInfo::QueriedContactInfo(const QueriedContactInfo& other) :
      _firstName(other._firstName), _lastName(other._lastName), _contactHandle(other._contactHandle)
{
}

QueriedContactInfo::~QueriedContactInfo()
{
}

void swap(QueriedContactInfo& first, QueriedContactInfo& second)
{
   using std::swap;

   swap(first._firstName, second._firstName);
   swap(first._lastName, second._lastName);
   swap(first._contactHandle, second._contactHandle);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
QueriedContactInfo& QueriedContactInfo::operator=(QueriedContactInfo other)
{
   swap(*this, other);

   return *this;
}

bool QueriedContactInfo::operator==(const QueriedContactInfo& rhs) const
{
   return ((this->_firstName == rhs._firstName)
         && (this->_lastName == rhs._lastName)
         && (this->_contactHandle == rhs._contactHandle));
}

bool QueriedContactInfo::operator!=(const QueriedContactInfo& rhs) const
{
   return (!(operator==(rhs)));
}

} // namespace pmapp
} // namespace bosch
} // namespace com
