/**
 * @file DialRequestInfo.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the DialRequestInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef DialRequestInfo_h
#define DialRequestInfo_h

#include "PmInterfaceTypesInternal.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class DialRequestInfo
{
public:
   /**
    * Constructor of DialRequestInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DialRequestInfo();

   /**
    * Parameterized Constructor of DialRequestInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DialRequestInfo(const pmcore::BdAddress& deviceAddress, const pmcore::TelephoneNumber& telephonenumber,
         const pmcore::ActType actType);

   /**
    * Copy Constructor of DialRequestInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DialRequestInfo(const DialRequestInfo& other);

   /**
    * Destructor of DialRequestInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~DialRequestInfo();

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(DialRequestInfo& first, DialRequestInfo& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   DialRequestInfo& operator=(DialRequestInfo other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const DialRequestInfo& rhs) const;

   /**
    * Overloading '!=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator!=(const DialRequestInfo& rhs) const;

   /**
    * Overloading '<' operator so that it can be used as a key in std::map
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator< (const DialRequestInfo& rhs) const;

   pmcore::BdAddress       _deviceAddress;   // Device address
   pmcore::TelephoneNumber _telephoneNumber; // Telephone number
   pmcore::ActType         _act;             // Act, used when Dial requested is responded with Error
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // DialRequestInfo_h
