/**
 * @file CallsReport.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallsReport class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef CallsReport_h
#define CallsReport_h

#include "CallAttributes.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class CallsReport
{
public:
   /**
    * Constructor of CallsReport class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   CallsReport();

   /**
    * Parameterized Constructor of CallsReport class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   CallsReport(const pmcore::Multiparty multiparty, const CallAttributesList& callAttributesList);

   /**
    * Copy Constructor of CallsReport class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   CallsReport(const CallsReport& other);

   /**
    * Destructor of CallsReport class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~CallsReport();

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(CallsReport& first, CallsReport& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   CallsReport& operator=(CallsReport other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const CallsReport& rhs) const;

   /**
    * Overloading '!=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator!=(const CallsReport& rhs) const;

   /**
    * This function is used to print the call report details
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void printCallsReport();

   pmcore::Multiparty   _multiparty;         /**< multiparty */
   CallAttributesList   _callAttributesList; /**< call attributes list */
};

// Device specific  call attributes list
typedef std::map<pmcore::BdAddress, CallsReport> CallsReportList; /**< call attributes list map */

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // CallsReport_h
