/**
 * @file IMediaPlayerRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IMediaPlayerRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for IMediaPlayerRequestIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef IMediaPlayerRequestIf_h
#define IMediaPlayerRequestIf_h

namespace com
{
namespace bosch
{
namespace pmapp
{

class IMediaPlayerCallBackIf;

class IMediaPlayerRequestIf
{
public:

   /**
    * Virtual destructor of IMediaPlayerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~IMediaPlayerRequestIf() {}

   /**
    * This function is called to set the callback interface object of the MediaPlayer Application.
    *
    * @param[in] IMediaPlayerCallBackIf* - Pointer to the Callback Interface of MediaPlayer client.
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setMediaPlayerCallBackIf(IMediaPlayerCallBackIf*) = 0;
   
protected:
   /**
    * Parameterized constructor of IMediaPlayerRequestIf
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   IMediaPlayerRequestIf(bool serviceAvailability){_serviceAvailability = serviceAvailability;}

   /**
    * Once the service is available, this function is called to register
    * the required properties of Phonebook application.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerProperties() = 0;

   /**
    * Once the service becomes unavailable, this function is called to de-register
    * the registered properties of Phonebook application.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void deregisterProperties() = 0;

   bool _serviceAvailability;
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //IMediaPlayerRequestIf_h
