/**
 * @file IMediaPlayerCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IMediaPlayerCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for IMediaPlayerCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef IMediaPlayerCallBackIf_h
#define IMediaPlayerCallBackIf_h

#include "mplay_MediaPlayer_FIProxy.h"

using namespace mplay_MediaPlayer_FI;
using namespace ::asf::core;

namespace com
{
namespace bosch
{
namespace pmapp
{
typedef ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > MplayMediaPlayerFIProxy;

class IMediaPlayerCallBackIf : public ReadyToPlayCallbackIF

{
public:

   /**
    * Virtual destructor of IMediaPlayerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~IMediaPlayerCallBackIf() {}

   /**
    * This function is used to set the proxy "MOST_PhonBk_FIProxy".
    * This proxy is received as one of the parameters in the callback functions.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setMediaPlayerFiProxy(MplayMediaPlayerFIProxy mplayMediaPlayerFIProxy) = 0;

   /**
   * Callback method for onReadyToPlayError Signal
   *
   * @param[in] proxy - A reference to Mplay_MediaPlayer_FIProxy
   * @param[in] error - ReadyToPlayError status
   * @param[out]
   * @param[in,out]
   *
   * @return void
   */
   virtual void onReadyToPlayError(const ::boost::shared_ptr< Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ReadyToPlayError >& error) override = 0;

   /**
   * Callback method for onReadyToPlayStatus Signal
   *
   * @param[in] proxy - A reference to Mplay_MediaPlayer_FIProxy
   * @param[in] status - ReadyToPlayStatus
   * @param[out]
   * @param[in,out]
   *
   * @return void
   */
   virtual void onReadyToPlayStatus(const ::boost::shared_ptr< Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ReadyToPlayStatus >& status) override = 0;

protected:

   MplayMediaPlayerFIProxy _mplayMediaPlayerFIProxy;
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //IMediaPlayerCallBackIf_h
