/**
 * @file IDiagSystemSettings.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IDiagSystemSettings class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for IDiagSystemSettings class
 *
 * @ingroup IpcWrapper
 */

#ifndef IDiagSystemSettings_h
#define IDiagSystemSettings_h

#include "asf/core/BaseComponent.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

using namespace ::asf::core;

using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

class IDiagSystemSettings : public SystemSettings1Stub
{

public:
   /**
    * Virtual destructor of interface class IDiagSystemSettings
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~IDiagSystemSettings() { }

   /**
    * This function is called to prepare the PM for executing the system settings.
    *
    * @param[in] request - Request information from Diagnosis component
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onPrepareSystemSettingRequest(
         const ::boost::shared_ptr< PrepareSystemSettingRequest >& request) override = 0;

   /**
    * This function is called to execute the system settings. On this request,
    * PM has to reset the user data (or) restore the default data in the persistent memory of PM
    *
    * @param[in] request - Request information from Diagnosis component
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onExecuteSystemSettingRequest(
         const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request) override = 0;

   /**
    * This function is called to finalize the execution of system settings.
    *
    * @param[in] request - Request information from Diagnosis component
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onFinalizeSystemSettingRequest(
         const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request) override = 0;

   /**
    * This function is invoked to send the response to Diagnosis component after restoring / clearing the
    * user data stored persistently in PM
    *
    * @param[in]  operationSuccess  -  Success / Failure response
    *             act_t             -  Acknowledgement token
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onRestoreDefaultSettingResponse(const bool operationSuccess, const act_t act) = 0;

protected:
   /**
    * Parameterized constructor of IDiagSystemSettings
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   IDiagSystemSettings(const std::string& portName) : SystemSettings1Stub (portName){}
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // IDiagSystemSettings_h
