/**
 * @file ICreateDestroyProxy.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the ICreateDestroyProxy class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for ICreateDestroyProxy class
 *
 * @ingroup IpcWrapper
 */

#ifndef ICreateDestroyProxy_h
#define ICreateDestroyProxy_h

namespace com
{
namespace bosch
{
namespace pmapp
{
class ICreateDestroyProxy
{
protected:
   /**
    * Virtual destructor of the interface class ICreateDestroyProxy
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~ICreateDestroyProxy() {}

   /**
    * This function is called to create proxy for the corresponding interface.
    *
    * @param[in] std::string - Port name where the service interface is imported.
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void createProxy(const std::string portName) = 0;

   /**
    * This function is called to destroy the proxy of the corresponding interface.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void destroyProxy() = 0;
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //ICreateDestroyProxy_h
