/**
 * @file IBmAppCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IBmAppCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for IBmAppCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef IBmAppCallBackIf_h
#define IBmAppCallBackIf_h

#include "IpcMsgTypes.h"
#include "MOST_BTSet_FIProxy.h"

using namespace most_BTSet_fi_types_Extended;
using namespace MOST_BTSet_FI;

namespace com
{
namespace bosch
{
namespace pmapp
{

typedef ::boost::shared_ptr< MOST_BTSet_FI::MOST_BTSet_FIProxy > MostBTSetFiProxy;

class IBmAppCallBackIf : public MOST_BTSet_FI::DeviceListExtendedCallbackIF
, public MOST_BTSet_FI::SetPrimaryCallbackIF
, public MOST_BTSet_FI::VehicleConfigurationCallbackIF
, public MOST_BTSet_FI::SetBTProfilesUsageCallbackIF
{
public:

   /**
    * Virtual destructor of the interface class IBmAppCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~IBmAppCallBackIf() {}

   /**
    * This function is used to set the proxy "MOST_BTSet_FIProxy".
    * This proxy is received as one of the parameters in the callback functions.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setBtSetFIProxy(MostBTSetFiProxy btSetFIProxy) = 0;

protected:
   /**
    * Error callback for getDeviceListExtended
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            DeviceListExtendedError - Received Error information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onDeviceListExtendedError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::DeviceListExtendedError >& ) override = 0;

   /**
    * This function is invoked when the "DeviceListExtendedStatus" is updated.
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            DeviceListExtendedStatus - Received DeviceListExtended Status information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onDeviceListExtendedStatus(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::DeviceListExtendedStatus >& ) override = 0;

   /**
    * Error callback for getVehicleConfiguration
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            VehicleConfigurationError - Received VehicleConfiguration error information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onVehicleConfigurationError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::VehicleConfigurationError >& ) override = 0;

   /**
    * This function is invoked when the "VehicleConfiguration" is updated.
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            VehicleConfigurationStatus - Received VehicleConfiguration status information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onVehicleConfigurationStatus(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::VehicleConfigurationStatus >&) override = 0;

   /**
    * Error callback for SetPrimary method call.
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            SetPrimaryError - Received Error status information for SetPrimary method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetPrimaryError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetPrimaryError >& ) override = 0;

   /**
    * Callback function for SetPrimary method call
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            SetPrimaryResult - Received result information for SetPrimary method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetPrimaryResult(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetPrimaryResult >& ) override = 0;

   /**
    * Error callback for SetBTProfilesUsage method call.
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            SetPrimaryError - Received Error status information for SetBTProfilesUsage method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetBTProfilesUsageError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetBTProfilesUsageError >& ) override = 0;

   /**
    * Callback function for SetBTProfilesUsage method call
    *
    * @param[in] MostBTSetFiProxy - Registered BT Settings Fi proxy
    *            SetPrimaryResult - Received result information for SetBTProfilesUsage method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetBTProfilesUsageResult(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetBTProfilesUsageResult >& ) override = 0;

   MostBTSetFiProxy _btSetFIProxy;
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //IBmAppCallBackIf_h
