/**
 * @file PmAppCcaServer.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmAppCcaServer class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details The CCA application and service for PmApp to receive CCA messages are created here
 *
 * @ingroup IpcWrapper
 */

#include "PmAppCcaServer.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmAppCcaServer.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaMessageHandler* PmAppCcaServer::getCcaMsgHandler()
{
   return _pCcaMsgHandler;
}

AhlApp* PmAppCcaServer::getPmApplication()
{
   return _pAhlApp;
}

PmAppCcaServer::PmAppCcaServer()
{
   // TODO: All the Instrumentation code is added for testing purpose only, will be removed soon.
   ETG_TRACE_USR4(("Instrumentation purpose : PmAppCcaServer::PmAppCcaServer() entered"));
   ETG_TRACE_ERRMEM(("Instrumentation purpose : PmAppCcaServer::PmAppCcaServer() entered"));

   _pAhlApp = new AhlApp(CCA_C_U16_APP_TELEFON);

   _pAhlService = new AhlService(_pAhlApp, CCA_C_U16_SRV_FB_TELEPHONE, MOST_TELFI_C_U16_SERVICE_MAJORVERSION,
         MOST_TELFI_C_U16_SERVICE_MINORVERSION);

   _pCcaMsgHandler = new CcaMessageHandler(_pAhlService);

   if (_pAhlApp->bInitInstance(0, CCA_C_U16_APP_TELEFON, OSAL_ThreadWhoAmI()) == FALSE)
   {
      ETG_TRACE_ERR(("Instrumentation purpose : bInitInstance() FAILED"));
      ETG_TRACE_ERRMEM(("Instrumentation purpose : PmAppCcaServer::bInitInstance() FAILED"));
   }
}

void PmAppCcaServer::setServiceAvailable(bool value)
{
   ETG_TRACE_USR4(("Instrumentation purpose : PmAppCcaServer::setServiceAvailable() entered"));
   ETG_TRACE_ERRMEM(("Instrumentation purpose : PmAppCcaServer::setServiceAvailable() entered"));
   _pAhlService->setPmCcaServiceAvailability(value);
}

PmAppCcaServer::~PmAppCcaServer()
{
   ETG_TRACE_USR4(("PmAppCcaServer::~PmAppCcaServer() entered"));

   if(_pAhlApp)
   {
      delete _pAhlApp;
      _pAhlApp = nullptr;
   }

   if(_pAhlService)
   {
      delete _pAhlService;
      _pAhlService = nullptr;
   }

   if(_pCcaMsgHandler)
   {
      delete _pCcaMsgHandler;
      _pCcaMsgHandler = nullptr;
   }
}
