/**
 * @file CcaWaitingModeStateHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaWaitingModeStateHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaWaitingModeStateHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaWaitingModeStateHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaWaitingModeStateHandler::CcaWaitingModeStateHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaWaitingModeStateHandler::CcaWaitingModeStateHandler entered"));
}

void CcaWaitingModeStateHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaWaitingModeStateHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getWaitingModeState(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgWaitingModeStateStatus oWaitingModeStateStatus;

      oWaitingModeStateStatus.e8WaitingModeState.enType =
            most_fi_tcl_e8_WaitingModeState::tenType::FI_EN_E8WAITING_MODE_IDLE;

      updateOpcodeStatus(act, oWaitingModeStateStatus, PM_PROPERTYID_WAITINGMODESTATE);
      oWaitingModeStateStatus.vDestroy();
   }
}

void CcaWaitingModeStateHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_WAITINGMODESTATE, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaWaitingModeStateHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaWaitingModeStateHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaWaitingModeStateHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaWaitingModeStateHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaWaitingModeStateHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaWaitingModeStateHandler::dispatchProperty entered"));

   WaitingModeStatePropertyUpdate* waitingModeStatePropertyUpdate =
         static_cast<WaitingModeStatePropertyUpdate*> (propertyUpdate);

   ETG_TRACE_USR4(("CcaWaitingModeStateHandler::_waitingModeState :%d",ETG_CENUM(WaitingModeStateEnumType,
         waitingModeStatePropertyUpdate->_waitingModeStateObj._waitingModeState)));

   most_telfi_tclMsgWaitingModeStateStatus oWaitingModeStateStatus;
   most_fi_tcl_e8_WaitingModeState oWaitingModeState;

   switch(waitingModeStatePropertyUpdate->_waitingModeStateObj._waitingModeState)
   {
      case WAITING_MODE_ACTIVE:
      {
         oWaitingModeState.enType = most_fi_tcl_e8_WaitingModeState::tenType::FI_EN_E8WAITING_MODE_ACTIVE;
      }
      break;
      case WAITING_MODE_STARTING:
      {
         oWaitingModeState.enType = most_fi_tcl_e8_WaitingModeState::tenType::FI_EN_E8WAITING_MODE_STARTING;
      }
      break;
      case WAITING_MODE_STOPPING:
      {
         oWaitingModeState.enType = most_fi_tcl_e8_WaitingModeState::tenType::FI_EN_E8WAITING_MODE_STOPPING;
      }
      break;
      default:
      {
         oWaitingModeState.enType = most_fi_tcl_e8_WaitingModeState::tenType::FI_EN_E8WAITING_MODE_IDLE;
      }
   }

   oWaitingModeStateStatus.e8WaitingModeState = oWaitingModeState;

   updateOpcodeStatus(waitingModeStatePropertyUpdate->_u64TokenId, oWaitingModeStateStatus,
         waitingModeStatePropertyUpdate->u16GetFunctionID());
   oWaitingModeStateStatus.vDestroy();
}

void CcaWaitingModeStateHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
