/**
 * @file CcaVehicleAudioHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaVehicleAudioHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaVehicleAudioHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaVehicleAudioHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaVehicleAudioHandler::CcaVehicleAudioHandler(ahl_tclBaseOneThreadService* pAhlService) : CcaProperty(pAhlService),
      _audioActiveStatus(false)
{
   ETG_TRACE_USR4(("CcaVehicleAudioHandler::CcaVehicleAudioHandler entered"));
}

void CcaVehicleAudioHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaVehicleAudioHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getPhoneCallAudioActive(act);
   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgVehicleAudioStatus oVehicleAudioStatus;
      oVehicleAudioStatus.bUsingVehicleAudio = _audioActiveStatus;

      updateOpcodeStatus(act, oVehicleAudioStatus, PM_PROPERTYID_VEHICLEAUDIO);
      oVehicleAudioStatus.vDestroy();
   }
}

void CcaVehicleAudioHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_VEHICLEAUDIO, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaVehicleAudioHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaVehicleAudioHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaVehicleAudioHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaVehicleAudioHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaVehicleAudioHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaVehicleAudioHandler::dispatchProperty entered"));

   PhoneCallAudioPropertyUpdate* phoneCallAudioPropertyUpdate =
         static_cast<PhoneCallAudioPropertyUpdate*> (propertyUpdate);

   _audioActiveStatus = phoneCallAudioPropertyUpdate->_phoneCallAudioActive._status;

   most_telfi_tclMsgVehicleAudioStatus oVehicleAudioStatus;
   oVehicleAudioStatus.bUsingVehicleAudio = _audioActiveStatus;
   ETG_TRACE_USR1(("VehicleAudioStatus:%u", oVehicleAudioStatus.bUsingVehicleAudio));

   updateOpcodeStatus(phoneCallAudioPropertyUpdate->_u64TokenId, oVehicleAudioStatus,
         phoneCallAudioPropertyUpdate->u16GetFunctionID());

   CcaCallStatusListHandler::getInstance().onAudioActiveStatusChanged(_audioActiveStatus);

   oVehicleAudioStatus.vDestroy();
}

void CcaVehicleAudioHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
