/**
 * @file CcaSuppressRingtoneOnOffListHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSuppressRingtoneOnOffListHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSuppressRingtoneOnOffListHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSuppressRingtoneOnOffListHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSuppressRingtoneOnOffListHandler::CcaSuppressRingtoneOnOffListHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffListHandler::CcaSuppressRingtoneOnOffListHandler entered"));
}

void CcaSuppressRingtoneOnOffListHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffListHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getSuppressRingtoneOnOffList(act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgSuppressRingtoneOnOffListStatus suppressRingtoneOnOffListStatus;
      updateOpcodeStatus(act, suppressRingtoneOnOffListStatus, PM_PROPERTYID_SUPPRESSRINGTONEONOFFLIST);
      suppressRingtoneOnOffListStatus.vDestroy();
   }
}

void CcaSuppressRingtoneOnOffListHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_SUPPRESSRINGTONEONOFFLIST, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaSuppressRingtoneOnOffListHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffListHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaSuppressRingtoneOnOffListHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffListHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaSuppressRingtoneOnOffListHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffListHandler::dispatchProperty entered"));

   SuppressRingtoneOnOffListPropertyUpdate* suppressRingtoneOnOffListPropertyUpdate =
         static_cast<SuppressRingtoneOnOffListPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgSuppressRingtoneOnOffListStatus suppressRingtoneOnOffListStatus;
   most_fi_tcl_TelSuppressRingtoneOnOffListResultItem  suppressRingtoneOnOffListResultItem;

   SuppressRingtoneOnOffListMap suppressRingtoneOnOffListMap =
         suppressRingtoneOnOffListPropertyUpdate->_suppressRingtoneOnOffList._suppressRingtoneOnOffList;

   for (auto& iter : suppressRingtoneOnOffListMap)
   {
      suppressRingtoneOnOffListResultItem.sBdAddress.bSet(iter.first.c_str());
      suppressRingtoneOnOffListResultItem.bSuppressRingtoneState = iter.second;
      suppressRingtoneOnOffListStatus.oSuppressRingtoneOnOffListResult.oItems.push_back(suppressRingtoneOnOffListResultItem);
   }

   updateOpcodeStatus(suppressRingtoneOnOffListPropertyUpdate->_u64TokenId, suppressRingtoneOnOffListStatus,
         suppressRingtoneOnOffListPropertyUpdate->u16GetFunctionID());

   suppressRingtoneOnOffListStatus.vDestroy();
}

void CcaSuppressRingtoneOnOffListHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
