/**
 * @file CcaSlcStatusHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSlcStatusHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSlcStatusHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSlcStatusHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSlcStatusHandler::CcaSlcStatusHandler(ahl_tclBaseOneThreadService* pAhlService) : CcaProperty(pAhlService),
      _slcStatus(false)
{
   ETG_TRACE_USR4(("CcaSlcStatusHandler::CcaSlcStatusHandler entered"));
}

void CcaSlcStatusHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaSlcStatusHandler::onOpcodeGet entered"));
   (void) pInMsg;

   most_telfi_tclMsgSLCStatusStatus oSLCStatusStatus;
   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   oSLCStatusStatus.bCommandStatus = (deviceAddress.empty()) ? false : true;

   updateOpcodeStatus(act, oSLCStatusStatus, PM_PROPERTYID_SLCSTATUS);
   oSLCStatusStatus.vDestroy();
}

void CcaSlcStatusHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_SLCSTATUS, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaSlcStatusHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSlcStatusHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaSlcStatusHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSlcStatusHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaSlcStatusHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSlcStatusHandler::dispatchProperty entered"));

   ActivePassiveDeviceListPropertyUpdate* activePassiveDeviceListPropertyUpdate =
         static_cast<ActivePassiveDeviceListPropertyUpdate*> (propertyUpdate);

   // If Map is empty, it implies that no Active and Passive devices are connected.
   // And hence SLC status will be "FALSE".
   bool slcStatus = false;

   if (!(activePassiveDeviceListPropertyUpdate->_activePassiveDeviceListObj._activePassiveDeviceList.empty()))
   {
      slcStatus = true;
   }

   bool updateChange = true;

   if (DEFAULT_ACT == activePassiveDeviceListPropertyUpdate->_u64TokenId)
   {
      ETG_TRACE_USR4(("This is an update from PM core"));

      if (_slcStatus != slcStatus)
      {
         _slcStatus = slcStatus;
      }
      else
      {
         updateChange = false;
      }
   }

   if (updateChange)
   {
      most_telfi_tclMsgSLCStatusStatus oSLCStatusStatus;
      oSLCStatusStatus.bCommandStatus = slcStatus;
      updateOpcodeStatus(activePassiveDeviceListPropertyUpdate->_u64TokenId, oSLCStatusStatus,
            activePassiveDeviceListPropertyUpdate->u16GetFunctionID());
      oSLCStatusStatus.vDestroy();
   }
}

void CcaSlcStatusHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
