/**
 * @file CcaSendDTMFFailedEventHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSendDTMFFailedEventHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSendDTMFFailedEventHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSendDTMFFailedEventHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSendDTMFFailedEventHandler::CcaSendDTMFFailedEventHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaSendDTMFFailedEventHandler::CcaSendDTMFFailedEventHandler entered"));
}

void CcaSendDTMFFailedEventHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaSendDTMFFailedEventHandler::onOpcodeGet entered"));
   (void) pInMsg;

   // Get is not possible for this property. This function will be invoked only during UPREG.
   // As of now the default value is updated.
   most_telfi_tclMsgSendDTMFFailedEventStatus oSendDTMFFailedEventStatus;
   oSendDTMFFailedEventStatus.sBdAddress.bSet((const char*)"");
   oSendDTMFFailedEventStatus.sSendDTMFFailedReason.bSet((const char*)"");

   updateOpcodeStatus(act, oSendDTMFFailedEventStatus, PM_PROPERTYID_SENDDTMFFAILEDEVENT);
   oSendDTMFFailedEventStatus.vDestroy();
}

void CcaSendDTMFFailedEventHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_SENDDTMFFAILEDEVENT, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaSendDTMFFailedEventHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSendDTMFFailedEventHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaSendDTMFFailedEventHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSendDTMFFailedEventHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaSendDTMFFailedEventHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSendDTMFFailedEventHandler::dispatchProperty entered"));

   PmNotificationEventPropertyUpdate* sendDTMFFailedEvent =
         static_cast<PmNotificationEventPropertyUpdate*> (propertyUpdate);

   std::map<std::string, std::string> eventInfoMap = sendDTMFFailedEvent->_eventInfoMap;

   BdAddress deviceAddress = "";
   std::string failedReason = "";

   auto eventInfoMapIter = eventInfoMap.find("DeviceAddress");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      deviceAddress = eventInfoMapIter->second;
   }

   eventInfoMapIter = eventInfoMap.find("FailureReason");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      failedReason = eventInfoMapIter->second;
   }


   most_telfi_tclMsgSendDTMFFailedEventStatus oSendDTMFFailedEventStatus;

   oSendDTMFFailedEventStatus.sBdAddress.bSet(deviceAddress.c_str());
   oSendDTMFFailedEventStatus.sSendDTMFFailedReason.bSet(failedReason.c_str());

   ETG_TRACE_USR1(("oSendDTMFFailedEventStatus.sBdAddress :%s",
         oSendDTMFFailedEventStatus.sBdAddress.szValue));
   ETG_TRACE_USR1(("oSendDTMFFailedEventStatus.sSendDTMFFailedReason.szValue :%s",
         oSendDTMFFailedEventStatus.sSendDTMFFailedReason));

   updateOpcodeStatus(sendDTMFFailedEvent->_u64TokenId, oSendDTMFFailedEventStatus,
         PM_PROPERTYID_SENDDTMFFAILEDEVENT);
   oSendDTMFFailedEventStatus.vDestroy();
}

void CcaSendDTMFFailedEventHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
