/**
 * @file CcaRingtonePlaybackStatusHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaRingtonePlaybackStatusHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaRingtonePlaybackStatusHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaRingtonePlaybackStatusHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaRingtonePlaybackStatusHandler::CcaRingtonePlaybackStatusHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaRingtonePlaybackStatusHandler::CcaRingtonePlaybackStatusHandler entered"));
}

void CcaRingtonePlaybackStatusHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaRingtonePlaybackStatusHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getRingtonePlaybackStatus(act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgRingtonePlaybackStatusStatus oRingtonePlaybackStatusStatus;
      oRingtonePlaybackStatusStatus.e8PlaybackState.enType =
                        most_fi_tcl_e8_TelPlaybackState::tenType::FI_EN_E8NOT_PLAYING;

      updateOpcodeStatus(act, oRingtonePlaybackStatusStatus, PM_PROPERTYID_RINGTONEPLAYBACKSTATUS);
      oRingtonePlaybackStatusStatus.vDestroy();
   }
}

void CcaRingtonePlaybackStatusHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_RINGTONEPLAYBACKSTATUS, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaRingtonePlaybackStatusHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaRingtonePlaybackStatusHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaRingtonePlaybackStatusHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaRingtonePlaybackStatusHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaRingtonePlaybackStatusHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaRingtonePlaybackStatusHandler::dispatchProperty entered"));

   RingtonePlaybackStatusPropertyUpdate* ringtonePlaybackStatusPropertyUpdate =
         static_cast<RingtonePlaybackStatusPropertyUpdate*> (propertyUpdate);

   RingtonePlaybackStateType ringtonePlaybackState =
         ringtonePlaybackStatusPropertyUpdate->_ringtonePlaybackState._ringtonePlaybackState;
   ETG_TRACE_USR1(("ringtonePlaybackState: %u", ETG_CENUM(RingtonePlaybackStateType ,ringtonePlaybackState)));

   most_telfi_tclMsgRingtonePlaybackStatusStatus oRingtonePlaybackStatusStatus;

   switch (ringtonePlaybackState)
   {
      case RT_STARTING:
         oRingtonePlaybackStatusStatus.e8PlaybackState.enType =
               most_fi_tcl_e8_TelPlaybackState::tenType::FI_EN_E8STARTING;
         break;
      case RT_PLAYING:
         oRingtonePlaybackStatusStatus.e8PlaybackState.enType =
               most_fi_tcl_e8_TelPlaybackState::tenType::FI_EN_E8PLAYING;
         break;
      case RT_STOPPING:
         oRingtonePlaybackStatusStatus.e8PlaybackState.enType =
               most_fi_tcl_e8_TelPlaybackState::tenType::FI_EN_E8STOPPING;
         break;
      default:
         oRingtonePlaybackStatusStatus.e8PlaybackState.enType =
               most_fi_tcl_e8_TelPlaybackState::tenType::FI_EN_E8NOT_PLAYING;
   }

   ETG_TRACE_USR4(("oRingtonePlaybackStatusStatus.e8PlaybackState.enType: %u",
         oRingtonePlaybackStatusStatus.e8PlaybackState.enType));

   updateOpcodeStatus(ringtonePlaybackStatusPropertyUpdate->_u64TokenId, oRingtonePlaybackStatusStatus,
         ringtonePlaybackStatusPropertyUpdate->u16GetFunctionID());

   oRingtonePlaybackStatusStatus.vDestroy();
}

void CcaRingtonePlaybackStatusHandler::processOpcodeSetError(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaRingtonePlaybackStatusHandler::processPropertySetError entered"));
   (void) responseMsg;
}
