/**
 * @file CcaRingtoneMuteStateHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaRingtoneMuteStateHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaRingtoneMuteStateHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaRingtoneMuteStateHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaRingtoneMuteStateHandler::CcaRingtoneMuteStateHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::CcaRingtoneMuteStateHandler entered"));
}

void CcaRingtoneMuteStateHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getRingtoneMuteState(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgRingtoneMuteStateStatus oRingtoneMuteStateStatus;
      oRingtoneMuteStateStatus.bEnable = false;

      updateOpcodeStatus(act, oRingtoneMuteStateStatus, PM_PROPERTYID_RINGTONEMUTESTATE);
      oRingtoneMuteStateStatus.vDestroy();
   }
}

void CcaRingtoneMuteStateHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::onOpcodeSet entered"));
   
   most_telfi_tclMsgRingtoneMuteStatePureSet ringtoneMuteStateMsg;

   getDataFromAmt(pInMsg, ringtoneMuteStateMsg);

   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler:: State : %d", ringtoneMuteStateMsg.bEnable));

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().setRingtoneMuteState(deviceAddress,
         ringtoneMuteStateMsg.bEnable, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::onOpcodeSet failed"));
      removeEntryFromRequestMap(act);
   }

   ringtoneMuteStateMsg.vDestroy();
}

void CcaRingtoneMuteStateHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaRingtoneMuteStateHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaRingtoneMuteStateHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::dispatchProperty entered"));

   RingtoneMuteStatePropertyUpdate* ringtoneMuteStatePropertyUpdate =
         static_cast<RingtoneMuteStatePropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgRingtoneMuteStateStatus oRingtoneMuteStateStatus;
   oRingtoneMuteStateStatus.bEnable = ringtoneMuteStatePropertyUpdate->_ringtoneMuteStateObj._ringtoneMuteState;
   ETG_TRACE_USR1(("oRingtoneMuteStateStatus.bEnable:%d", oRingtoneMuteStateStatus.bEnable));

   updateOpcodeStatus(ringtoneMuteStatePropertyUpdate->_u64TokenId, oRingtoneMuteStateStatus,
         ringtoneMuteStatePropertyUpdate->u16GetFunctionID());
   oRingtoneMuteStateStatus.vDestroy();
}

void CcaRingtoneMuteStateHandler::processOpcodeSetError(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaRingtoneMuteStateHandler::processPropertySetError entered"));
   (void) responseMsg;
}
