/**
 * @file CcaOutgoingCallFailedEventHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaOutgoingCallFailedEventHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaOutgoingCallFailedEventHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaOutgoingCallFailedEventHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaOutgoingCallFailedEventHandler::CcaOutgoingCallFailedEventHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaOutgoingCallFailedEventHandler::CcaOutgoingCallFailedEventHandler entered"));
}

void CcaOutgoingCallFailedEventHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaOutgoingCallFailedEventHandler::onOpcodeGet entered"));
   (void) pInMsg;

   // Get is not possible for this property. This function will be invoked only during UPREG.
   // As of now the default value is updated.
   // TODO: Need to check whether the Recent status need to be updated.
   most_telfi_tclMsgOutgoingCallFailedEventStatus oOutgoingCallFailedEventStatus;
   oOutgoingCallFailedEventStatus.oOutgoingFailed.u8DeviceHandle = PM_DEVICEHANDLE_ZERO;
   oOutgoingCallFailedEventStatus.oOutgoingFailed.sTelephoneNumber.bSet((const char*)"");
   oOutgoingCallFailedEventStatus.oOutgoingFailed.sName.bSet((const char*)"");
   oOutgoingCallFailedEventStatus.oOutgoingFailed.sOutgoingCallFailedReason.bSet((const char*)"");

   updateOpcodeStatus(act, oOutgoingCallFailedEventStatus, PM_PROPERTYID_OUTGOINGCALLFAILEDEVENT);
   oOutgoingCallFailedEventStatus.vDestroy();
}

void CcaOutgoingCallFailedEventHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_OUTGOINGCALLFAILEDEVENT, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaOutgoingCallFailedEventHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaOutgoingCallFailedEventHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaOutgoingCallFailedEventHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaOutgoingCallFailedEventHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaOutgoingCallFailedEventHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaOutgoingCallFailedEventHandler::dispatchProperty entered"));

   PmNotificationEventPropertyUpdate* pmNotificationEventPropertyUpdate =
         static_cast<PmNotificationEventPropertyUpdate*> (propertyUpdate);

   std::map<std::string, std::string> eventInfoMap = pmNotificationEventPropertyUpdate->_eventInfoMap;

   BdAddress deviceAddress = "";
   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
   TelephoneNumber telephoneNumber = "";
   FirstName firstName = "";
   LastName lastName = "";
   std::string failureReason = "";

   // TODO: Re-think on the logic whether oOutgoingCallFailedEventStatus.oOutgoingFailed.sName
   // should include First Name + Last name

   std::map<std::string, std::string>::iterator eventInfoMapIter;

   eventInfoMapIter = eventInfoMap.find("DeviceAddress");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      deviceAddress = eventInfoMapIter->second;
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle(deviceAddress, deviceHandle);
   }
   eventInfoMapIter = eventInfoMap.find("TelephoneNumber");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      telephoneNumber = eventInfoMapIter->second;
   }
   eventInfoMapIter = eventInfoMap.find("FailureReason");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      failureReason = eventInfoMapIter->second;
   }
   eventInfoMapIter = eventInfoMap.find("FirstName");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      firstName = eventInfoMapIter->second;
   }
   eventInfoMapIter = eventInfoMap.find("LastName");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      lastName = eventInfoMapIter->second;
   }

   most_telfi_tclMsgOutgoingCallFailedEventStatus oOutgoingCallFailedEventStatus;
   oOutgoingCallFailedEventStatus.oOutgoingFailed.u8DeviceHandle = deviceHandle;
   oOutgoingCallFailedEventStatus.oOutgoingFailed.sTelephoneNumber.bSet(telephoneNumber.c_str());

   if(!(firstName.empty()))
   {
      oOutgoingCallFailedEventStatus.oOutgoingFailed.sName.bSet(firstName.c_str());
   }
   else
   {
      oOutgoingCallFailedEventStatus.oOutgoingFailed.sName.bSet((const char*)"");
   }
   oOutgoingCallFailedEventStatus.oOutgoingFailed.sOutgoingCallFailedReason.bSet(failureReason.c_str());

   ETG_TRACE_USR1(("oOutgoingCallFailedEventStatus.u8DeviceHandle :%d",
         oOutgoingCallFailedEventStatus.oOutgoingFailed.u8DeviceHandle));
   ETG_TRACE_USR1(("oOutgoingCallFailedEventStatus.sTelephoneNumber.szValue :%s",
         oOutgoingCallFailedEventStatus.oOutgoingFailed.sTelephoneNumber.szValue));
   ETG_TRACE_USR1(("oOutgoingCallFailedEventStatus.sName.szValue :%s",
         oOutgoingCallFailedEventStatus.oOutgoingFailed.sName.szValue));
   ETG_TRACE_USR1(("oOutgoingCallFailedEventStatus.sOutgoingCallFailedReason.szValue :%s",
         oOutgoingCallFailedEventStatus.oOutgoingFailed.sOutgoingCallFailedReason.szValue));

   updateOpcodeStatus(pmNotificationEventPropertyUpdate->_u64TokenId, oOutgoingCallFailedEventStatus,
         pmNotificationEventPropertyUpdate->u16GetFunctionID());

   oOutgoingCallFailedEventStatus.vDestroy();
}

void CcaOutgoingCallFailedEventHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
