/**
 * @file CcaNetworkOperatorHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaNetworkOperatorHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaNetworkOperatorHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaNetworkOperatorHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaNetworkOperatorHandler::CcaNetworkOperatorHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaNetworkOperatorHandler::CcaNetworkOperatorHandler entered"));
}

void CcaNetworkOperatorHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaNetworkOperatorHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getNetworkOperator(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgNetworkOperatorStatus oNetworkOperatorStatus;

      // TOCHECK: Device handle is not a parameter in NetworkOperator property of CCA
      oNetworkOperatorStatus.sNetworkOperator.bSet((const char*)"");

      updateOpcodeStatus(act, oNetworkOperatorStatus, PM_PROPERTYID_NETWORKOPERATOR);
      oNetworkOperatorStatus.vDestroy();
   }
}

void CcaNetworkOperatorHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_NETWORKOPERATOR, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaNetworkOperatorHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaNetworkOperatorHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaNetworkOperatorHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaNetworkOperatorHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaNetworkOperatorHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaNetworkOperatorHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<NetworkOperator>* networkOperatorPropertyUpdate =
         static_cast<AgInfoPropertyUpdate<NetworkOperator>*> (propertyUpdate);

   most_telfi_tclMsgNetworkOperatorStatus oNetworkOperatorStatus;

   // TOCHECK: Device handle is not a parameter in NetworkOperator property of CCA
   oNetworkOperatorStatus.sNetworkOperator.bSet(networkOperatorPropertyUpdate->_value._networkOperator.c_str());
   ETG_TRACE_USR1(("Operator: %s", oNetworkOperatorStatus.sNetworkOperator.szGet()));

   updateOpcodeStatus(networkOperatorPropertyUpdate->_u64TokenId, oNetworkOperatorStatus,
         networkOperatorPropertyUpdate->u16GetFunctionID());
   oNetworkOperatorStatus.vDestroy();
}

void CcaNetworkOperatorHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
