/**
 * @file CcaMicrophoneMuteStateHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaMicrophoneMuteStateHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaMicrophoneMuteStateHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaMicrophoneMuteStateHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaMicrophoneMuteStateHandler::CcaMicrophoneMuteStateHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::CcaMicrophoneMuteStateHandler entered"));
}

void CcaMicrophoneMuteStateHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getMicrophoneMuteState(act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgMicrophoneMuteStateStatus oMicrophoneMuteStateStatus;
      oMicrophoneMuteStateStatus.bEnable = false;
      updateOpcodeStatus(act, oMicrophoneMuteStateStatus, PM_PROPERTYID_MICROPHONEMUTESTATE);
      oMicrophoneMuteStateStatus.vDestroy();
   }
}

void CcaMicrophoneMuteStateHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::onOpcodeSet entered"));

   most_telfi_tclMsgMicrophoneMuteStatePureSet microphoneMuteStateMsg;

   getDataFromAmt(pInMsg, microphoneMuteStateMsg);

   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler:: State : %d", microphoneMuteStateMsg.bEnable));

   MuteState muteState = microphoneMuteStateMsg.bEnable;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().setMicrophoneMuteState(muteState, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::onOpcodeSet failed"));
      PmCoreResponseData pmCoreResponseData(pmresult, act);
      processOpcodeSetError(&pmCoreResponseData);
   }

   microphoneMuteStateMsg.vDestroy();
}

void CcaMicrophoneMuteStateHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaMicrophoneMuteStateHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaInComingCallEventHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaMicrophoneMuteStateHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::dispatchProperty entered"));

   MicMuteStatePropertyUpdate* micMuteStatePropertyUpdate = static_cast<MicMuteStatePropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgMicrophoneMuteStateStatus oMicrophoneMuteStateStatus;
   oMicrophoneMuteStateStatus.bEnable = micMuteStatePropertyUpdate->_microphoneMuteStateObj._microphoneMuteState;
   ETG_TRACE_USR1(("oMicrophoneMuteStateStatus:%d", oMicrophoneMuteStateStatus.bEnable));
   updateOpcodeStatus(micMuteStatePropertyUpdate->_u64TokenId, oMicrophoneMuteStateStatus,
         micMuteStatePropertyUpdate->u16GetFunctionID());
   oMicrophoneMuteStateStatus.vDestroy();
}

void CcaMicrophoneMuteStateHandler::processOpcodeSetError(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaMicrophoneMuteStateHandler::processPropertySetError entered"));

   most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode;

//   ETG_TRACE_USR3((" most_fi_tcl_e8_ErrorCode::FI_EN_BUSY"));
//   e8ErrorCode = most_fi_tcl_e8_ErrorCode::FI_EN_BUSY;

   ETG_TRACE_USR3((" most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE"));
   e8ErrorCode = most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE;

   most_telfi_tclMsgMicrophoneMuteStateError oMicrophoneMuteStateError;
   oMicrophoneMuteStateError.e8ErrorCode.enType = e8ErrorCode;

   updateOpcodeStatus(responseMsg->_u64TokenId, oMicrophoneMuteStateError);
}
