
/**
 * @file CcaIncomingCallRejectedEventHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaIncomingCallRejectedEventHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaIncomingCallRejectedEventHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaIncomingCallRejectedEventHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaIncomingCallRejectedEventHandler::CcaIncomingCallRejectedEventHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaIncomingCallRejectedEventHandler::CcaIncomingCallRejectedEventHandler entered"));
}

void CcaIncomingCallRejectedEventHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaIncomingCallRejectedEventHandler::onOpcodeGet entered"));
   (void) pInMsg;

   // Get is not possible for this property. This function will be invoked only during UPREG.
   // As of now the default value is updated.
   // TODO: Need to check whether the Recent status need to be updated.
   most_telfi_tclMsgIncomingCallRejectedEventStatus oCallRejectedEventStatus;

   oCallRejectedEventStatus.oIncomingRejected.u8DeviceHandle = PM_DEVICEHANDLE_ZERO;
   oCallRejectedEventStatus.oIncomingRejected.sTelephoneNumber.bSet((const char*)"");
   oCallRejectedEventStatus.oIncomingRejected.sIncomingCallRejectedReason.bSet((const char*)"");

   updateOpcodeStatus(act, oCallRejectedEventStatus, PM_PROPERTYID_INCOMINGCALLREJECTEDEVENT);
   oCallRejectedEventStatus.vDestroy();
}

void CcaIncomingCallRejectedEventHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_INCOMINGCALLREJECTEDEVENT, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaIncomingCallRejectedEventHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaIncomingCallRejectedEventHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaIncomingCallRejectedEventHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaInComingCallEventHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaIncomingCallRejectedEventHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaIncomingCallRejectedEventHandler::dispatchProperty entered"));

   PmNotificationEventPropertyUpdate* pmNotificationEventPropertyUpdate =
         static_cast<PmNotificationEventPropertyUpdate*> (propertyUpdate);

   std::map<std::string, std::string> eventInfoMap = pmNotificationEventPropertyUpdate->_eventInfoMap;

   BdAddress deviceAddress = "";
   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;

   TelephoneNumber telephoneNumber = "";
   std::string failureReason = "";

   std::map<std::string, std::string>::iterator eventInfoMapIter;

   eventInfoMapIter = eventInfoMap.find("DeviceAddress");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      deviceAddress = eventInfoMapIter->second;
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle(deviceAddress, deviceHandle);
   }
   eventInfoMapIter = eventInfoMap.find("TelephoneNumber");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      telephoneNumber = eventInfoMapIter->second;
   }
   eventInfoMapIter = eventInfoMap.find("FailureReason");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      failureReason = eventInfoMapIter->second;
   }

   most_telfi_tclMsgIncomingCallRejectedEventStatus oCallRejectedEventStatus;

   oCallRejectedEventStatus.oIncomingRejected.u8DeviceHandle = deviceHandle;
   oCallRejectedEventStatus.oIncomingRejected.sTelephoneNumber.bSet(telephoneNumber.c_str());
   oCallRejectedEventStatus.oIncomingRejected.sIncomingCallRejectedReason.bSet(failureReason.c_str());

   ETG_TRACE_USR1(("oCallRejectedEventStatus.oIncomingRejected.u8DeviceHandle :%d",
         oCallRejectedEventStatus.oIncomingRejected.u8DeviceHandle));
   ETG_TRACE_USR1(("oCallRejectedEventStatus.oIncomingRejected.sTelephoneNumber :%s",
         oCallRejectedEventStatus.oIncomingRejected.sTelephoneNumber.szValue));
   ETG_TRACE_USR1(("oCallRejectedEventStatus.oIncomingRejected.sIncomingCallRejectedReason :%s",
         oCallRejectedEventStatus.oIncomingRejected.sIncomingCallRejectedReason.szValue));

   updateOpcodeStatus(pmNotificationEventPropertyUpdate->_u64TokenId, oCallRejectedEventStatus,
         pmNotificationEventPropertyUpdate->u16GetFunctionID());
   oCallRejectedEventStatus.vDestroy();
}

void CcaIncomingCallRejectedEventHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
