/**
 * @file CcaHandsFreeEnhancedCallControlHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaHandsFreeEnhancedCallControlHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaHandsFreeEnhancedCallControlHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaHandsFreeEnhancedCallControlHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaHandsFreeEnhancedCallControlHandler::CcaHandsFreeEnhancedCallControlHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaHandsFreeEnhancedCallControlHandler::CcaHandsFreeEnhancedCallControlHandler entered"));
}

void CcaHandsFreeEnhancedCallControlHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaHandsFreeEnhancedCallControlHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getSupportedFeatures(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgHandsFreeEnhancedCallControlStatus oEnhancedCallControlStatus;
      updateOpcodeStatus(act, oEnhancedCallControlStatus, PM_PROPERTYID_HANDSFREEENHANCEDCALLCONTROL);
      oEnhancedCallControlStatus.vDestroy();
   }
}

void CcaHandsFreeEnhancedCallControlHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_HANDSFREEENHANCEDCALLCONTROL, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaHandsFreeEnhancedCallControlHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaHandsFreeEnhancedCallControlHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaHandsFreeEnhancedCallControlHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaHandsFreeEnhancedCallControlHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaHandsFreeEnhancedCallControlHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaHandsFreeEnhancedCallControlHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<SupportedFeatures>* supportedFeaturesPropertyUpdate =
         static_cast<AgInfoPropertyUpdate<SupportedFeatures>*> (propertyUpdate);

   most_telfi_tclMsgHandsFreeEnhancedCallControlStatus oEnhancedCallControlStatus;
   most_fi_tcl_TelHFEnhancedCallControlStreamItem oActivePhoneItem;

   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle
         (supportedFeaturesPropertyUpdate->_deviceAddress, deviceHandle);

   oActivePhoneItem.u8DeviceHandle = deviceHandle;
   ETG_TRACE_USR1(("oActivePhoneItem.u8DeviceHandle:%u", oActivePhoneItem.u8DeviceHandle));
   SupportedFeaturesType supportedFeaturesList = supportedFeaturesPropertyUpdate->_value._supportedFeatures;

   oActivePhoneItem.bEndTargetCall = false;
   oActivePhoneItem.bSplitMergedCalls = false;

   for (auto& supportedFeature : supportedFeaturesList)
   {
      //As per HFP Specification v1.7.1, 4.32 Enhanced Call Control Mechanisms
      //Enhanced Call Control indicates that the following features are supported in device:
      //1. Release Specified Call Index
      //2. Private Consultation Mode
      if ("enhanced_call_control" == supportedFeature)
      {
         oActivePhoneItem.bEndTargetCall = true;
         oActivePhoneItem.bSplitMergedCalls = true;
      }
   }

   ETG_TRACE_USR1(("oActivePhoneItem.bEndTargetCall:%u", oActivePhoneItem.bEndTargetCall));
   ETG_TRACE_USR1(("oActivePhoneItem.bSplitMergedCalls:%u", oActivePhoneItem.bSplitMergedCalls));

   //Currently it supports only one active phone.
   oEnhancedCallControlStatus.oHFEnhancedCallControlStream.oItems.push_back(oActivePhoneItem);

   updateOpcodeStatus(supportedFeaturesPropertyUpdate->_u64TokenId, oEnhancedCallControlStatus,
         supportedFeaturesPropertyUpdate->u16GetFunctionID());
   oEnhancedCallControlStatus.vDestroy();
}

void CcaHandsFreeEnhancedCallControlHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
