/**
 * @file CcaExternalVRStateHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaExternalVRStateHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaExternalVRStateHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaExternalVRStateHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaExternalVRStateHandler::CcaExternalVRStateHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaExternalVRStateHandler::CcaActivePhoneDeviceHandler entered"));
}

void CcaExternalVRStateHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaExternalVRStateHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().getExternalVRState(deviceAddress, act);

   if(PM_RESULT_OK != pmResult._pmResultCode)
   {
      most_telfi_tclMsgExternalVRStateStatus externalVRStateStatus;
      updateOpcodeStatus(act, externalVRStateStatus, PM_PROPERTYID_EXTERNALVRSTATE);
      externalVRStateStatus.vDestroy();
   }
}

void CcaExternalVRStateHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_EXTERNALVERSTATE, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaExternalVRStateHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaExternalVRStateHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaExternalVRStateHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaExternalVRStateHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaExternalVRStateHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaExternalVRStateHandler::dispatchProperty entered"));

   ExternalVRStatePropertyUpdate* externalVRStatePropertyUpdate =
         static_cast<ExternalVRStatePropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgExternalVRStateStatus externalVRStateStatus;

   externalVRStateStatus.sBdAddress.bSet(externalVRStatePropertyUpdate->_deviceAddress.c_str());

   switch(externalVRStatePropertyUpdate->_externalVRStatus)
   {
      case EXT_VR_SESSION_READY:
         externalVRStateStatus.e8ExternalVRState.enType = most_fi_tcl_e8_ExternalVRState::FI_EN_E8READY;
         break;
      case EXT_VR_SESSION_ACTIVE:
         externalVRStateStatus.e8ExternalVRState.enType = most_fi_tcl_e8_ExternalVRState::FI_EN_E8ACTIVE;
         break;
      case EXT_VR_SESSION_IDLE:
      default:
         externalVRStateStatus.e8ExternalVRState.enType = most_fi_tcl_e8_ExternalVRState::FI_EN_E8IDLE;
         break;
   }

   switch(externalVRStatePropertyUpdate->_vrInterruptedReason)
   {
      case pmcore::HFP_CALL:
         externalVRStateStatus.e8VRErrorCode.enType = most_fi_tcl_e8_VRErrorCode::FI_EN_E8ERROR_PHONE_CALL_ACTIVE;
         break;
      case pmcore::AUDIO_CHANNEL_RELEASED:
         externalVRStateStatus.e8VRErrorCode.enType = most_fi_tcl_e8_VRErrorCode::FI_EN_E8ERROR_IN_STREAMING;
         break;
      default:
         externalVRStateStatus.e8VRErrorCode.enType = most_fi_tcl_e8_VRErrorCode::FI_EN_E8NO_ERROR;
         break;
   }

   updateOpcodeStatus(externalVRStatePropertyUpdate->_u64TokenId, externalVRStateStatus,
         externalVRStatePropertyUpdate->u16GetFunctionID());
   externalVRStateStatus.vDestroy();
}

void CcaExternalVRStateHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
