/**
 * @file CcaAudioTransferFailedEventHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaAudioTransferFailedEventHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaAudioTransferFailedEventHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaAudioTransferFailedEventHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaAudioTransferFailedEventHandler::CcaAudioTransferFailedEventHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaAudioTransferFailedEventHandler::CcaAudioTransferFailedEventHandler entered"));
}

void CcaAudioTransferFailedEventHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaAudioTransferFailedEventHandler::onOpcodeGet entered"));
   (void) pInMsg;

   // Get is not possible for this property. This function will be invoked only during UPREG.
   // As of now the default value is updated.

   most_telfi_tclMsgAudioTransferFailedEventStatus oAudioTransferFailedEventStatus;
   oAudioTransferFailedEventStatus.e8AudioDirection.enType =
         (most_fi_tcl_e8_AudioTransferDirection::FI_EN_E8HF_TO_AG);
   oAudioTransferFailedEventStatus.sBdAddress.bSet((const char*)"");

   updateOpcodeStatus(act, oAudioTransferFailedEventStatus, PM_PROPERTYID_AUDIOTRANSFERFAILEDEVENT);
   oAudioTransferFailedEventStatus.vDestroy();
}

void CcaAudioTransferFailedEventHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_AUDIOTRANSFERFAILEDEVENT, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaAudioTransferFailedEventHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaAudioTransferFailedEventHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaAudioTransferFailedEventHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaAudioTransferFailedEventHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaAudioTransferFailedEventHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaAudioTransferFailedEventHandler::dispatchProperty entered"));

   PmNotificationEventPropertyUpdate* audioTransferFailedEvent =
         static_cast<PmNotificationEventPropertyUpdate*> (propertyUpdate);

   std::map<std::string, std::string> eventInfoMap = audioTransferFailedEvent->_eventInfoMap;

   BdAddress deviceAddress = "";
   std::string errorName = "";

   auto eventInfoMapIter = eventInfoMap.find("DeviceAddress");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      deviceAddress = eventInfoMapIter->second;
   }

   eventInfoMapIter = eventInfoMap.find("EventName");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      errorName = eventInfoMapIter->second;
   }

   most_telfi_tclMsgAudioTransferFailedEventStatus oAudioTransferFailedEventStatus;

   oAudioTransferFailedEventStatus.sBdAddress.bSet(deviceAddress.c_str());
   oAudioTransferFailedEventStatus.e8AudioDirection.enType = (most_fi_tcl_e8_AudioTransferDirection::FI_EN_E8HF_TO_AG);

   if("TransferCallAudioToHF Failed" == errorName)
   {
      oAudioTransferFailedEventStatus.e8AudioDirection.enType = (most_fi_tcl_e8_AudioTransferDirection::FI_EN_E8AG_TO_HF);
   }


   ETG_TRACE_USR1(("oAudioTransferFailedEventStatus.e8Direction.enType :%d",
         oAudioTransferFailedEventStatus.e8AudioDirection.enType));
   ETG_TRACE_USR1(("oAudioTransferFailedEventStatus.sBdAddress.szValue :%s",
         oAudioTransferFailedEventStatus.sBdAddress.szValue));

   updateOpcodeStatus(audioTransferFailedEvent->_u64TokenId, oAudioTransferFailedEventStatus, PM_PROPERTYID_AUDIOTRANSFERFAILEDEVENT);
   oAudioTransferFailedEventStatus.vDestroy();
}

void CcaAudioTransferFailedEventHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
