/**
 * @file CcaVoiceRecognitionExtendedHandler.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaVoiceRecognitionExtendedHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef CcaVoiceRecognitionExtended_h
#define CcaVoiceRecognitionExtended_h

#include "CcaProperty.h"

/*
 * Handler class for CCA property - MOST_TELFI_C_U16_BTDEVICEVOICERECOGNITIONEXTENDED
 */
class CcaVoiceRecognitionExtendedHandler final: public CcaProperty
{

public:

   /**
    * Constructor of CcaVoiceRecognitionExtendedHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   CcaVoiceRecognitionExtendedHandler(ahl_tclBaseOneThreadService* pAhlService);

   /**
    * Destructor of CcaVoiceRecognitionExtendedHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~CcaVoiceRecognitionExtendedHandler();

protected:

   /**
    * Actual processing of the CCA message takes place here and forward
    * request to IpcWrapper. From IpcWrapper request is posted to PM CORE CPP.
    * This method is invoked when client does a GET on PmApp CCA property
    *
    * @param[in] amt_tclServiceData* - Pointer to the CCA message data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOpcodeGet(amt_tclServiceData* pInMsg, const pmcore::ActType act) override;

   /**
    * Actual processing of the CCA message takes place here and forward
    * request to IpcWrapper. From IpcWrapper request is posted to PM CORE CPP
    * This method is invoked when client does a SET on PmApp CCA property
    *
    * @param[in] amt_tclServiceData* - Pointer to the CCA message data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOpcodeSet(amt_tclServiceData* pInMsg, const pmcore::ActType act) override;

   /**
    * PM shall update clients on the property updates received from CPP interfaces.
    *
    * @param[in] PropertyUpdate* - pointer to the property update data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onPropertyUpdate(PropertyUpdate* pPropertyUpdate) override;

   /**
    * Overridden from the CcaProperty class
    *
    * @param[in]  PmCoreResponseData* - Pointer to the response data from CPP layer
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void processOpcodeSetError(PmCoreResponseData* pInMsg) override;

   /**
    * Overridden from CcaProperty class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   template<typename TPropertyType>
   void dispatchProperty(TPropertyType* propertyUpdate);

   /**
    * Overridden from CcaProperty class
    *
    * @param[in] PmCoreResponseData* responseMsg - cpp respone received from PM Core
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void processOpcodeGetResponse(PmCoreResponseData* responseMsg) override;

private:

   // This parameter is used to store the Enhanced VR status of a device when received from PM core.
   // And this will be used whenever the VR status is updated to the clients.
   std::map<pmcore::DeviceHandle, pmcore::EnhancedVoiceRecognitionFeature> _vrExtendedStatusInfoMap;

   /**
    * This method is used to set the Enhanced VR feature support parameter ("e8SiriAvailabilityState")
    * from the received enhancedVoiceRecognitionFeature
    *
    * @param[in]
    *    EnhancedVoiceRecognitionFeature& enhancedVoiceRecognitionFeature - Reference to EnhancedVoiceRecognitionFeature
    *    most_fi_tcl_e8_TelSiriAvailabilityState& e8SiriAvailabilityState - Ref to most_fi_tcl_e8_TelSiriAvailabilityState
    *
    * @param[out]
    *    most_fi_tcl_e8_TelSiriAvailabilityState& e8SiriAvailabilityState - Ref to most_fi_tcl_e8_TelSiriAvailabilityState
    *
    * @param[in,out]
    *
    * @return
    *
    */
   void setEnhancedVRAvailabilityStatusForCCAMost
   (const pmcore::EnhancedVoiceRecognitionFeature& enhancedVoiceRecognitionFeature,
         most_fi_tcl_e8_TelSiriAvailabilityState& e8SiriAvailabilityState);
};

#endif // CcaVoiceRecognitionExtended_h
